/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import divinerpg.registries.SoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.common.Tags;

public abstract class EntityDivineMerchant
extends AbstractVillager {
    public EntityDivineMerchant(EntityType<? extends EntityDivineMerchant> type, Level level) {
        super(type, level);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
    }

    public abstract String[] getChatMessages();

    protected void m_8058_(MerchantOffer offer) {
        int i = 3 + this.f_19796_.m_188503_(4);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 0));
        if (offer.m_45383_()) {
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), i));
        }
    }

    public boolean m_7296_(int i) {
        return i > 2;
    }

    public int m_5792_() {
        return 2;
    }

    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public SoundEvent m_7596_() {
        return SoundEvents.f_12508_;
    }

    protected float m_6431_(Pose p_35297_, EntityDimensions p_35298_) {
        return 1.62f;
    }

    protected SoundEvent m_7515_() {
        return switch (this.f_19796_.m_188503_(3)) {
            case 0 -> (SoundEvent)SoundRegistry.MERCHANT_3.get();
            case 2 -> (SoundEvent)SoundRegistry.MERCHANT_2.get();
            default -> (SoundEvent)SoundRegistry.MERCHANT_1.get();
        };
    }

    public int m_8100_() {
        return 160;
    }

    protected SoundEvent m_7975_(DamageSource p_35498_) {
        return (SoundEvent)SoundRegistry.MERCHANT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.MERCHANT_HURT.get();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_6616_().isEmpty()) {
            if (this.needsToRestock()) {
                this.restock();
            }
            this.updateSpecialPrices(player);
            this.m_7189_(player);
            this.m_45301_(player, this.m_5446_(), 1);
            String[] messages = this.getChatMessages();
            if (messages.length > 0) {
                player.m_5661_((Component)Component.m_237115_((String)messages[player.f_19796_.m_188503_(this.getChatMessages().length)]), true);
            }
        } else {
            this.setUnhappy();
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7862_() {
        return true;
    }

    public boolean m_7826_() {
        return false;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public void restock() {
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            merchantoffer.m_45369_();
            merchantoffer.m_45372_();
        }
    }

    private boolean needsToRestock() {
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            if (!merchantoffer.m_45382_()) continue;
            return true;
        }
        return false;
    }

    protected void updateSpecialPrices(Player player) {
        if (player != this.f_20888_) {
            for (MerchantOffer offer : this.m_6616_()) {
                offer.m_45353_(-Mth.m_14143_((float)offer.m_45378_()));
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_35303_() > 0) {
            this.m_35319_(this.m_35303_() - 1);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() instanceof Player || source.m_7639_() instanceof Player) {
            this.m_9236_().m_7605_((Entity)this, (byte)13);
        }
        this.setUnhappy();
        return super.m_6469_(source, amount);
    }

    public void m_7822_(byte type) {
        if (type == 12) {
            this.m_35287_((ParticleOptions)ParticleTypes.f_123750_);
        } else if (type == 13) {
            this.m_35287_((ParticleOptions)ParticleTypes.f_123792_);
        } else if (type == 14) {
            this.m_35287_((ParticleOptions)ParticleTypes.f_123748_);
        } else if (type == 42) {
            this.m_35287_((ParticleOptions)ParticleTypes.f_123769_);
        } else {
            super.m_7822_(type);
        }
    }

    public void m_7189_(@Nullable Player player) {
        boolean flag = this.m_7962_() != null && player == null;
        super.m_7189_(player);
        if (flag) {
            this.m_7996_();
        }
    }

    private void setUnhappy() {
        this.m_35319_(40);
    }

    protected void m_7996_() {
        super.m_7996_();
        this.resetSpecialPrices();
    }

    private void resetSpecialPrices() {
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            merchantoffer.m_45376_();
        }
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType type) {
        return !level.m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_MUSHROOM) && !level.m_204166_(this.m_20183_()).m_203565_(Biomes.f_220594_);
    }

    public static class DivineMapTrades
    extends DivineTrades {
        private final String displayName;
        private final TagKey<Structure> destination;
        private final MapDecoration.Type destinationType;

        public DivineMapTrades(ItemStack input1, ItemStack input2, String displayName, TagKey<Structure> destination, MapDecoration.Type destinationType, int xp) {
            super(input1, input2, null, 1, xp);
            this.displayName = displayName;
            this.destination = destination;
            this.destinationType = destinationType;
        }

        public DivineMapTrades(ItemStack input1, String displayName, TagKey<Structure> destination, MapDecoration.Type destinationType, int xp) {
            this(input1, ItemStack.f_41583_, displayName, destination, destinationType, xp);
        }

        @Override
        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            if (!(entity.m_9236_() instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverlevel = (ServerLevel)entity.m_9236_();
            BlockPos blockpos = serverlevel.m_215011_(this.destination, entity.m_20183_(), 100, true);
            if (blockpos != null) {
                ItemStack itemstack = MapItem.m_42886_((Level)serverlevel, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                MapItem.m_42850_((ServerLevel)serverlevel, (ItemStack)itemstack);
                MapItemSavedData.m_77925_((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)this.destinationType);
                itemstack.m_41714_((Component)Component.m_237115_((String)this.displayName));
                return new MerchantOffer(this.input1, this.input2, itemstack, 1, this.xp, 0.0f);
            }
            return null;
        }
    }

    public static class DivineTrades
    implements VillagerTrades.ItemListing {
        protected ItemStack input1;
        protected ItemStack input2;
        private ItemStack output;
        protected int xp;
        protected int stock;

        public DivineTrades(ItemStack input1, ItemStack input2, ItemStack output, int stock, int xp) {
            this.xp = xp;
            this.stock = stock + 1;
            this.output = output;
            this.input1 = input1;
            this.input2 = input2;
        }

        public DivineTrades(ItemStack input1, ItemStack output, int stock, int xp) {
            this(input1, ItemStack.f_41583_, output, stock, xp);
        }

        public MerchantOffer m_213663_(Entity tradeEnt, RandomSource rand) {
            return new MerchantOffer(this.input1, this.input2, this.output, this.stock, this.xp, 0.0f);
        }
    }
}

