/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.registries.SoundRegistry;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityAyeraco
extends EntityDivineBoss {
    public BlockPos beam = BlockPos.f_121853_;
    private static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.m_135353_(Mob.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private EntityAyeraco[] group = new EntityAyeraco[5];
    private boolean angry;
    private boolean empowered;
    private boolean projectileProtected;
    private boolean magicProtected;
    private boolean canTeleport;
    private boolean canHeal;
    private boolean fast;
    private boolean broadcast = false;
    private CompoundTag tag;
    private Vec3 moveTargetPoint = Vec3.f_82478_;
    private boolean circling = true;
    private BlockPos anchorPoint = BlockPos.f_121853_;

    public EntityAyeraco(EntityType<? extends Monster> type, Level level) {
        this(type, level, BlockPos.f_121853_, 6, null);
    }

    public EntityAyeraco(EntityType<? extends Monster> type, Level level, BlockPos beam, byte variant) {
        this(type, level, beam, variant, null);
    }

    public EntityAyeraco(EntityType<? extends Monster> type, Level worldIn, BlockPos beam, byte variant, EntityAyeraco[] group) {
        super(type, worldIn);
        this.beam = beam;
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
        this.f_21342_ = new AyeracoMoveControl((Mob)this);
        this.f_21365_ = new AyeracoLookControl((Mob)this);
        this.assignGroup(group);
    }

    protected BodyRotationControl m_7560_() {
        return new AyeracoBodyRotationControl((Mob)this);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new AyeracoAttackStrategyGoal());
        this.f_21345_.m_25352_(2, (Goal)new AyeracoSweepAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new AyeracoCircleAroundAnchorGoal());
        this.f_21346_.m_25352_(1, (Goal)new AyeracoAttackPlayerTargetGoal());
    }

    public EntityAyeraco assignGroup(EntityAyeraco[] group) {
        EntityAyeraco[] entityAyeracoArray = this.group = group == null || group.length != 5 ? new EntityAyeraco[1] : group;
        if (this.group.length == 5) {
            this.updateAbilities();
        }
        return this;
    }

    public void updateAbilities() {
        this.angry = this.m_21223_() < this.m_21233_() / 2.0f;
        this.updateAbilities(this.angry);
    }

    public void updateAbilities(boolean angry) {
        if (!this.m_9236_().m_5776_()) {
            switch ((Byte)this.f_19804_.m_135370_(VARIANT)) {
                case 0: {
                    for (EntityAyeraco entity : this.group) {
                        if (entity == null) continue;
                        entity.empowered = angry;
                    }
                    break;
                }
                case 1: {
                    for (EntityAyeraco entity : this.group) {
                        if (entity == null) continue;
                        entity.projectileProtected = angry;
                    }
                    break;
                }
                case 2: {
                    for (EntityAyeraco entity : this.group) {
                        if (entity == null) continue;
                        entity.magicProtected = angry;
                    }
                    break;
                }
                case 3: {
                    for (EntityAyeraco entity : this.group) {
                        if (entity == null) continue;
                        entity.canTeleport = angry;
                    }
                    break;
                }
                case 4: {
                    for (EntityAyeraco entity : this.group) {
                        if (entity == null) continue;
                        entity.canHeal = angry;
                    }
                    break;
                }
                case 5: {
                    for (EntityAyeraco entity : this.group) {
                        if (entity == null) continue;
                        entity.fast = angry;
                    }
                    break;
                }
            }
            if (angry && this.m_6084_()) {
                boolean b = this.group[0] == null;
                for (int by = 1; b && by < 5; by = (int)((byte)(by + 1))) {
                    b = this.group[by] == null;
                }
                if (b) {
                    this.fast = true;
                    this.canTeleport = true;
                    this.magicProtected = true;
                    this.projectileProtected = true;
                    this.empowered = true;
                }
            }
            if (this.empowered && this.m_6084_()) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 255, 2, true, false, false));
            } else {
                this.m_21195_(MobEffects.f_19600_);
            }
            if (this.fast && this.m_6084_()) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 255, 2, true, false, false));
            } else {
                this.m_21195_(MobEffects.f_19596_);
            }
            if (this.canTeleport && this.m_6084_()) {
                this.m_5496_((SoundEvent)SoundRegistry.AYERACO_TELEPORT.get(), 2.0f, 0.4f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
                this.m_6027_(this.m_20185_() + (double)this.f_19796_.m_188503_(5) - 2.0, this.m_20186_() + 3.0 + (double)this.f_19796_.m_188503_(15), this.m_20189_() + (double)this.f_19796_.m_188503_(5) - 2.0);
            }
        }
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.updateAbilities(false);
        if (this.m_9236_().m_46749_(this.beam)) {
            this.m_9236_().m_7731_(this.beam, Blocks.f_50016_.m_49966_(), 3);
        }
        if (this.group != null) {
            for (EntityAyeraco ayeraco : this.group) {
                if (ayeraco == null) continue;
                ayeraco.removeFromGroup((Byte)this.f_19804_.m_135370_(VARIANT));
            }
        }
    }

    public void removeFromGroup(byte variant) {
        for (int i = 0; i < 5; ++i) {
            EntityAyeraco ayeraco = this.group[i];
            if (ayeraco == null || (Byte)ayeraco.f_19804_.m_135370_(VARIANT) != variant) continue;
            this.group[i] = null;
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source) || this.projectileProtected && source.m_276093_(DamageTypes.f_268534_) || this.magicProtected && source.m_276093_(DamageTypes.f_268515_)) {
            return false;
        }
        this.updateAbilities();
        return super.m_6469_(source, amount);
    }

    public void m_5634_(float amount) {
        if (this.m_6084_()) {
            super.m_5634_(amount);
            this.updateAbilities();
        }
    }

    @Override
    public BossEvent.BossBarColor getBarColor() {
        return EntityAyeraco.byByte((Byte)this.f_19804_.m_135370_(VARIANT));
    }

    public static BossEvent.BossBarColor byByte(byte i) {
        return switch (i) {
            case 0 -> BossEvent.BossBarColor.BLUE;
            case 1 -> BossEvent.BossBarColor.GREEN;
            case 2 -> BossEvent.BossBarColor.PINK;
            case 3 -> BossEvent.BossBarColor.PURPLE;
            case 4 -> BossEvent.BossBarColor.RED;
            case 5 -> BossEvent.BossBarColor.YELLOW;
            default -> BossEvent.BossBarColor.WHITE;
        };
    }

    public byte getVariant() {
        if ((Byte)this.f_19804_.m_135370_(VARIANT) == 6) {
            BlockState block = this.m_9236_().m_8055_(this.beam);
            if (block.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "ayeraco_beam_blue")))) {
                return 0;
            }
            if (block.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "ayeraco_beam_green")))) {
                return 1;
            }
            if (block.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "ayeraco_beam_pink")))) {
                return 2;
            }
            if (block.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "ayeraco_beam_purple")))) {
                return 3;
            }
            if (block.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "ayeraco_beam_red")))) {
                return 4;
            }
            if (block.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "ayeraco_beam_yellow")))) {
                return 5;
            }
        }
        return (Byte)this.f_19804_.m_135370_(VARIANT);
    }

    public EntityAyeraco setVariant(byte variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
        return this;
    }

    public EntityAyeraco setBeamPos(BlockPos pos) {
        this.beam = pos;
        return this;
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void m_7840_(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.AYERACO.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SoundRegistry.AYERACO_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.AYERACO_HURT.get();
    }

    protected float m_6431_(Pose pose, EntityDimensions dim) {
        return 0.65625f;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        for (int i = 0; i < 5; ++i) {
            if (this.group[i] == null) continue;
            tag.m_128362_("Group" + i, this.group[i].f_19820_);
        }
        tag.m_128356_("Beam", this.beam.m_121878_());
        tag.m_128344_("Variant", ((Byte)this.f_19804_.m_135370_(VARIANT)).byteValue());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.loadExtra(tag);
        this.broadcast = true;
        this.tag = tag;
    }

    private void loadExtra(CompoundTag tag) {
        EntityAyeraco[] group = new EntityAyeraco[5];
        for (int i = 0; i < 5; ++i) {
            if (!tag.m_128441_("Group" + i)) continue;
            group[i] = this.find(tag.m_128342_("Group" + i));
        }
        this.beam = BlockPos.m_122022_((long)tag.m_128454_("Beam"));
        byte b = tag.m_128445_("Variant");
        this.f_19804_.m_135381_(VARIANT, (Object)b);
        this.assignGroup(group);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)6);
    }

    public EntityAyeraco find(UUID id) {
        Entity entity;
        if (this.m_9236_() != null && !this.m_9236_().f_46443_ && id != null && (entity = ((ServerLevel)this.m_9236_()).m_8791_(id)) instanceof EntityAyeraco) {
            return (EntityAyeraco)entity;
        }
        return null;
    }

    @Override
    public void m_8119_() {
        if (this.angry && this.canHeal) {
            this.m_5634_(2.5f);
        }
        if (this.broadcast && !this.m_9236_().f_46443_) {
            this.loadExtra(this.tag);
            this.broadcast = false;
        }
        super.m_8119_();
    }

    public void m_7023_(Vec3 vec) {
        if (this.m_20069_() || this.m_20077_()) {
            this.m_19920_(0.02f, vec);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.8));
        } else {
            BlockPos ground = new BlockPos((Vec3i)this.m_20183_().m_7495_());
            float f = 0.91f;
            if (this.m_20096_()) {
                f = this.m_9236_().m_8055_(ground).getFriction((LevelReader)this.m_9236_(), ground, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.m_20096_()) {
                f = this.m_9236_().m_8055_(ground).getFriction((LevelReader)this.m_9236_(), ground, (Entity)this) * 0.91f;
            }
            this.m_19920_(this.m_20096_() ? 0.1f * f1 : 0.02f, vec);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)f));
        }
        this.m_267651_(false);
    }

    class AyeracoMoveControl
    extends MoveControl {
        private float speed;

        public AyeracoMoveControl(Mob mob) {
            super(mob);
            this.speed = 0.2f;
        }

        public void m_8126_() {
            if (EntityAyeraco.this.f_19862_) {
                EntityAyeraco.this.m_146922_(EntityAyeraco.this.m_146908_() + 180.0f);
                this.speed = 0.2f;
            }
            double d0 = EntityAyeraco.this.moveTargetPoint.f_82479_ - EntityAyeraco.this.m_20185_();
            double d1 = EntityAyeraco.this.moveTargetPoint.f_82480_ - EntityAyeraco.this.m_20186_();
            double d2 = EntityAyeraco.this.moveTargetPoint.f_82481_ - EntityAyeraco.this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Math.abs(d3) > 1.0E-5) {
                double d4 = 1.0 - Math.abs(d1 * 0.7) / d3;
                d3 = Math.sqrt((d0 *= d4) * d0 + (d2 *= d4) * d2);
                double d5 = Math.sqrt(d0 * d0 + d2 * d2 + d1 * d1);
                float f = EntityAyeraco.this.m_146908_();
                float f1 = (float)Mth.m_14136_((double)d2, (double)d0);
                float f2 = Mth.m_14177_((float)(EntityAyeraco.this.m_146908_() + 90.0f));
                float f3 = Mth.m_14177_((float)(f1 * 57.295776f));
                EntityAyeraco.this.m_146922_(Mth.m_14148_((float)f2, (float)f3, (float)4.0f) - 90.0f);
                EntityAyeraco.this.f_20883_ = EntityAyeraco.this.m_146908_();
                this.speed = Mth.m_14145_((float)f, (float)EntityAyeraco.this.m_146908_()) < 3.0f ? Mth.m_14121_((float)this.speed, (float)1.8f, (float)(0.005f * (1.8f / this.speed))) : Mth.m_14121_((float)this.speed, (float)0.22f, (float)0.025f);
                float f4 = (float)(-(Mth.m_14136_((double)(-d1), (double)d3) * 57.2957763671875));
                EntityAyeraco.this.m_146926_(f4);
                float f5 = EntityAyeraco.this.m_146908_() + 90.0f;
                double d6 = (double)(this.speed * Mth.m_14089_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d0 / d5);
                double d7 = (double)(this.speed * Mth.m_14031_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d2 / d5);
                double d8 = (double)(this.speed * Mth.m_14031_((float)(f4 * ((float)Math.PI / 180)))) * Math.abs(d1 / d5);
                Vec3 vec3 = EntityAyeraco.this.m_20184_();
                EntityAyeraco.this.m_20256_(vec3.m_82549_(new Vec3(d6, d8, d7).m_82546_(vec3).m_82490_(0.2)));
            }
        }
    }

    class AyeracoLookControl
    extends LookControl {
        public AyeracoLookControl(Mob mob) {
            super(mob);
        }

        public void m_8128_() {
        }
    }

    class AyeracoBodyRotationControl
    extends BodyRotationControl {
        public AyeracoBodyRotationControl(Mob mob) {
            super(mob);
        }

        public void m_8121_() {
            EntityAyeraco.this.f_20885_ = EntityAyeraco.this.f_20883_;
            EntityAyeraco.this.f_20883_ = EntityAyeraco.this.m_146908_();
        }
    }

    class AyeracoAttackStrategyGoal
    extends Goal {
        private int nextSweepTick;

        AyeracoAttackStrategyGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = EntityAyeraco.this.m_5448_();
            return livingentity != null ? EntityAyeraco.this.m_21040_(livingentity, TargetingConditions.f_26872_) : false;
        }

        public void m_8056_() {
            this.nextSweepTick = this.m_183277_(10);
            EntityAyeraco.this.circling = true;
            this.setAnchorAboveTarget();
        }

        public void m_8041_() {
            EntityAyeraco.this.anchorPoint = EntityAyeraco.this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, EntityAyeraco.this.anchorPoint).m_6630_(10 + EntityAyeraco.this.f_19796_.m_188503_(20));
        }

        public void m_8037_() {
            if (EntityAyeraco.this.circling) {
                --this.nextSweepTick;
                if (this.nextSweepTick <= 0) {
                    EntityAyeraco.this.circling = false;
                    this.setAnchorAboveTarget();
                    this.nextSweepTick = this.m_183277_((8 + EntityAyeraco.this.f_19796_.m_188503_(4)) * 20);
                    EntityAyeraco.this.m_5496_((SoundEvent)SoundRegistry.AYERACO_TELEPORT.get(), 10.0f, 0.95f + EntityAyeraco.this.f_19796_.m_188501_() * 0.1f);
                }
            }
        }

        private void setAnchorAboveTarget() {
            EntityAyeraco.this.anchorPoint = EntityAyeraco.this.m_5448_().m_20183_().m_6630_(20 + EntityAyeraco.this.f_19796_.m_188503_(20));
            if (EntityAyeraco.this.anchorPoint.m_123342_() < EntityAyeraco.this.m_9236_().m_5736_()) {
                EntityAyeraco.this.anchorPoint = new BlockPos(EntityAyeraco.this.anchorPoint.m_123341_(), EntityAyeraco.this.m_9236_().m_5736_() + 1, EntityAyeraco.this.anchorPoint.m_123343_());
            }
        }
    }

    class AyeracoSweepAttackGoal
    extends AyeracoMoveTargetGoal {
        AyeracoSweepAttackGoal() {
        }

        public boolean m_8036_() {
            return EntityAyeraco.this.m_5448_() != null && !EntityAyeraco.this.circling;
        }

        public boolean m_8045_() {
            Player player;
            LivingEntity livingentity = EntityAyeraco.this.m_5448_();
            if (livingentity == null || !livingentity.m_6084_()) {
                return false;
            }
            if (livingentity instanceof Player && ((player = (Player)livingentity).m_5833_() || player.m_7500_())) {
                return false;
            }
            return this.m_8036_();
        }

        public void m_8056_() {
        }

        public void m_8041_() {
            EntityAyeraco.this.m_6710_(null);
            EntityAyeraco.this.circling = true;
        }

        public void m_8037_() {
            LivingEntity livingentity = EntityAyeraco.this.m_5448_();
            if (livingentity != null) {
                EntityAyeraco.this.moveTargetPoint = new Vec3(livingentity.m_20185_(), livingentity.m_20227_(0.5), livingentity.m_20189_());
                if (EntityAyeraco.this.m_20191_().m_82400_(0.2).m_82381_(livingentity.m_20191_())) {
                    EntityAyeraco.this.m_7327_((Entity)livingentity);
                    EntityAyeraco.this.circling = true;
                    if (!EntityAyeraco.this.m_20067_()) {
                        EntityAyeraco.this.m_9236_().m_46796_(1039, EntityAyeraco.this.m_20183_(), 0);
                    }
                } else if (EntityAyeraco.this.f_19862_ || EntityAyeraco.this.f_20916_ > 0) {
                    EntityAyeraco.this.circling = true;
                }
            }
        }
    }

    class AyeracoCircleAroundAnchorGoal
    extends AyeracoMoveTargetGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        AyeracoCircleAroundAnchorGoal() {
        }

        public boolean m_8036_() {
            return EntityAyeraco.this.m_5448_() == null || EntityAyeraco.this.circling;
        }

        public void m_8056_() {
            this.distance = 5.0f + EntityAyeraco.this.f_19796_.m_188501_() * 10.0f;
            this.height = -4.0f + EntityAyeraco.this.f_19796_.m_188501_() * 9.0f;
            this.clockwise = EntityAyeraco.this.f_19796_.m_188499_() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void m_8037_() {
            if (EntityAyeraco.this.f_19796_.m_188503_(this.m_183277_(350)) == 0) {
                this.height = -4.0f + EntityAyeraco.this.f_19796_.m_188501_() * 9.0f;
            }
            if (EntityAyeraco.this.f_19796_.m_188503_(this.m_183277_(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (EntityAyeraco.this.f_19796_.m_188503_(this.m_183277_(450)) == 0) {
                this.angle = EntityAyeraco.this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (EntityAyeraco.this.moveTargetPoint.f_82480_ < EntityAyeraco.this.m_20186_() && !EntityAyeraco.this.m_9236_().m_46859_(EntityAyeraco.this.m_20183_().m_6625_(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (EntityAyeraco.this.moveTargetPoint.f_82480_ > EntityAyeraco.this.m_20186_() && !EntityAyeraco.this.m_9236_().m_46859_(EntityAyeraco.this.m_20183_().m_6630_(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.f_121853_.equals((Object)EntityAyeraco.this.anchorPoint)) {
                EntityAyeraco.this.anchorPoint = EntityAyeraco.this.m_20183_();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            EntityAyeraco.this.moveTargetPoint = Vec3.m_82528_((Vec3i)EntityAyeraco.this.anchorPoint).m_82520_((double)(this.distance * Mth.m_14089_((float)this.angle)), -4.0 + (double)this.height, (double)(this.distance * Mth.m_14031_((float)this.angle)));
        }
    }

    class AyeracoAttackPlayerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.m_148352_().m_26883_(64.0);
        private int nextScanTick = AyeracoAttackPlayerTargetGoal.m_186073_((int)20);

        AyeracoAttackPlayerTargetGoal() {
        }

        public boolean m_8036_() {
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
                return false;
            }
            this.nextScanTick = AyeracoAttackPlayerTargetGoal.m_186073_((int)60);
            List list = EntityAyeraco.this.m_9236_().m_45955_(this.attackTargeting, (LivingEntity)EntityAyeraco.this, EntityAyeraco.this.m_20191_().m_82377_(16.0, 64.0, 16.0));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(Entity::m_20186_).reversed());
                for (Player player : list) {
                    if (!EntityAyeraco.this.m_21040_((LivingEntity)player, TargetingConditions.f_26872_)) continue;
                    EntityAyeraco.this.m_6710_((LivingEntity)player);
                    return true;
                }
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = EntityAyeraco.this.m_5448_();
            return livingentity != null ? EntityAyeraco.this.m_21040_(livingentity, TargetingConditions.f_26872_) : false;
        }
    }

    abstract class AyeracoMoveTargetGoal
    extends Goal {
        public AyeracoMoveTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean touchingTarget() {
            return EntityAyeraco.this.moveTargetPoint.m_82531_(EntityAyeraco.this.m_20185_(), EntityAyeraco.this.m_20186_(), EntityAyeraco.this.m_20189_()) < 4.0;
        }
    }
}

