/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.blocks.vethea.BlockHelioticBeam;
import divinerpg.blocks.vethea.BlockKarosDispenser;
import divinerpg.blocks.vethea.BlockKarosHeatTile;
import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSource;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityKaros
extends EntityDivineBoss {
    private int ability = 0;
    private final int DEFAULT = 0;
    private final int CEILING = 1;
    private final int CANNONS = 2;
    private final int FLOOR = 3;
    private int abilityCooldown;
    private boolean hasLoadedBlocks = false;
    private List<BlockPos> ceiling = new ArrayList<BlockPos>();
    private List<BlockPos> cannons = new ArrayList<BlockPos>();

    public EntityKaros(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8024_() {
        this.manageAbilities();
        super.m_8024_();
    }

    @Override
    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(8, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21346_.m_25352_(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 1.0f, 1.0f));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Piglin.class}));
        this.f_21345_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void manageAbilities() {
        block9: {
            block8: {
                if (this.abilityCooldown != 0) break block8;
                this.abilityCooldown = 200;
                switch (this.f_19796_.m_188503_(3)) {
                    case 0: {
                        this.ability = 1;
                        this.m_5496_((SoundEvent)SoundRegistry.CEILING_EXPLOSIONS.get(), 1.0f, 1.0f);
                        if (!this.m_9236_().f_46443_) {
                            List players = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82363_(30.0, 30.0, 30.0));
                            for (Player p : players) {
                                p.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)p, "message.karos.explosion", new Object[0]), true);
                            }
                        }
                        break block9;
                    }
                    case 1: {
                        this.ability = 2;
                        break;
                    }
                    case 2: {
                        this.ability = 3;
                        break;
                    }
                }
                break block9;
            }
            if (this.abilityCooldown > 0) {
                --this.abilityCooldown;
            }
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 2.4375f;
    }

    public boolean m_6469_(DamageSource source, float par2) {
        if (source.m_276093_(DamageTypes.f_268565_)) {
            return false;
        }
        return super.m_6469_(source, par2);
    }

    @Override
    public void m_8119_() {
        block15: {
            Block currentBlock;
            block14: {
                super.m_8119_();
                if (!this.hasLoadedBlocks) {
                    if (!this.m_9236_().m_5776_()) {
                        List players = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82363_(30.0, 30.0, 30.0));
                        for (Player p : players) {
                            this.m_9236_().m_5594_(p, p.m_20183_(), (SoundEvent)SoundRegistry.KAROS_INTRO.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                            p.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)p, "message.karos.game", new Object[0]), true);
                            p.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)p, "message.karos.begin", new Object[0]), true);
                        }
                    }
                    for (int x = -40; x < 40; ++x) {
                        for (int y = -5; y < 20; ++y) {
                            for (int z = -40; z < 40; ++z) {
                                BlockPos currentPos = this.m_20183_().m_7918_(x, y, z);
                                Block currentBlock2 = this.m_9236_().m_8055_(currentPos).m_60734_();
                                if (currentBlock2 == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "heliotic_beam"))) {
                                    this.ceiling.add(currentPos);
                                    continue;
                                }
                                if (currentBlock2 != ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "karos_dispenser"))) continue;
                                this.cannons.add(currentPos);
                            }
                        }
                    }
                    this.hasLoadedBlocks = true;
                }
                if (this.ability != 1 || this.ceiling.size() == 0) break block14;
                if (this.abilityCooldown % 8 != 0) break block15;
                BlockPos currentPos = this.ceiling.get(this.f_19796_.m_188503_(this.ceiling.size()));
                currentBlock = this.m_9236_().m_8055_(currentPos).m_60734_();
                if (!(currentBlock instanceof BlockHelioticBeam)) break block15;
                ((BlockHelioticBeam)currentBlock).dropBomb(this.m_9236_(), currentPos);
                break block15;
            }
            if (this.ability == 2 && this.cannons.size() != 0) {
                if (this.abilityCooldown % 4 == 0) {
                    BlockPos currentPos = this.cannons.get(this.f_19796_.m_188503_(this.cannons.size()));
                    currentBlock = this.m_9236_().m_8055_(currentPos).m_60734_();
                    if (currentBlock instanceof BlockKarosDispenser) {
                        ((BlockKarosDispenser)currentBlock).dispenseFrom(this.m_9236_().m_7654_().m_129880_(this.m_9236_().m_46472_()), currentPos);
                    }
                } else if (this.ability == 3) {
                    for (int i = 0; i < 3; ++i) {
                        for (double var4 = 0.0; var4 < Math.PI * 2; var4 += 0.39269908169872414) {
                            int var1 = (int)Math.round(Math.sin(var4) * (double)i);
                            int var3 = (int)Math.round(Math.cos(var4) * (double)i);
                            BlockPos currentPos = new BlockPos((int)this.m_20185_() + var1, (int)this.m_20186_() - 1, (int)this.m_20189_() + var3);
                            if (this.m_9236_().m_8055_(currentPos).m_60734_() != BlockRegistry.karosHeatTile.get()) continue;
                            this.m_9236_().m_7731_(currentPos, (BlockState)((Block)BlockRegistry.karosHeatTile.get()).m_49966_().m_61124_((Property)BlockKarosHeatTile.ACTIVE, (Comparable)Boolean.valueOf(true)), 0);
                        }
                    }
                }
            }
        }
    }

    protected float m_6121_() {
        return 0.7f;
    }

    protected SoundEvent m_7515_() {
        String langKey;
        SoundEvent sound = switch (this.f_19796_.m_188503_(4)) {
            case 0 -> {
                langKey = "message.karos.laugh";
                yield (SoundEvent)SoundRegistry.KAROS_LAUGH.get();
            }
            case 1 -> {
                langKey = "message.karos.doom";
                yield (SoundEvent)SoundRegistry.MEET_DOOM.get();
            }
            case 2 -> {
                langKey = "message.karos.cmon";
                yield (SoundEvent)SoundRegistry.TRY_YOUR_BEST.get();
            }
            default -> {
                langKey = "message.karos.weak";
                yield (SoundEvent)SoundRegistry.YOU_CANT_KILL_ME.get();
            }
        };
        this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82363_(30.0, 30.0, 30.0)).forEach(x -> x.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)x, langKey, new Object[0]), true));
        return sound;
    }

    public SoundEvent m_7975_(DamageSource damageSource) {
        return null;
    }

    public SoundEvent m_5592_() {
        return null;
    }
}

