/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.DivineRPG;
import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.projectile.EntityLadyLunaSparkler;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class EntityLadyLuna
extends EntityDivineBoss {
    public static final EntityDataAccessor<Integer> PROTECTION = SynchedEntityData.m_135353_(EntityLadyLuna.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int protectionTimer;
    private List<BlockPos> acidPositions = new ArrayList<BlockPos>();

    public EntityLadyLuna(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.setRandomProtectionValues();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 2.90625f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PROTECTION, (Object)0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance instance, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        this.f_19804_.m_135381_(PROTECTION, (Object)this.f_19796_.m_188503_(2));
        return data;
    }

    public int getProtection() {
        return (Integer)this.f_19804_.m_135370_(PROTECTION);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 1.0f, 1.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Piglin.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.f_19797_ % 5 == 0) {
            for (int x = (int)this.m_20185_() - 2; x < (int)this.m_20185_() + 2; ++x) {
                for (int y = (int)this.m_20191_().f_82289_; y < (int)this.m_20191_().f_82289_ + 4; ++y) {
                    for (int z = (int)this.m_20189_() - 2; z < (int)this.m_20189_() + 2; ++z) {
                        if (!this.m_9236_().m_8055_(new BlockPos(x, y, z)).m_204336_(BlockTags.f_13035_) && !this.m_9236_().m_8055_(new BlockPos(x, y, z)).m_204336_(BlockTags.f_13106_)) continue;
                        this.m_9236_().m_7731_(new BlockPos(x, y, z), Blocks.f_50016_.m_49966_(), 1);
                    }
                }
            }
        }
        BlockPos current = new BlockPos((int)this.m_20185_() - 1, (int)this.m_20186_(), (int)this.m_20189_() - 1);
        BlockPos below = new BlockPos((int)this.m_20185_() - 1, (int)this.m_20186_() - 1, (int)this.m_20189_() - 1);
        BlockState belowState = this.m_9236_().m_8055_(below);
        if (this.m_9236_().m_8055_(current).m_60734_() == Blocks.f_50016_ && belowState.m_60815_() && belowState.m_60779_()) {
            this.m_9236_().m_7731_(current, ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "lunic_acid"))).m_49966_(), 1);
            this.acidPositions.add(current);
        }
        if (!this.m_9236_().m_5776_() && this.getProtection() == 0 && this.f_19797_ % 30 == 0) {
            Iterator<BlockPos> iter = this.acidPositions.iterator();
            while (iter.hasNext()) {
                BlockPos pos = iter.next();
                if (this.m_9236_().m_8055_(pos).m_60734_() != ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "lunic_acid"))) {
                    iter.remove();
                    continue;
                }
                if (this.f_19796_.m_188503_(4) != 0) continue;
                EntityLadyLunaSparkler e = new EntityLadyLunaSparkler((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.LADY_LUNA_SPARKLER.get()), this.m_9236_(), (LivingEntity)this);
                e.m_6027_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 0, (double)pos.m_123343_() + 0.5);
                this.m_9236_().m_7967_((Entity)e);
            }
        }
        if (this.getProtectionTimer() == 0) {
            this.setRandomProtectionValues();
        } else if (this.getProtectionTimer() > 0) {
            this.setProtectionTimer(this.getProtectionTimer() - 1);
        }
    }

    public void setProtectionType(int i) {
        this.f_19804_.m_135381_(PROTECTION, (Object)i);
        if (i == 0) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
        } else {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.32);
        }
    }

    public void setProtectionTimer(int i) {
        this.protectionTimer = i;
    }

    public int getProtectionTimer() {
        return this.protectionTimer;
    }

    public boolean m_6469_(DamageSource source, float par2) {
        if (source.m_276093_(DamageTypes.f_268565_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268515_) && this.getProtection() == 0) {
            return false;
        }
        if ((source.m_276093_(DamageTypes.f_268534_) || source.m_19385_().equals("thrown")) && this.getProtection() == 1) {
            return false;
        }
        if (!source.m_276093_(DamageTypes.f_268534_) && !source.m_276093_(DamageTypes.f_268515_) && this.getProtection() == 2) {
            return false;
        }
        return super.m_6469_(source, par2);
    }

    public boolean m_7327_(Entity e) {
        int dam = 20;
        boolean var4 = e.m_6469_(e.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)dam);
        if (var4) {
            this.m_9236_().m_254849_((Entity)this, e.m_20185_(), e.m_20186_(), e.m_20189_(), 2.0f, Level.ExplosionInteraction.BLOCK);
            this.f_19854_ *= 0.6;
            this.f_19856_ *= 0.6;
            int var5 = EnchantmentHelper.m_44914_((LivingEntity)this);
            if (var5 > 0) {
                e.m_20254_(var5 * 4);
            }
        }
        return var4;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Immunity", this.getProtection());
        tag.m_128405_("ImmunityCooldown", this.getProtectionTimer());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setProtectionType(tag.m_128451_("Immunity"));
        this.setProtectionTimer(tag.m_128451_("ImmunityCooldown"));
    }

    public int m_5792_() {
        return 3;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.LADY_LUNA.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SoundRegistry.LADY_LUNA_HURT.get();
    }

    private void setRandomProtectionValues() {
        DivineRPG.LOGGER.info("protection type: " + this.getProtection() + ". protection timer: " + this.getProtectionTimer());
        this.setProtectionType(this.f_19796_.m_188503_(2));
        this.setProtectionTimer(200 + this.f_19796_.m_188503_(200));
    }
}

