/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.projectile.EntityDivineArrow;
import divinerpg.enums.ArrowType;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;

public class EntityQuadro
extends EntityDivineBoss
implements RangedAttackMob {
    private QuadroAbility ability = this.getRandomAbility();
    private int abilityCooldown;
    private int rangedAttackCounter;
    public boolean dir;

    public EntityQuadro(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(8, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21346_.m_25352_(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 1.0f, 1.0f));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.m_5448_() != null && this.m_5448_() instanceof LivingEntity) {
            this.m_6504_(this.m_5448_(), 0.0f);
        }
        if (this.abilityCooldown <= 0) {
            this.ability = this.getRandomAbility();
            this.abilityCooldown = 500;
            this.rangedAttackCounter = 0;
            this.dir = true;
            int s = this.f_19796_.m_188503_(9);
            List players = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82363_(30.0, 30.0, 30.0));
            for (Player p : players) {
                SoundEvent sound;
                String chatMessage = switch (s) {
                    case 0 -> {
                        sound = (SoundEvent)SoundRegistry.QUADRO_DIE_BEFORE.get();
                        yield "message.quadro.die";
                    }
                    case 1 -> {
                        sound = (SoundEvent)SoundRegistry.QUADRO_ENOUGH.get();
                        yield "message.quadro.enough";
                    }
                    case 2 -> {
                        sound = (SoundEvent)SoundRegistry.QUADRO_INCOMING_PUNCH.get();
                        yield "message.quadro.punch";
                    }
                    case 3 -> {
                        sound = (SoundEvent)SoundRegistry.QUADRO_IS_NEXT.get();
                        yield "message.quadro.next";
                    }
                    case 4 -> {
                        sound = (SoundEvent)SoundRegistry.QUADRO_KILL_MINE.get();
                        yield "message.quadro.mine";
                    }
                    case 5 -> {
                        sound = (SoundEvent)SoundRegistry.QUADRO_MY_KILL.get();
                        yield "message.quadro.kill";
                    }
                    case 6 -> {
                        sound = (SoundEvent)SoundRegistry.QUADRO_NO_DIE.get();
                        yield "message.quadro.no";
                    }
                    case 7 -> {
                        sound = (SoundEvent)SoundRegistry.QUADRO_SIT_DOWN.get();
                        yield "message.quadro.sit";
                    }
                    default -> {
                        sound = (SoundEvent)SoundRegistry.QUADRO_TASTE_FIST.get();
                        yield "message.quadro.taste";
                    }
                };
                this.m_9236_().m_5594_(p, p.m_20183_(), sound, SoundSource.HOSTILE, 1.0f, 1.0f);
                if (this.m_9236_().m_5776_()) continue;
                p.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)p, chatMessage, new Object[0]), true);
            }
        }
        if (this.abilityCooldown == 480) {
            --this.abilityCooldown;
            this.dir = false;
        }
        if (this.abilityCooldown > 0) {
            --this.abilityCooldown;
        }
        if (this.ability == QuadroAbility.MELEE_SLOW) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.32);
            this.m_7910_(0.48f);
        } else if (this.ability == QuadroAbility.MELEE_FAST) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.48);
            this.m_7910_(0.32f);
        } else if (this.ability == QuadroAbility.RANGED_SLOW) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
            this.m_7910_(0.0f);
        } else if (this.ability == QuadroAbility.RANGED_FAST) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
            this.m_7910_(0.0f);
        }
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (this.m_5448_() != null && this.m_6084_() && !this.m_9236_().f_46443_) {
            switch (this.ability) {
                case RANGED_FAST: {
                    if (this.rangedAttackCounter % 5 == 0) {
                        double tx = this.m_5448_().m_20185_() - this.m_20185_();
                        double ty = this.m_5448_().m_20191_().f_82289_ - this.m_20186_();
                        double tz = this.m_5448_().m_20189_() - this.m_20189_();
                        EntityDivineArrow projectile = new EntityDivineArrow((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.ARROW_SHOT.get()), this.m_9236_(), ArrowType.KAROS_ARROW, (LivingEntity)this, target, 2.6f, 3.0f);
                        projectile.m_6686_(tx, ty, tz, 2.6f, 3.0f);
                        this.m_9236_().m_7967_((Entity)projectile);
                    }
                    ++this.rangedAttackCounter;
                    break;
                }
                case RANGED_SLOW: {
                    if (this.rangedAttackCounter % 15 == 0) {
                        double tx = this.m_5448_().m_20185_() - this.m_20185_();
                        double ty = this.m_5448_().m_20191_().f_82289_ - this.m_20186_();
                        double tz = this.m_5448_().m_20189_() - this.m_20189_();
                        EntityDivineArrow projectile = new EntityDivineArrow((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.ARROW_SHOT.get()), this.m_9236_(), ArrowType.KAROS_ARROW, (LivingEntity)this, target, 2.6f, 0.8f);
                        projectile.m_6686_(tx, ty, tz, 2.6f, 0.8f);
                        this.m_9236_().m_7967_((Entity)projectile);
                    }
                    ++this.rangedAttackCounter;
                    break;
                }
            }
        }
    }

    public int m_5792_() {
        return 3;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return super.m_7515_();
    }

    private QuadroAbility getRandomAbility() {
        switch (this.f_19796_.m_188503_(4)) {
            case 0: {
                return QuadroAbility.RANGED_SLOW;
            }
            case 1: {
                return QuadroAbility.RANGED_FAST;
            }
            case 2: {
                return QuadroAbility.MELEE_SLOW;
            }
            case 3: {
                return QuadroAbility.MELEE_FAST;
            }
        }
        return null;
    }

    static enum QuadroAbility {
        RANGED_SLOW(0),
        RANGED_FAST(1),
        MELEE_SLOW(2),
        MELEE_FAST(3);

        private int numVal;

        private QuadroAbility(int numVal) {
            this.numVal = numVal;
        }

        public int value() {
            return this.numVal;
        }
    }
}

