/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.projectile.EntityShooterBullet;
import divinerpg.enums.BulletType;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;

public class EntityRaglok
extends EntityDivineBoss {
    private int ability;
    private final int DEFAULT = 0;
    private final int LIGHTNING = 1;
    private final int BLIND = 2;
    private final int BOMBS = 3;
    private final int SLOW = 4;
    private double prevPlayerX;
    private double prevPlayerY;
    private double prevPlayerZ;
    private int abilityCooldown;
    private boolean loaded = false;
    private int rangedAttackCounter;
    private boolean avengeAbilityUsed = false;

    public EntityRaglok(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.loaded && !this.m_9236_().f_46443_) {
            List players = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82363_(30.0, 30.0, 30.0));
            for (Player p : players) {
                p.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)p, "message.raglok.dare", new Object[0]), true);
            }
            this.m_5496_((SoundEvent)SoundRegistry.RAGLOK_AWAKEN.get(), 1.0f, 1.0f);
            this.loaded = true;
        }
        if (this.m_6084_()) {
            this.manageAbilities();
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 5.0f;
    }

    public void manageAbilities() {
        Player player = this.m_9236_().m_45930_((Entity)this, 64.0);
        if (player == null || player.m_7500_() || this.avengeAbilityUsed) {
            return;
        }
        if (this.abilityCooldown == 0 || this.ability == 0) {
            this.abilityCooldown = 400;
            switch (this.f_19796_.m_188503_(4)) {
                case 0: {
                    this.ability = 1;
                    this.rangedAttackCounter = 0;
                    this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
                    break;
                }
                case 1: {
                    this.ability = 2;
                    this.m_21051_(Attributes.f_22279_).m_22100_(0.3);
                    break;
                }
                case 2: {
                    this.ability = 3;
                    this.rangedAttackCounter = 0;
                    this.m_21051_(Attributes.f_22279_).m_22100_(0.3);
                    break;
                }
                case 3: {
                    this.ability = 4;
                    this.m_21051_(Attributes.f_22279_).m_22100_(0.3);
                    break;
                }
            }
            this.message();
        } else if (this.abilityCooldown > 0) {
            --this.abilityCooldown;
        }
        if (this.ability == 2 && player != null) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 25, 1));
        }
        if (this.ability == 4 && player != null) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 1));
        }
        if (this.ability == 1) {
            if (this.abilityCooldown % 40 == 0 && player != null) {
                LightningBolt ent = new LightningBolt(EntityType.f_20465_, this.m_9236_());
                ent.m_6034_(this.prevPlayerX, this.prevPlayerY, this.prevPlayerZ);
                this.m_9236_().m_7967_((Entity)ent);
                ++this.rangedAttackCounter;
            } else if (this.abilityCooldown % 40 != 0 && this.abilityCooldown % 20 == 0 && player != null) {
                this.prevPlayerX = player.m_20185_();
                this.prevPlayerY = player.m_20186_();
                this.prevPlayerZ = player.m_20189_();
            }
            if (this.rangedAttackCounter == 10) {
                this.ability = 0;
            }
        }
        if (this.ability == 3) {
            if (this.abilityCooldown % 30 == 0 && player != null) {
                for (int i = 0; i < 4; ++i) {
                    EntityShooterBullet var2 = new EntityShooterBullet((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.SHOOTER_BULLET.get()), (LivingEntity)this, this.m_9236_(), BulletType.RAGLOK_BOMB);
                    var2.m_6027_(player.f_19854_, player.f_19855_ + 5.0, player.f_19856_);
                    var2.m_20334_((this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) / 5.0, -0.14, (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) / 5.0);
                    this.m_9236_().m_7967_((Entity)var2);
                    ++this.rangedAttackCounter;
                }
            }
            if (this.rangedAttackCounter == 12) {
                this.ability = 0;
            }
        }
    }

    private void message() {
        List list = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82363_(64.0, 64.0, 64.0));
        block6: for (int var1 = 0; var1 < list.size(); ++var1) {
            if (!(list.get(var1) instanceof Player)) continue;
            Player player = (Player)list.get(var1);
            switch (this.ability) {
                case 1: {
                    this.m_5496_((SoundEvent)SoundRegistry.RAGLOK_GUARDIAN.get(), 1.0f, 1.0f);
                    if (this.m_9236_().f_46443_) continue block6;
                    player.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)player, "message.raglok.think", new Object[0]), true);
                    player.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)player, "message.raglok.great", new Object[0]), true);
                    continue block6;
                }
                case 2: {
                    this.m_5496_((SoundEvent)SoundRegistry.RAGLOK_DARK.get(), 1.0f, 1.0f);
                    if (this.m_9236_().f_46443_) continue block6;
                    player.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)player, "message.raglok.future", new Object[0]), true);
                    continue block6;
                }
                case 3: {
                    this.m_5496_((SoundEvent)SoundRegistry.RAGLOK_RAIN.get(), 1.0f, 1.0f);
                    if (this.m_9236_().f_46443_) continue block6;
                    player.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)player, "message.raglok.rain", new Object[0]), true);
                    player.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)player, "message.raglok.kill", new Object[0]), true);
                    continue block6;
                }
                case 4: {
                    this.m_5496_((SoundEvent)SoundRegistry.RAGLOK_NOTHING.get(), 1.0f, 1.0f);
                    if (this.m_9236_().f_46443_) continue block6;
                    player.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)player, "message.raglok.compare", new Object[0]), true);
                    continue block6;
                }
            }
        }
    }

    @Override
    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(8, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21346_.m_25352_(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 1.0f, 1.0f));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Piglin.class}));
        this.f_21345_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public int m_5792_() {
        return 3;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return super.m_7515_();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.RAGLOK_AVENGE.get();
    }

    public void m_6667_(DamageSource source) {
        if (!this.avengeAbilityUsed) {
            Player player;
            if (!this.m_9236_().m_5776_()) {
                List players = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82363_(30.0, 30.0, 30.0));
                for (Player p : players) {
                    p.m_5661_(LocalizeUtils.getClientSideTranslation((CommandSource)p, "message.raglok.avenge", new Object[0]), true);
                }
            }
            if ((player = this.m_9236_().m_45930_((Entity)this, 64.0)) != null && !player.m_7500_()) {
                LightningBolt bolt = new LightningBolt(EntityType.f_20465_, this.m_9236_());
                bolt.m_6034_(player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_);
                this.m_9236_().m_7967_((Entity)bolt);
            }
            this.avengeAbilityUsed = true;
        }
        super.m_6667_(source);
    }
}

