/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile;

import divinerpg.entities.projectile.EntityBouncingProjectile;
import divinerpg.entities.projectile.EntityDisk;
import divinerpg.entities.projectile.EntityParticleBullet;
import divinerpg.enums.BulletType;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.ParticleRegistry;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EntityShooterBullet
extends ThrowableProjectile {
    private static final EntityDataAccessor<Byte> BULLET_ID = SynchedEntityData.m_135353_(EntityShooterBullet.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public BulletType bulletType;
    public int bounces;
    public int color = new Random().nextInt(25);
    public LivingEntity thrower;

    public EntityShooterBullet(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
    }

    public EntityShooterBullet(EntityType<? extends ThrowableProjectile> type, LivingEntity entity, Level world, BulletType bulletType) {
        super(type, entity, world);
        this.bulletType = bulletType;
        this.thrower = entity;
        this.setBulletId((byte)bulletType.ordinal());
        if (this.getBulletType() == BulletType.REFLECTOR_SHOT || this.getBulletType() == BulletType.ATTRACTOR_SHOT || this.getBulletType() == BulletType.SERENADE_OF_ICE_SHOT) {
            this.m_20334_(this.m_20184_().f_82479_ * 3.0, this.m_20184_().f_82480_ * 3.0, this.m_20184_().f_82481_ * 3.0);
        }
        if (this.getBulletType().getBulletSpecial() == BulletType.BulletSpecial.SKY) {
            this.m_20334_(this.m_9236_().m_213780_().m_188583_() * 0.05, -0.5, this.m_9236_().m_213780_().m_188583_() * 0.05);
        }
    }

    public EntityShooterBullet(EntityType<? extends ThrowableProjectile> type, double x, double y, double z, Level world, BulletType bulletType) {
        super(type, x, y, z, world);
        this.bulletType = bulletType;
    }

    public float m_7139_() {
        if (this.getBulletType().getBulletDamageType() == BulletType.BulletDamageType.NONE) {
            return 0.0f;
        }
        return super.m_7139_();
    }

    public void m_8119_() {
        if (this.f_19797_ > 200) {
            this.m_146870_();
        }
        super.m_8119_();
        if (this.getBulletType().getBulletSpecial() == BulletType.BulletSpecial.RAINBOW) {
            for (int var3 = 0; var3 < 8; ++var3) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleRegistry.SPARKLER.get(), this.f_19854_, this.f_19855_, this.f_19856_, 0.25 * this.f_19796_.m_188583_(), 0.25 * this.f_19796_.m_188583_(), 0.25 * this.f_19796_.m_188583_());
            }
        }
        this.color = this.color >= 24 ? 0 : ++this.color;
        if (this.getBulletType().getBulletSpecial() == BulletType.BulletSpecial.MUSIC) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.f_19854_, this.f_19855_, this.f_19856_, (double)this.color / 24.0, 0.0, 0.0);
        }
    }

    public void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!(this instanceof EntityBouncingProjectile) && !(this instanceof EntityDisk)) {
            this.m_146870_();
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.getBulletType().getBulletSpecial() == BulletType.BulletSpecial.SPLIT) {
                for (double theta = 0.0; theta < Math.PI * (double)this.getBulletType().effectPower / 2.0; theta += Math.PI / (double)this.getBulletType().effectPower * 2.0) {
                    EntityParticleBullet bullet = new EntityParticleBullet((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.PARTICLE_BULLET.get()), this.m_9236_(), this.thrower, this.getBulletType().sprayBullet);
                    bullet.m_6027_(this.f_19854_, this.f_19855_, this.f_19856_);
                    bullet.m_6686_(Math.cos(theta), 0.4, Math.sin(theta), 0.7f, 0.0f);
                    this.m_9236_().m_7967_((Entity)bullet);
                }
                EntityParticleBullet bullet = new EntityParticleBullet((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.PARTICLE_BULLET.get()), this.m_9236_(), this.thrower, this.getBulletType().sprayBullet);
                bullet.m_6027_(this.f_19854_, this.f_19855_, this.f_19856_);
                bullet.m_6686_(0.0, 1.0, 0.0, 0.7f, 0.0f);
                this.m_9236_().m_7967_((Entity)bullet);
            }
            if (this.getBulletType().getBulletSpecial() == BulletType.BulletSpecial.EXPLODE) {
                this.m_9236_().m_255391_((Entity)this, this.f_19854_, this.f_19855_, this.f_19856_, (float)this.getBulletType().effectPower, false, Level.ExplosionInteraction.TNT);
            }
            if (this.getBulletType().getBulletSpecial() == BulletType.BulletSpecial.MOB_EXPLODE) {
                this.m_9236_().m_255391_((Entity)this, this.f_19854_, this.f_19855_, this.f_19856_, (float)this.getBulletType().effectPower, false, Level.ExplosionInteraction.MOB);
            }
            if (this.getBulletType() == BulletType.METEOR) {
                this.m_9236_().m_255391_((Entity)this, this.f_19854_, this.f_19855_, this.f_19856_, 4.5f, false, Level.ExplosionInteraction.TNT);
            }
            this.m_9236_().m_7605_((Entity)this, (byte)3);
        }
    }

    public void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!(entity instanceof EnderMan)) {
                if (this.getBulletType().getBulletSpecial() == BulletType.BulletSpecial.POISON) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, this.bulletType.effectSec * 20, this.bulletType.effectPower));
                }
                if (this.getBulletType().getBulletSpecial() == BulletType.BulletSpecial.SLOW) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, this.bulletType.effectSec * 20, this.bulletType.effectPower));
                }
                if (this.getBulletType().getBulletSpecial() == BulletType.BulletSpecial.FLAME) {
                    livingEntity.m_20254_(this.bulletType.effectSec);
                }
            }
        }
        if (!(this instanceof EntityBouncingProjectile) && this.getBulletType().getBulletDamageType() != BulletType.BulletDamageType.NONE) {
            if (this.getBulletType().getBulletDamageType() == BulletType.BulletDamageType.PHYSIC) {
                entity.m_6469_(this.m_269291_().m_269390_((Entity)this, (Entity)this.thrower), this.getBulletType().getDamage());
            } else {
                entity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this.thrower), this.getBulletType().getDamage());
            }
        }
        if (this.thrower != null) {
            double xDist = (this.thrower.f_19854_ - this.f_19854_) / 5.0;
            double yDist = (this.thrower.f_19855_ - this.f_19855_) / 5.0;
            double zDist = (this.thrower.f_19856_ - this.f_19856_) / 5.0;
            if (this.getBulletType().getBulletSpecial() == BulletType.BulletSpecial.PULL) {
                entity.m_20334_(xDist, yDist, zDist);
            }
            if (this.getBulletType().getBulletSpecial() == BulletType.BulletSpecial.PUSH) {
                entity.m_20334_(-xDist, -yDist, -zDist);
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (!this.m_9236_().m_5776_()) {
            if (this.bulletType == BulletType.SHURIKEN_SHOT) {
                this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.f_19854_, this.f_19855_, this.f_19856_, new ItemStack((ItemLike)ItemRegistry.shuriken.get())));
            }
            if (this.bulletType == BulletType.VILE_STORM_SHOT) {
                this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.f_19854_, this.f_19855_, this.f_19856_, new ItemStack((ItemLike)ItemRegistry.vile_storm.get())));
            }
            if (this.bulletType == BulletType.SNOWFLAKE_SHURIKEN_SHOT) {
                this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.f_19854_, this.f_19855_, this.f_19856_, new ItemStack((ItemLike)ItemRegistry.snowflake_shuriken.get())));
            }
            if (this.bulletType == BulletType.EDEN_SLICER_SHOT) {
                this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.f_19854_, this.f_19855_, this.f_19856_, new ItemStack((ItemLike)ItemRegistry.eden_slicer.get())));
            }
            if (this.bulletType == BulletType.WILDWOOD_SLICER_SHOT) {
                this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.f_19854_, this.f_19855_, this.f_19856_, new ItemStack((ItemLike)ItemRegistry.wildwood_slicer.get())));
            }
            if (this.bulletType == BulletType.APALACHIA_SLICER_SHOT) {
                this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.f_19854_, this.f_19855_, this.f_19856_, new ItemStack((ItemLike)ItemRegistry.apalachia_slicer.get())));
            }
            if (this.bulletType == BulletType.SKYTHERN_SLICER_SHOT) {
                this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.f_19854_, this.f_19855_, this.f_19856_, new ItemStack((ItemLike)ItemRegistry.skythern_slicer.get())));
            }
            if (this.bulletType == BulletType.MORTUM_SLICER_SHOT) {
                this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.f_19854_, this.f_19855_, this.f_19856_, new ItemStack((ItemLike)ItemRegistry.mortum_slicer.get())));
            }
            if (this.bulletType == BulletType.HALITE_SLICER_SHOT) {
                this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.f_19854_, this.f_19855_, this.f_19856_, new ItemStack((ItemLike)ItemRegistry.halite_slicer.get())));
            }
            this.m_9236_().m_7605_((Entity)this, (byte)3);
        }
    }

    public void m_8097_() {
        this.f_19804_.m_135372_(BULLET_ID, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("projectileId", this.getBulletId());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBulletId(compound.m_128445_("projectileId"));
        this.bulletType = BulletType.getBulletFromOrdinal(this.getBulletId());
    }

    private byte getBulletId() {
        return (Byte)this.f_19804_.m_135370_(BULLET_ID);
    }

    private void setBulletId(byte projectileId) {
        this.f_19804_.m_135381_(BULLET_ID, (Object)projectileId);
    }

    public BulletType getBulletType() {
        if (this.bulletType == null) {
            this.bulletType = BulletType.getBulletFromOrdinal(this.getBulletId());
        }
        return this.bulletType;
    }

    public ResourceLocation getTexture() {
        return this.getBulletType().getTexture();
    }
}

