/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.enums;

import divinerpg.registries.ItemRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public enum ArrowType {
    HUNTER_ARROW(2.0f, ArrowType.ProjectileLoc("hunter_arrow"), Items.f_42412_, ArrowSpecial.POISON, 2),
    SHADOW_ARROW(2.0f, ArrowType.ProjectileLoc("shadow_arrow"), Items.f_42412_),
    ENDER_ARROW(4.0f, ArrowType.ProjectileLoc("ender_arrow")),
    SOULFIRE_ARROW(2.0f, ArrowType.ProjectileLoc("soulfire_arrow"), ArrowSpecial.EXPLODE),
    INFERNO_ARROW(2.0f, ArrowType.ProjectileLoc("inferno_arrow"), ArrowSpecial.FLAME, 12),
    ICICLE_ARROW(2.0f, ArrowType.ProjectileLoc("icicle_arrow"), Items.f_42412_),
    SNOWSTORM_ARROW(2.0f, ArrowType.ProjectileLoc("snowstorm_arrow"), ArrowSpecial.EXPLODE),
    EDEN_ARROW(6.0f, ArrowType.ProjectileLoc("eden_arrow"), (Item)ItemRegistry.eden_arrow.get()),
    LESSER_WILDWOOD_ARROW(6.0f, ArrowType.ProjectileLoc("wildwood_arrow"), (Item)ItemRegistry.wildwood_arrow.get()),
    GREATER_WILDWOOD_ARROW(10.0f, ArrowType.ProjectileLoc("wildwood_arrow"), (Item)ItemRegistry.wildwood_arrow.get()),
    FURY_ARROW(13.0f, ArrowType.ProjectileLoc("fury_arrow"), (Item)ItemRegistry.fury_arrow.get()),
    EVERFRIGHT(25.0f, ArrowType.ProjectileLoc("ever_arrow"), (Item)ItemRegistry.ever_arrow.get()),
    TEAKER_ARROW(2.0f, ArrowType.ProjectileLoc("teaker_arrow"), (Item)ItemRegistry.teaker_arrow.get()),
    AMTHIRMIS_ARROW(2.0f, ArrowType.ProjectileLoc("teaker_arrow"), (Item)ItemRegistry.teaker_arrow.get()),
    DARVEN_ARROW(3.0f, ArrowType.ProjectileLoc("darven_arrow"), (Item)ItemRegistry.darven_arrow.get()),
    CERMILE_ARROW(4.0f, ArrowType.ProjectileLoc("darven_arrow"), (Item)ItemRegistry.darven_arrow.get()),
    PARDIMAL_ARROW(5.0f, ArrowType.ProjectileLoc("pardimal_arrow"), (Item)ItemRegistry.pardimal_arrow.get()),
    QUADROTIC_ARROW(6.0f, ArrowType.ProjectileLoc("pardimal_arrow"), (Item)ItemRegistry.pardimal_arrow.get()),
    KAROS_ARROW(7.0f, ArrowType.ProjectileLoc("karos_arrow"), (Item)ItemRegistry.karos_arrow.get()),
    HELIOSIS_ARROW(8.0f, ArrowType.ProjectileLoc("karos_arrow"), (Item)ItemRegistry.karos_arrow.get()),
    ARKSIANE_ARROW(12.0f, ArrowType.ProjectileLoc("karos_arrow"), (Item)ItemRegistry.karos_arrow.get()),
    ARID_WARRIOR_ARROW(1.5f, ArrowType.VanillaLoc()),
    WILDFIRE_ARROW(5.0f, ArrowType.ProjectileLoc("inferno_arrow"), ArrowSpecial.FLAME, 6),
    PALE_ARCHER_ARROW(2.0f, ArrowType.ProjectileLoc("snowstorm_arrow")),
    SUN_ARCHER_ARROW(9.0f, ArrowType.ProjectileLoc("eden_arrow")),
    ENCHANTED_ARCHER_ARROW(12.0f, ArrowType.ProjectileLoc("wildwood_arrow")),
    SKYTHERN_ARCHER_ARROW(14.0f, ArrowType.ProjectileLoc("wildwood_arrow")),
    TWILIGHT_ARCHER_ARROW(16.0f, ArrowType.ProjectileLoc("fury_arrow")),
    REYVOR_ARROW(22.0f, ArrowType.ProjectileLoc("fury_arrow")),
    ETERNAL_ARCHER_FLAME_ARROW(26.0f, ArrowType.ProjectileLoc("fury_arrow"), ArrowSpecial.FLAME, 8),
    ETERNAL_ARCHER_WITHER_ARROW(26.0f, ArrowType.ProjectileLoc("fury_arrow"), ArrowSpecial.WITHER, 5),
    ETERNAL_ARCHER_EXPLODE_ARROW(26.0f, ArrowType.ProjectileLoc("fury_arrow"), ArrowSpecial.EXPLODE),
    ETERNAL_ARCHER_SLOW_ARROW(26.0f, ArrowType.ProjectileLoc("fury_arrow"), ArrowSpecial.SLOW, 5),
    ETERNAL_ARCHER_NAUSEA_ARROW(26.0f, ArrowType.ProjectileLoc("fury_arrow"), ArrowSpecial.NAUSEA, 10),
    ETERNAL_ARCHER_BLIND_ARROW(26.0f, ArrowType.ProjectileLoc("fury_arrow"), ArrowSpecial.BLIND, 5),
    LIVING_STATUE_ARROW(6.0f, ArrowType.VanillaLoc());

    private final float baseDamage;
    private final ResourceLocation texture;
    private final ArrowSpecial arrowSpecial;
    private final Item arrowSupplier;
    public int effectSec;

    private ArrowType(float baseDamage, ResourceLocation texture) {
        this.baseDamage = baseDamage;
        this.texture = texture;
        this.arrowSpecial = ArrowSpecial.NONE;
        this.arrowSupplier = null;
    }

    private ArrowType(float baseDamage, ResourceLocation texture, Item ammo) {
        this.baseDamage = baseDamage;
        this.texture = texture;
        this.arrowSpecial = ArrowSpecial.NONE;
        this.arrowSupplier = ammo;
    }

    private ArrowType(float baseDamage, ResourceLocation texture, ArrowSpecial special) {
        this.baseDamage = baseDamage;
        this.texture = texture;
        this.arrowSupplier = null;
        this.arrowSpecial = special;
    }

    private ArrowType(float baseDamage, ResourceLocation texture, ArrowSpecial special, int seconds) {
        this.baseDamage = baseDamage;
        this.texture = texture;
        this.arrowSupplier = null;
        this.arrowSpecial = special;
        this.effectSec = seconds;
    }

    private ArrowType(float baseDamage, ResourceLocation texture, Item ammo, ArrowSpecial special, int seconds) {
        this.baseDamage = baseDamage;
        this.texture = texture;
        this.arrowSupplier = ammo;
        this.arrowSpecial = special;
        this.effectSec = seconds;
    }

    public static ArrowType getArrowFromId(int ordinal) {
        if (ordinal < 0 || ordinal > ArrowType.values().length) {
            ordinal = 0;
        }
        return ArrowType.values()[ordinal];
    }

    private static ResourceLocation ProjectileLoc(String name) {
        return new ResourceLocation("divinerpg", "textures/projectiles/" + name + ".png");
    }

    private static ResourceLocation VanillaLoc() {
        return new ResourceLocation("textures/entity/projectiles/arrow.png");
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public ArrowSpecial getArrowSpecial() {
        return this.arrowSpecial;
    }

    public Item getArrowSupplier() {
        return this.arrowSupplier;
    }

    public static enum ArrowSpecial {
        NONE,
        FLAME,
        WITHER,
        EXPLODE,
        SLOW,
        NAUSEA,
        BLIND,
        POISON;

    }
}

