/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import divinerpg.capability.ArcanaProvider;
import divinerpg.effect.mob.armor.ArmorEffectInstance;
import divinerpg.effect.mob.armor.UpdatableArmorEffect;
import divinerpg.enums.ToolStats;
import divinerpg.items.base.ItemDivineArmor;
import divinerpg.items.base.ItemModSword;
import divinerpg.registries.MobEffectRegistry;
import divinerpg.util.DamageSources;
import java.util.ArrayList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ArmorAbilitiesEvent {
    @SubscribeEvent
    public void onEquipmentChanged(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntity();
        EquipmentSlot slot = event.getSlot();
        if (slot.m_254934_()) {
            MobEffect[] mobEffectArray;
            ItemStack s = event.getFrom();
            if (s != null && (mobEffectArray = s.m_41720_()) instanceof ItemDivineArmor) {
                ItemDivineArmor armor = (ItemDivineArmor)mobEffectArray;
                if (!s.m_150930_(event.getTo().m_41720_()) && armor.supportedEffects != null) {
                    for (MobEffect effect : armor.supportedEffects) {
                        entity.m_21195_(effect);
                    }
                }
            }
            ArmorAbilitiesEvent.updateAbilities(entity);
        } else {
            for (MobEffectInstance instance : entity.m_21220_()) {
                MobEffect mobEffect = instance.m_19544_();
                if (!(mobEffect instanceof UpdatableArmorEffect)) continue;
                UpdatableArmorEffect update = (UpdatableArmorEffect)mobEffect;
                update.update(entity);
            }
        }
    }

    public static void updateAbilities(LivingEntity entity) {
        boolean fullArmor;
        int i;
        ArrayList<MobEffect> supportedEffects = new ArrayList<MobEffect>();
        ArrayList<Integer> amplifiers = new ArrayList<Integer>();
        ItemStack[] stack = new ItemStack[]{entity.m_6844_(EquipmentSlot.HEAD), entity.m_6844_(EquipmentSlot.CHEST), entity.m_6844_(EquipmentSlot.LEGS), entity.m_6844_(EquipmentSlot.FEET)};
        ArrayList<ItemDivineArmor> equipment = new ArrayList<ItemDivineArmor>();
        for (ItemStack s : stack) {
            Item item;
            if (s == null || !((item = s.m_41720_()) instanceof ItemDivineArmor)) continue;
            ItemDivineArmor armor = (ItemDivineArmor)item;
            equipment.add(armor);
        }
        for (ItemDivineArmor armor : equipment) {
            if (armor.supportedEffects == null) continue;
            for (i = 0; i < armor.supportedEffects.length; ++i) {
                MobEffect supportedEffect = armor.supportedEffects[i];
                if (supportedEffects.contains(supportedEffect)) continue;
                supportedEffects.add(supportedEffect);
                amplifiers.add(armor.amplifier == null ? 0 : armor.amplifier[i]);
            }
        }
        boolean bl = fullArmor = equipment.size() == 4;
        if (fullArmor) {
            ArmorMaterial mat = ((ItemDivineArmor)equipment.get((int)0)).mat;
            for (i = 1; fullArmor && i < 4; ++i) {
                if (((ItemDivineArmor)equipment.get((int)i)).mat == mat) continue;
                fullArmor = false;
            }
            if (fullArmor) {
                for (i = 0; i < supportedEffects.size(); ++i) {
                    MobEffectInstance instance;
                    MobEffect supportedEffect = (MobEffect)supportedEffects.get(i);
                    boolean shouldRemove = false;
                    if (!entity.m_21023_(supportedEffect) || (shouldRemove = !(instance = entity.m_21124_(supportedEffect)).m_267577_() || !(instance instanceof ArmorEffectInstance))) {
                        if (shouldRemove) {
                            entity.m_21195_(supportedEffect);
                        }
                        entity.m_7292_((MobEffectInstance)new ArmorEffectInstance(supportedEffect, (Integer)amplifiers.get(i)));
                        continue;
                    }
                    if (!(supportedEffect instanceof UpdatableArmorEffect)) continue;
                    UpdatableArmorEffect update = (UpdatableArmorEffect)supportedEffect;
                    update.update(entity);
                }
            }
        }
        if (!fullArmor) {
            for (MobEffect supportedEffect : supportedEffects) {
                if (!entity.m_21023_(supportedEffect) || !entity.m_21124_(supportedEffect).m_267577_()) continue;
                entity.m_21195_(supportedEffect);
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingDamageEvent event) {
        LivingEntity target = event.getEntity();
        float amount = event.getAmount();
        Entity entity = event.getSource().m_7639_();
        DamageSource source = event.getSource();
        if (entity instanceof Player) {
            Player attacker = (Player)entity;
            if (source.m_276093_(DamageTypes.f_268464_)) {
                ItemStack item = attacker.m_21120_(InteractionHand.MAIN_HAND);
                Item item2 = item.m_41720_();
                if (item2 instanceof ItemModSword) {
                    ItemModSword sword = (ItemModSword)item2;
                    if (sword.arcanaConsumedAttack != 0) {
                        attacker.getCapability(ArcanaProvider.ARCANA).ifPresent(arcana -> {
                            if (arcana.getAmount(false) >= (float)sword.arcanaConsumedAttack) {
                                arcana.modifyAmount((LivingEntity)attacker, -sword.arcanaConsumedAttack);
                                if (sword.sword.getSwordSpecial() == ToolStats.SwordSpecial.ARCANA_DAMAGE) {
                                    event.setAmount(amount + CombatRules.m_19272_((float)sword.sword.effectPower, (float)target.m_21230_(), (float)((float)target.m_21133_(Attributes.f_22285_))));
                                }
                                sword.arcanicAttack(item, attacker, (Entity)target);
                            }
                        });
                    }
                }
                if (attacker.m_21023_((MobEffect)MobEffectRegistry.HALITE_STRENGTH.get())) {
                    event.setAmount(amount + CombatRules.m_19272_((float)16.0f, (float)target.m_21230_(), (float)((float)target.m_21133_(Attributes.f_22285_))));
                } else if (attacker.m_21023_((MobEffect)MobEffectRegistry.DIVINE_STRENGTH.get()) || attacker.m_21023_((MobEffect)MobEffectRegistry.DEMONIZED_HELMET.get())) {
                    event.setAmount(amount + CombatRules.m_19272_((float)6.0f, (float)target.m_21230_(), (float)((float)target.m_21133_(Attributes.f_22285_))));
                } else if (attacker.m_21023_((MobEffect)MobEffectRegistry.GLISTENING_HELMET.get())) {
                    event.setAmount(amount + CombatRules.m_19272_((float)3.0f, (float)target.m_21230_(), (float)((float)target.m_21133_(Attributes.f_22285_))));
                } else if (attacker.m_21023_((MobEffect)MobEffectRegistry.SENG_FUR.get())) {
                    event.setAmount(amount + CombatRules.m_19272_((float)2.0f, (float)target.m_21230_(), (float)((float)target.m_21133_(Attributes.f_22285_))));
                } else if (attacker.m_21023_((MobEffect)MobEffectRegistry.TORMENTED_HELMET.get())) {
                    event.setAmount(amount + CombatRules.m_19272_((float)9.0f, (float)target.m_21230_(), (float)((float)target.m_21133_(Attributes.f_22285_))));
                } else if (attacker.m_21023_((MobEffect)MobEffectRegistry.AWAKENED_HALITE_STRENGTH.get())) {
                    event.setAmount(amount + CombatRules.m_19272_((float)20.0f, (float)target.m_21230_(), (float)((float)target.m_21133_(Attributes.f_22285_))));
                }
            } else if ((attacker.m_21023_((MobEffect)MobEffectRegistry.AWAKENED_HALITE_STRENGTH.get()) || attacker.m_21023_((MobEffect)MobEffectRegistry.CORRUPTED_STRENGTH.get())) && (source.m_276093_(DamageTypes.f_268534_) || source.m_276093_(DamageTypes.f_268739_) || source.m_276093_(DamageTypes.f_268425_) || source.m_276093_(DamageTypes.f_268714_))) {
                event.setAmount(amount * 1.5f);
            }
        }
        if (target instanceof Player) {
            if (target.m_21023_((MobEffect)MobEffectRegistry.PROJECTILE_PROTECTION.get()) && (source.m_276093_(DamageTypes.f_268534_) || source.m_276093_(DamageTypes.f_268739_) || source.m_276093_(DamageTypes.f_268425_) || source.m_276093_(DamageTypes.f_268714_))) {
                event.setAmount(event.getAmount() * 0.34f);
            } else if (target.m_21023_((MobEffect)MobEffectRegistry.MELEE_PROTECTION.get()) && (source.m_276093_(DamageTypes.f_268566_) || source.m_276093_(DamageTypes.f_268464_) || source.m_276093_(DamageTypes.f_268433_)) && !source.m_276093_(DamageTypes.f_268534_)) {
                event.setAmount(event.getAmount() * 0.67f);
            } else if (target.m_21023_((MobEffect)MobEffectRegistry.SENG_FUR.get())) {
                event.setAmount(event.getAmount() * 0.7f);
            } else if (target.m_21023_((MobEffect)MobEffectRegistry.DEGRADED_HOOD.get()) && source.m_276093_(DamageTypes.f_268515_) || target.m_21023_((MobEffect)MobEffectRegistry.DEGRADED_HELMET.get()) && !source.m_276093_(DamageTypes.f_268534_) && !source.m_276093_(DamageTypes.f_268515_) || target.m_21023_((MobEffect)MobEffectRegistry.DEGRADED_MASK.get()) && source.m_276093_(DamageTypes.f_268534_) && !source.m_276093_(DamageTypes.f_268515_)) {
                event.setAmount(amount * 0.82f);
            } else if (target.m_21023_((MobEffect)MobEffectRegistry.FINISHED_HOOD.get()) && source.m_276093_(DamageTypes.f_268515_) || target.m_21023_((MobEffect)MobEffectRegistry.FINISHED_HELMET.get()) && !source.m_276093_(DamageTypes.f_268534_) && !source.m_276093_(DamageTypes.f_268515_) || target.m_21023_((MobEffect)MobEffectRegistry.FINISHED_MASK.get()) && source.m_276093_(DamageTypes.f_268534_) && !source.m_276093_(DamageTypes.f_268515_)) {
                event.setAmount(amount * 0.773f);
            } else if (target.m_21023_((MobEffect)MobEffectRegistry.GLISTENING_HOOD.get()) && source.m_276093_(DamageTypes.f_268515_) || target.m_21023_((MobEffect)MobEffectRegistry.GLISTENING_HELMET.get()) && !source.m_276093_(DamageTypes.f_268534_) && !source.m_276093_(DamageTypes.f_268515_) || target.m_21023_((MobEffect)MobEffectRegistry.GLISTENING_MASK.get()) && source.m_276093_(DamageTypes.f_268534_) && !source.m_276093_(DamageTypes.f_268515_)) {
                event.setAmount(amount * 0.7f);
            } else if (target.m_21023_((MobEffect)MobEffectRegistry.DEMONIZED_HOOD.get()) && source.m_276093_(DamageTypes.f_268515_) || target.m_21023_((MobEffect)MobEffectRegistry.DEMONIZED_HELMET.get()) && !source.m_276093_(DamageTypes.f_268534_) && !source.m_276093_(DamageTypes.f_268515_) || target.m_21023_((MobEffect)MobEffectRegistry.DEMONIZED_MASK.get()) && source.m_276093_(DamageTypes.f_268534_) && !source.m_276093_(DamageTypes.f_268515_)) {
                event.setAmount(amount * 0.625f);
            } else if (target.m_21023_((MobEffect)MobEffectRegistry.TORMENTED_HOOD.get()) && source.m_276093_(DamageTypes.f_268515_) || target.m_21023_((MobEffect)MobEffectRegistry.TORMENTED_HELMET.get()) && !source.m_276093_(DamageTypes.f_268534_) && !source.m_276093_(DamageTypes.f_268515_) || target.m_21023_((MobEffect)MobEffectRegistry.TORMENTED_MASK.get()) && source.m_276093_(DamageTypes.f_268534_) && !source.m_276093_(DamageTypes.f_268515_)) {
                event.setAmount(amount * 0.348f);
            } else if (target.m_21023_((MobEffect)MobEffectRegistry.BLOCK_PROTECTION.get()) && (source.m_276093_(DamageTypes.f_268534_) || source.m_276093_(DamageTypes.f_268585_) || source.equals(target.m_269291_().m_269564_((Entity)target)) || source.equals(target.m_269291_().m_269230_((Entity)target)) || source.equals(target.m_269291_().m_269318_()) || source.equals(DamageSources.source(target.m_9236_(), DamageSources.TRAP)))) {
                event.setCanceled(true);
            } else if (target.m_21023_((MobEffect)MobEffectRegistry.EXPLOSION_PROTECTION.get()) && (source.m_276093_(DamageTypes.f_268565_) || source.m_276093_(DamageTypes.f_268448_))) {
                event.setCanceled(true);
            }
        }
    }
}

