/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import divinerpg.capability.Arcana;
import divinerpg.capability.ArcanaProvider;
import divinerpg.capability.DimensionalInventory;
import divinerpg.capability.DimensionalInventoryProvider;
import divinerpg.capability.Reputation;
import divinerpg.capability.ReputationProvider;
import divinerpg.capability.SoulTrapCount;
import divinerpg.capability.SoulTrapCountProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;

public class AttatchCapabilityEvent {
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(Arcana.class);
        event.register(SoulTrapCount.class);
        event.register(Reputation.class);
        event.register(DimensionalInventory.class);
    }

    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            if (!player.getCapability(ArcanaProvider.ARCANA).isPresent()) {
                event.addCapability(new ResourceLocation("divinerpg", "arcana"), (ICapabilityProvider)new ArcanaProvider());
            }
            if (!player.getCapability(ReputationProvider.REPUTATION).isPresent()) {
                event.addCapability(new ResourceLocation("divinerpg", "reputation"), (ICapabilityProvider)new ReputationProvider());
            }
            if (!player.getCapability(DimensionalInventoryProvider.DIMENIONAL_INVENTORY).isPresent()) {
                event.addCapability(new ResourceLocation("divinerpg", "dimensional_inventory"), (ICapabilityProvider)new DimensionalInventoryProvider());
            }
        }
    }

    public static void onAttachCapabilitiesLevelChunk(AttachCapabilitiesEvent<LevelChunk> event) {
        if (event.getObject() instanceof LevelChunk && !((LevelChunk)event.getObject()).getCapability(SoulTrapCountProvider.SOUL_TRAP_COUNT).isPresent()) {
            event.addCapability(new ResourceLocation("divinerpg", "soul_trap_count"), (ICapabilityProvider)new SoulTrapCountProvider());
        }
    }
}

