/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import divinerpg.capability.SoulTrapCount;
import divinerpg.capability.SoulTrapCountProvider;
import divinerpg.entities.ai.TurtleEatAequorea;
import divinerpg.entities.eden.EntityWeakCori;
import divinerpg.entities.vanilla.end.EntityEnderTriplets;
import divinerpg.entities.vanilla.overworld.EntityAequorea;
import divinerpg.entities.vanilla.overworld.EntityCaveclops;
import divinerpg.entities.vanilla.overworld.EntityCrab;
import divinerpg.entities.vanilla.overworld.EntityEnthralledDramcryx;
import divinerpg.entities.vanilla.overworld.EntityJackOMan;
import divinerpg.entities.vanilla.overworld.EntityKobblin;
import divinerpg.entities.vanilla.overworld.EntityLiopleurodon;
import divinerpg.entities.vanilla.overworld.EntityRainbour;
import divinerpg.entities.vanilla.overworld.EntityRotatick;
import divinerpg.entities.vanilla.overworld.EntitySaguaroWorm;
import divinerpg.entities.vanilla.overworld.EntityTheEye;
import divinerpg.entities.vanilla.overworld.EntityTheGrue;
import divinerpg.registries.EntityRegistry;
import java.lang.invoke.LambdaMetafactory;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="divinerpg", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SpawnEvents {
    public static void spawnPlacementCheck(MobSpawnEvent.SpawnPlacementCheck e) {
        ServerLevelAccessor serverLevelAccessor = e.getLevel();
        if (serverLevelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)serverLevelAccessor;
            MobSpawnType type = e.getSpawnType();
            if ((type == MobSpawnType.NATURAL || type == MobSpawnType.STRUCTURE || type == MobSpawnType.PATROL) && ((SoulTrapCount)level.m_46745_((BlockPos)e.getPos()).getCapability(SoulTrapCountProvider.SOUL_TRAP_COUNT).orElseGet((NonNullSupplier)(NonNullSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$spawnPlacementCheck$0(), ()Ldivinerpg/capability/SoulTrapCount;)())).count > 0) {
                e.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent e) {
        SpawnEvents.registerSpawn(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.AYERACO.get()));
        SpawnEvents.registerWaterSpawn(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.AEQUOREA.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.ARID_WARRIOR.get()));
        SpawnEvents.registerSpawn(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.BROWN_GRIZZLE.get()));
        SpawnEvents.registerDarkSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.CAVE_CRAWLER.get()));
        SpawnEvents.registerSpawn(e, (EntityType)EntityRegistry.CAVECLOPS.get(), EntityCaveclops::caveClopsSpawnRule);
        SpawnEvents.registerSpawn(e, (EntityType)EntityRegistry.CRAB.get(), EntityCrab::crabSpawnRule);
        SpawnEvents.registerSpawn(e, (EntityType)EntityRegistry.CYCLOPS.get(), EntityKobblin::kobblinSpawnRule);
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.DESERT_CRAWLER.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.DIAMOND_DAVE.get()));
        SpawnEvents.registerSpawn(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.EHU.get()));
        SpawnEvents.registerSpawn(e, (EntityType)EntityRegistry.ENTHRALLED_DRAMCRYX.get(), EntityEnthralledDramcryx::enthralledDramcryxSpawnRule);
        SpawnEvents.registerAgileSurfaceMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.FROST.get()));
        SpawnEvents.registerSurfaceMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.GLACON.get()));
        SpawnEvents.registerSpawn(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.HUSK.get()));
        SpawnEvents.registerSpawn(e, (EntityType)EntityRegistry.JACK_O_MAN.get(), EntityJackOMan::rules);
        SpawnEvents.registerAirSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.JUNGLE_BAT.get()));
        SpawnEvents.registerAgileMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.JUNGLE_DRAMCRYX.get()));
        SpawnEvents.registerAgileMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.JUNGLE_SPIDER.get()));
        SpawnEvents.registerSpawn(e, (EntityType)EntityRegistry.KING_CRAB.get(), EntityCrab::crabSpawnRule);
        SpawnEvents.registerSpawn(e, (EntityType)EntityRegistry.KOBBLIN.get(), EntityKobblin::kobblinSpawnRule);
        SpawnEvents.registerWaterSpawn(e, (EntityType)EntityRegistry.LIOPLEURODON.get(), EntityLiopleurodon::liopleurodonSpawnRule);
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.LIVESTOCK_MERCHANT.get()));
        SpawnEvents.registerDarkSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.MINER.get()));
        SpawnEvents.registerSpawn(e, (EntityType)EntityRegistry.PUMPKIN_SPIDER.get(), EntityKobblin::kobblinSpawnRule);
        SpawnEvents.registerAirSpawn(e, (EntityType)EntityRegistry.RAINBOUR.get(), EntityRainbour::rainbourSpawnRule);
        SpawnEvents.registerSpawn(e, (EntityType)EntityRegistry.ROTATICK.get(), EntityRotatick::rotatickSpawnRule);
        SpawnEvents.registerSpawn(e, (EntityType)EntityRegistry.SAGUARO_WORM.get(), EntitySaguaroWorm::saguaroWormSpawnRule);
        SpawnEvents.registerWaterSpawn(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SHARK.get()));
        SpawnEvents.registerSpawn(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SMELTER.get()));
        SpawnEvents.registerSpawn(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SNAPPER.get()));
        SpawnEvents.registerSpawn(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.STONE_GOLEM.get()));
        SpawnEvents.registerSpawn(e, (EntityType)EntityRegistry.THE_EYE.get(), EntityTheEye::theEyeSpawnRule);
        SpawnEvents.registerSpawn(e, (EntityType)EntityRegistry.THE_GRUE.get(), EntityTheGrue::theGrueSpawnRule);
        SpawnEvents.registerWaterSpawn(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.WHALE.get()));
        SpawnEvents.registerSpawn(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.WHITE_GRIZZLE.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.HELL_PIG.get()));
        SpawnEvents.registerAgileMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.HELL_SPIDER.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.SCORCHER.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.WILDFIRE.get()));
        SpawnEvents.registerDarkSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.ENDER_SPIDER.get()));
        SpawnEvents.registerAirSpawn(e, (EntityType)EntityRegistry.ENDER_TRIPLETS.get(), EntityEnderTriplets::enderTripletSpawnRule);
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.ENDER_WATCHER.get()));
        SpawnEvents.registerWaterSpawn(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.CAULDRON_FISH.get()));
        SpawnEvents.registerSurfaceSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.BLUBBERTUSK.get()));
        SpawnEvents.registerAgileMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.ROBBIN.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.WOLPERTINGER.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.DOLOSSAL.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.MAMOTH.get()));
        SpawnEvents.registerAgileMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.SNOW_SKIPPER.get()));
        SpawnEvents.registerWaterSpawn(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.PINK_GHOST_GLIDER.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.SENG.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.SABEAR.get()));
        SpawnEvents.registerAgileMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.ALICANTO.get()));
        SpawnEvents.registerAgileMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.FRACTITE.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.PALE_ARCHER.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.FROZEN_FLESH.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.GLACIDE.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.HASTREUS.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.ROLLUM.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.WORKSHOP_MERCHANT.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.WORKSHOP_TINKERER.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.GROGLIN_HUNTER.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.GRUZZORLUG_MINER.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.ROBBIN.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.WOLPERTINGER.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.GLINTHOP.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.EDEN_CADILLION.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.EDEN_TOMO.get()));
        SpawnEvents.registerDarkSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.GREENFEET.get()));
        SpawnEvents.registerDarkSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.MADIVEL.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.SUN_ARCHER.get()));
        SpawnEvents.registerAirSpawn(e, (EntityType)EntityRegistry.WEAK_CORI.get(), EntityWeakCori::weakCoriSpawnRule);
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.BEHEMOTH.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.EPIPHITE.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.MAGE.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.MOON_WOLF.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.TERMID.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.VEREK.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.WILDWOOD_CADILLION.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.WILDWOOD_GOLEM.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.WILDWOOD_TOMO.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.APALACHIA_CADILLION.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.APALACHIA_GOLEM.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.APALACHIA_TOMO.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.ENCHANTED_ARCHER.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.ENCHANTED_WARRIOR.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.SPELLBINDER.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.ADVANCED_CORI.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.MEGALITH.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.MYSTIC.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.SAMEK.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.SKYTHERN_ARCHER.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.SKYTHERN_FIEND.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.SKYTHERN_GOLEM.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.ANGRY_GLINTHOP.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.BASILISK.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.DEMON_OF_DARKNESS.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.MORTUM_CADILLION.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.SORCERER.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.SOUL_SPIDER.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.SOUL_STEALER.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.TWILIGHT_ARCHER.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.CAPTAIN_MERIK.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.DATTICON.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.DEATHCRYX.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.DEATH_HOUND.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.DUNGEON_CONSTRUCTOR.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.DUNGEON_DEMON.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.DUNGEON_PRISONER.get()));
        SpawnEvents.registerSpawn(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.FYRACRYX.get()));
        SpawnEvents.registerSpawn(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.GOLEM_OF_REJUVENATION.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.KAZARI.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.LEORNA.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.LORD_VATTICUS.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.LIVING_STATUE.get()));
        SpawnEvents.registerSpawn(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.PARATIKU.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.RAZORBACK.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.ROAMER.get()));
        SpawnEvents.registerSpawn(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SEIMER.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.SKYRE.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.WAR_GENERAL.get()));
        SpawnEvents.registerSpawn(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.WRAITH.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.ZELUS.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.ACID_HAG.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.BIPHRON.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.BOHEMITE.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.CRYPT_KEEPER.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.CYMESOID.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.DISSIMENT.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.DREAMWRECKER.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.DUO.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.ENT.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.FAKE_VHRAAK.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.GALROID.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.GORGOSION.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.HELIO.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.HIVE_SOLDIER.get()));
        SpawnEvents.registerDarkSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.HOVER_STINGER.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.KAZROTIC.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.LHEIVA.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.LORGA.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.LORGA_FLIGHT.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.MANDRAGORA.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.MYSTERIOUS_MAN_LAYER1.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.MYSTERIOUS_MAN_LAYER2.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.MYSTERIOUS_MAN_LAYER3.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.SHADAHIER.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.TEMPLE_GUARDIAN.get()));
        SpawnEvents.registerMobSpawn(e, (EntityType<? extends Mob>)((EntityType)EntityRegistry.THE_HUNGER.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.TOCAXIN.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.TWINS.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.VERMENOUS.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.VHRAAK.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.ZONE.get()));
        SpawnEvents.registerMonsterSpawn(e, (EntityType<? extends Monster>)((EntityType)EntityRegistry.ZORAGON.get()));
    }

    public static void registerSpawn(SpawnPlacementRegisterEvent e, EntityType<? extends Entity> type) {
        e.register(type, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnEvents::always, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static <T extends Entity> void registerSpawn(SpawnPlacementRegisterEvent e, EntityType<T> type, SpawnPlacements.SpawnPredicate<T> predicate) {
        e.register(type, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, predicate, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void registerAgileMonsterSpawn(SpawnPlacementRegisterEvent e, EntityType<? extends Monster> type) {
        e.register(type, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, Monster::m_219019_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void registerAgileMobSpawn(SpawnPlacementRegisterEvent e, EntityType<? extends Mob> type) {
        e.register(type, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void registerWaterSpawn(SpawnPlacementRegisterEvent e, EntityType<? extends Entity> type) {
        e.register(type, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING, SpawnEvents::always, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static <T extends Entity> void registerWaterSpawn(SpawnPlacementRegisterEvent e, EntityType<T> type, SpawnPlacements.SpawnPredicate<T> predicate) {
        e.register(type, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING, predicate, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void registerLavaSpawn(SpawnPlacementRegisterEvent e, EntityType<? extends Mob> type) {
        e.register(type, SpawnPlacements.Type.IN_LAVA, Heightmap.Types.MOTION_BLOCKING, SpawnEvents::always, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void registerAirSpawn(SpawnPlacementRegisterEvent e, EntityType<? extends Mob> type) {
        e.register(type, SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, SpawnEvents::always, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static <T extends Mob> void registerAirSpawn(SpawnPlacementRegisterEvent e, EntityType<T> type, SpawnPlacements.SpawnPredicate<T> predicate) {
        e.register(type, SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, predicate, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void registerDarkAirSpawn(SpawnPlacementRegisterEvent e, EntityType<? extends Mob> type) {
        e.register(type, SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, SpawnEvents::checkDarknessSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void registerPassiveAirSpawn(SpawnPlacementRegisterEvent e, EntityType<? extends Mob> type) {
        e.register(type, SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, SpawnEvents::always, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void registerMobSpawn(SpawnPlacementRegisterEvent e, EntityType<? extends Mob> type) {
        e.register(type, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void registerMonsterSpawn(SpawnPlacementRegisterEvent e, EntityType<? extends Monster> type) {
        e.register(type, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219019_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void registerDarkSpawn(SpawnPlacementRegisterEvent e, EntityType<? extends Monster> type) {
        e.register(type, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void registerSurfaceSpawn(SpawnPlacementRegisterEvent e, EntityType<? extends Mob> type) {
        e.register(type, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnEvents::onSurface, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void registerSurfaceMonsterSpawn(SpawnPlacementRegisterEvent e, EntityType<? extends Monster> type) {
        e.register(type, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnEvents::monsterOnSurface, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void registerAgileSurfaceMonsterSpawn(SpawnPlacementRegisterEvent e, EntityType<? extends Monster> type) {
        e.register(type, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, SpawnEvents::monsterOnSurface, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static boolean always(EntityType<? extends Entity> e, ServerLevelAccessor l, MobSpawnType t, BlockPos p, RandomSource r) {
        Difficulty difficulty = l.m_46791_();
        EnumMap<Difficulty, Integer> cancellationChances = new EnumMap<Difficulty, Integer>(Map.of(Difficulty.EASY, 6, Difficulty.NORMAL, 4, Difficulty.HARD, 2));
        int cancelChance = cancellationChances.getOrDefault(difficulty, 0);
        return r.m_188503_(10) >= cancelChance;
    }

    public static boolean checkDarknessSpawnRules(EntityType<? extends Mob> e, ServerLevelAccessor s, MobSpawnType t, BlockPos p, RandomSource r) {
        Difficulty difficulty = s.m_46791_();
        EnumMap<Difficulty, Integer> cancellationChances = new EnumMap<Difficulty, Integer>(Map.of(Difficulty.EASY, 6, Difficulty.NORMAL, 4, Difficulty.HARD, 2));
        int cancelChance = cancellationChances.getOrDefault(difficulty, 0);
        return r.m_188503_(10) >= cancelChance && Monster.m_219009_((ServerLevelAccessor)s, (BlockPos)p, (RandomSource)r);
    }

    public static boolean onSurface(EntityType<? extends Mob> e, ServerLevelAccessor s, MobSpawnType t, BlockPos p, RandomSource r) {
        Difficulty difficulty = s.m_46791_();
        EnumMap<Difficulty, Integer> cancellationChances = new EnumMap<Difficulty, Integer>(Map.of(Difficulty.EASY, 6, Difficulty.NORMAL, 4, Difficulty.HARD, 2));
        int cancelChance = cancellationChances.getOrDefault(difficulty, 0);
        return r.m_188503_(10) >= cancelChance && Mob.m_217057_(e, (LevelAccessor)s, (MobSpawnType)t, (BlockPos)p, (RandomSource)r) && s.m_45527_(p);
    }

    public static boolean monsterOnSurface(EntityType<? extends Monster> e, ServerLevelAccessor s, MobSpawnType t, BlockPos p, RandomSource r) {
        Difficulty difficulty = s.m_46791_();
        EnumMap<Difficulty, Integer> cancellationChances = new EnumMap<Difficulty, Integer>(Map.of(Difficulty.EASY, 6, Difficulty.NORMAL, 4, Difficulty.HARD, 2));
        int cancelChance = cancellationChances.getOrDefault(difficulty, 0);
        return r.m_188503_(10) >= cancelChance && Monster.m_219019_(e, (LevelAccessor)s, (MobSpawnType)t, (BlockPos)p, (RandomSource)r) && s.m_45527_(p);
    }

    @SubscribeEvent
    public void addVanillaMobGoals(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof Turtle) {
            Turtle turtle = (Turtle)event.getEntity();
            turtle.f_21345_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)turtle, EntityAequorea.class, false));
            turtle.f_21345_.m_25352_(3, (Goal)new TurtleEatAequorea(turtle, turtle.m_21133_(Attributes.f_22277_), false));
        }
    }

    private static /* synthetic */ SoulTrapCount lambda$spawnPlacementCheck$0() {
        return new SoulTrapCount();
    }
}

