/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import divinerpg.capability.Arcana;
import divinerpg.capability.DimensionalInventory;
import divinerpg.capability.DimensionalInventoryProvider;
import divinerpg.capability.Reputation;
import divinerpg.capability.ReputationProvider;
import divinerpg.config.CommonConfig;
import divinerpg.events.ArmorAbilitiesEvent;
import divinerpg.registries.LevelRegistry;
import divinerpg.util.DivineRPGPacketHandler;
import divinerpg.util.packets.PacketArcanaBar;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class VetheaInventorySwapEvent {
    public static final String OVERWORLD_INVENTORY = "drpg_regular_inventory";
    public static final String VETHEA_INVENTORY = "drpg_dream_inventory";

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        original.reviveCaps();
        original.getCapability(ReputationProvider.REPUTATION).ifPresent(origin -> clone.getCapability(ReputationProvider.REPUTATION).ifPresent(target -> origin.transferTo((Reputation)target)));
        original.getCapability(DimensionalInventoryProvider.DIMENIONAL_INVENTORY).ifPresent(origin -> clone.getCapability(DimensionalInventoryProvider.DIMENIONAL_INVENTORY).ifPresent(target -> origin.transferTo((DimensionalInventory)target)));
        original.invalidateCaps();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (!event.isCanceled() && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (!((Boolean)CommonConfig.saferVetheanInventory.get()).booleanValue()) {
                DimensionalInventory d = (DimensionalInventory)player.getCapability(DimensionalInventoryProvider.DIMENIONAL_INVENTORY).orElse(null);
                if (player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
                    if (player.m_9236_().m_46472_().equals(LevelRegistry.VETHEA)) {
                        d.saveInventory(player, VETHEA_INVENTORY);
                    } else {
                        d.saveInventory(player, OVERWORLD_INVENTORY);
                    }
                } else if (player.m_9236_().m_46472_().equals(LevelRegistry.VETHEA)) {
                    d.clearInventory(VETHEA_INVENTORY);
                } else {
                    d.clearInventory(OVERWORLD_INVENTORY);
                }
            }
            ArmorAbilitiesEvent.updateAbilities((LivingEntity)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.isCanceled()) {
            Player player = event.getEntity();
            DivineRPGPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PacketArcanaBar(new Arcana()));
            if (!((Boolean)CommonConfig.saferVetheanInventory.get()).booleanValue()) {
                DimensionalInventory d = (DimensionalInventory)player.getCapability(DimensionalInventoryProvider.DIMENIONAL_INVENTORY).orElse(null);
                if (player.m_9236_().m_46472_().equals(LevelRegistry.VETHEA)) {
                    d.loadInventory(player, VETHEA_INVENTORY);
                } else {
                    d.loadInventory(player, OVERWORLD_INVENTORY);
                }
                player.f_36095_.m_38946_();
            }
            ArmorAbilitiesEvent.updateAbilities((LivingEntity)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onDimensionChange(EntityTravelToDimensionEvent event) {
        Entity entity;
        if (!event.isCanceled() && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (!((Boolean)CommonConfig.saferVetheanInventory.get()).booleanValue()) {
                boolean from = player.m_9236_().m_46472_().equals(LevelRegistry.VETHEA);
                boolean to = event.getDimension().equals(LevelRegistry.VETHEA);
                DimensionalInventory d = (DimensionalInventory)player.getCapability(DimensionalInventoryProvider.DIMENIONAL_INVENTORY).orElse(null);
                if (from ^ to) {
                    if (from) {
                        d.saveInventory(player, VETHEA_INVENTORY);
                        d.loadInventory(player, OVERWORLD_INVENTORY);
                    } else {
                        d.saveInventory(player, OVERWORLD_INVENTORY);
                        d.loadInventory(player, VETHEA_INVENTORY);
                    }
                    player.m_21219_();
                } else if (from && to) {
                    d.saveInventory(player, VETHEA_INVENTORY);
                } else {
                    d.saveInventory(player, OVERWORLD_INVENTORY);
                }
            }
            ArmorAbilitiesEvent.updateAbilities((LivingEntity)player);
        }
    }
}

