/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events.enchant;

import divinerpg.blocks.base.BlockModMobCage;
import divinerpg.registries.EnchantmentRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RiveHandler {
    @SubscribeEvent
    public void handleWorldBreak(BlockEvent.BreakEvent event) {
        Direction facing;
        Level world = (Level)event.getLevel();
        Player player = event.getPlayer();
        ItemStack itemStack = player.m_21205_();
        BlockState blockState = world.m_8055_(event.getPos());
        int level = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)EnchantmentRegistry.RIVE.get()), (LivingEntity)player);
        float pitch = player.m_146909_();
        Direction direction = pitch > 45.0f ? Direction.DOWN : (facing = pitch < -45.0f ? Direction.UP : player.m_6350_());
        if (world.f_46443_) {
            return;
        }
        if (player.m_6144_()) {
            return;
        }
        if (!(itemStack.m_41720_() instanceof DiggerItem)) {
            return;
        }
        if (!itemStack.m_41720_().isCorrectToolForDrops(itemStack, blockState)) {
            return;
        }
        if (level < 1) {
            return;
        }
        int[] dimensions = this.getSizeByDirection(facing, level);
        int totalBlocksBroken = 0;
        for (int x = dimensions[0]; x <= dimensions[3]; ++x) {
            for (int y = dimensions[1]; y <= dimensions[4]; ++y) {
                for (int z = dimensions[2]; z <= dimensions[5]; ++z) {
                    BlockPos pos = event.getPos().m_7918_(x, y, z);
                    if (!this.tryToBreakBlock(world, player, pos, world.m_8055_(pos), itemStack)) continue;
                    ++totalBlocksBroken;
                }
            }
        }
        if (blockState.m_60800_((BlockGetter)world, event.getPos()) != 0.0f && totalBlocksBroken > 0) {
            itemStack.m_41622_(totalBlocksBroken - 1, (LivingEntity)player, ctx -> ctx.m_21166_(EquipmentSlot.MAINHAND));
        }
    }

    private boolean tryToBreakBlock(Level world, Player player, BlockPos pos, BlockState blockState, ItemStack tool) {
        Block block = blockState.m_60734_();
        if (!tool.m_41720_().isCorrectToolForDrops(tool, blockState)) {
            return false;
        }
        if (!(block instanceof BlockModMobCage) && blockState.m_155947_()) {
            return false;
        }
        if (block.m_155943_() < 0.0f) {
            return false;
        }
        if (block instanceof BlockModMobCage) {
            BlockModMobCage mobCage = (BlockModMobCage)block;
            mobCage.onDestroyedByPlayer(blockState, world, pos, player, true, world.m_6425_(pos));
        }
        if (block.canHarvestBlock(blockState, (BlockGetter)world, pos, player) && world instanceof ServerLevel) {
            if (!player.m_7500_()) {
                block.m_6240_(world, player, pos, blockState, null, tool);
                block.m_49805_((ServerLevel)world, pos, block.getExpDrop(blockState, (LevelReader)world, world.f_46441_, pos, EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44987_, (LivingEntity)player), EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44985_, (LivingEntity)player)));
            }
            world.m_46961_(pos, false);
            return true;
        }
        return false;
    }

    private int[] getSizeByDirection(Direction facing, int level) {
        int[] nArray;
        int depth = level - 1;
        switch (facing) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NORTH: {
                int[] nArray2 = new int[6];
                nArray2[0] = -1;
                nArray2[1] = -1;
                nArray2[2] = -depth;
                nArray2[3] = 1;
                nArray2[4] = 1;
                nArray = nArray2;
                nArray2[5] = 0;
                break;
            }
            case EAST: {
                int[] nArray3 = new int[6];
                nArray3[0] = 0;
                nArray3[1] = -1;
                nArray3[2] = -1;
                nArray3[3] = depth;
                nArray3[4] = 1;
                nArray = nArray3;
                nArray3[5] = 1;
                break;
            }
            case WEST: {
                int[] nArray4 = new int[6];
                nArray4[0] = -depth;
                nArray4[1] = -1;
                nArray4[2] = -1;
                nArray4[3] = 0;
                nArray4[4] = 1;
                nArray = nArray4;
                nArray4[5] = 1;
                break;
            }
            case SOUTH: {
                int[] nArray5 = new int[6];
                nArray5[0] = -1;
                nArray5[1] = -1;
                nArray5[2] = 0;
                nArray5[3] = 1;
                nArray5[4] = 1;
                nArray = nArray5;
                nArray5[5] = depth;
                break;
            }
            case UP: {
                int[] nArray6 = new int[6];
                nArray6[0] = -1;
                nArray6[1] = 0;
                nArray6[2] = -1;
                nArray6[3] = 1;
                nArray6[4] = depth;
                nArray = nArray6;
                nArray6[5] = 1;
                break;
            }
            case DOWN: {
                int[] nArray7 = new int[6];
                nArray7[0] = -1;
                nArray7[1] = -depth;
                nArray7[2] = -1;
                nArray7[3] = 1;
                nArray7[4] = 0;
                nArray = nArray7;
                nArray7[5] = 1;
            }
        }
        return nArray;
    }
}

