/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.arcana;

import divinerpg.capability.ArcanaProvider;
import divinerpg.entities.projectile.EntityMerikMissile;
import divinerpg.items.base.ItemMod;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemMeriksMissile
extends ItemMod {
    public static final int MAX_USE_DURATION = 72000;

    public ItemMeriksMissile() {
        super(new Item.Properties().m_41503_(1315));
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!player.f_36077_.f_35938_) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity livingEntity, int timeLeft) {
        if (stack.m_41720_() == ItemRegistry.meriks_missile.get() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            float charge = (float)(72000 - timeLeft) / 20.0f;
            if (charge > 1.0f) {
                charge = 1.0f;
            }
            float arcanaPoints = 50.0f * charge;
            float finalCharge = charge;
            player.getCapability(ArcanaProvider.ARCANA).ifPresent(arcana -> {
                if (arcana.getAmount(world.m_5776_()) >= arcanaPoints) {
                    if ((double)finalCharge < 0.2) {
                        return;
                    }
                    float damage = Mth.m_14036_((float)(finalCharge * 25.0f), (float)2.0f, (float)8.0f);
                    world.m_5594_(null, player.m_20183_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    EntityMerikMissile bullet = new EntityMerikMissile((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.MERIKS_MISSILE.get()), world, (LivingEntity)player, damage);
                    bullet.m_6027_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
                    bullet.m_37251_((Entity)player, player.f_19858_, player.f_19857_, 0.0f, 3.0f, 1.0f);
                    world.m_7967_((Entity)bullet);
                    arcana.modifyAmount((LivingEntity)player, -arcanaPoints);
                }
            });
        }
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.rangedDam("2-8"));
        tooltip.add(LocalizeUtils.explosiveShots());
        tooltip.add(LocalizeUtils.homingShots());
        tooltip.add(LocalizeUtils.arcanaConsumed("10-50"));
    }
}

