/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.capability.ArcanaProvider;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemMod
extends Item {
    public int arcanaConsumedUse;
    public int cooldown;

    public ItemMod() {
        super(new Item.Properties());
    }

    public ItemMod(Item.Properties properties) {
        super(properties);
    }

    public ItemMod setArcanaUseConsumption(int amount) {
        this.arcanaConsumedUse = amount;
        return this;
    }

    public ItemMod setArcanaUseCooldown(int amount) {
        this.cooldown = amount;
        return this;
    }

    protected InteractionResultHolder<ItemStack> arcanicUse(Level level, Player player, InteractionHand hand) {
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return player.getCapability(ArcanaProvider.ARCANA).map(arcana -> {
            if (this.arcanaConsumedUse != 0 && arcana.getAmount(level.m_5776_()) >= (float)this.arcanaConsumedUse) {
                arcana.modifyAmount((LivingEntity)player, -this.arcanaConsumedUse);
                player.m_36335_().m_41524_((Item)this, this.cooldown);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return this.arcanicUse(level, player, hand);
            }
            return super.m_7203_(level, player, hand);
        }).orElse(super.m_7203_(level, player, hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (this.m_5524_().contains("torridite")) {
            tooltip.add(LocalizeUtils.i18n("torridite", new Object[0]));
        }
        if (this.arcanaConsumedUse > 0) {
            tooltip.add(LocalizeUtils.arcanaConsumed(this.arcanaConsumedUse));
        }
    }
}

