/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.entities.projectile.EntityDivineArrow;
import divinerpg.enums.ArrowType;
import divinerpg.registries.EntityRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemModBow
extends BowItem {
    public static final int DEFAULT_MAX_USE_DURATION = 72000;
    protected ArrowType arrowType;
    protected int maxUseDuration;
    protected Item arrowSupplier;

    public ItemModBow(ArrowType arrowType, int uses, int maxUseDuration) {
        super(new Item.Properties().m_41503_(uses));
        this.arrowType = arrowType;
        this.arrowSupplier = arrowType.getArrowSupplier();
        this.maxUseDuration = maxUseDuration;
    }

    public ItemModBow(Rarity rarity, ArrowType arrowType, int uses, int maxUseDuration) {
        super(new Item.Properties().m_41503_(uses).m_41497_(rarity));
        this.arrowType = arrowType;
        this.arrowSupplier = arrowType.getArrowSupplier();
        this.maxUseDuration = maxUseDuration;
    }

    public ItemModBow(ArrowType arrowType, int uses) {
        this(arrowType, uses, 72000);
    }

    public ItemModBow(Rarity rarity, ArrowType arrowType, int uses) {
        this(rarity, arrowType, uses, 72000);
    }

    public ItemModBow(ArrowType arrowType, int maxUseDuration, Item.Properties properties) {
        super(properties);
        this.arrowType = arrowType;
        this.arrowSupplier = arrowType.getArrowSupplier();
        this.maxUseDuration = maxUseDuration;
    }

    public int m_8105_(ItemStack stack) {
        return this.maxUseDuration;
    }

    public boolean needsArrow(ItemStack stack) {
        if (this.arrowSupplier != null) {
            return stack.getEnchantmentLevel(Enchantments.f_44952_) <= 0;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack;
        boolean hasAmmo = !this.needsArrow(stack = player.m_21120_(hand)) || !this.findAmmunition(player).m_41619_();
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)stack, (Level)world, (Player)player, (InteractionHand)hand, (boolean)hasAmmo);
        if (ret != null) {
            return ret;
        }
        if (!player.m_7500_() && !hasAmmo) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        RandomSource random = worldIn.m_213780_();
        if (entityLiving instanceof Player) {
            float f;
            Player player = (Player)entityLiving;
            boolean infiniteAmmo = !this.needsArrow(stack) || player.m_7500_() || EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44952_, (LivingEntity)entityLiving) > 0;
            ItemStack itemstack = this.findAmmunition(player);
            int charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)worldIn, (Player)player, (int)(this.maxUseDuration - timeLeft), (!itemstack.m_41619_() || infiniteAmmo ? 1 : 0) != 0);
            if (charge < 0) {
                return;
            }
            if ((!itemstack.m_41619_() || infiniteAmmo) && (double)(f = this.getScaledArrowVelocity(charge)) >= 0.1) {
                if (!worldIn.f_46443_) {
                    int k;
                    int j;
                    EntityDivineArrow arrow = new EntityDivineArrow((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.ARROW_SHOT.get()), worldIn, this.arrowType, (LivingEntity)player);
                    arrow.m_37251_((Entity)player, player.f_19858_, player.f_19857_, 0.0f, f * 3.0f, 1.0f);
                    if (f == 1.0f) {
                        arrow.m_36762_(true);
                    }
                    if ((j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack)) > 0) {
                        arrow.m_36781_(arrow.m_36789_() + (double)j * 0.5 + 0.5);
                    }
                    if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
                        arrow.m_36735_(k);
                    }
                    if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                        arrow.m_20254_(100);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41622_(1, (LivingEntity)player, ctx -> ctx.m_21190_(player.m_7655_()));
                    }
                    if (infiniteAmmo) {
                        arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    worldIn.m_7967_((Entity)arrow);
                }
                worldIn.m_6263_(null, player.f_19854_, player.f_19855_, player.f_19856_, SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.4f + 1.2f) + f * 0.5f);
                if (!infiniteAmmo) {
                    itemstack.m_41774_(1);
                    if (itemstack.m_41619_()) {
                        player.f_36093_.m_36057_(itemstack);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public float getScaledArrowVelocity(int charge) {
        float timeRatio = 72000.0f / (float)this.maxUseDuration;
        float f = (float)charge / 20.0f * timeRatio;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    protected boolean isArrow(ItemStack stack) {
        return stack.m_41720_() == this.arrowSupplier;
    }

    private ItemStack findAmmunition(Player player) {
        if (this.isArrow(player.m_21120_(InteractionHand.OFF_HAND))) {
            return player.m_21120_(InteractionHand.OFF_HAND);
        }
        if (this.isArrow(player.m_21120_(InteractionHand.MAIN_HAND))) {
            return player.m_21120_(InteractionHand.MAIN_HAND);
        }
        for (int i = 0; i < player.f_36093_.m_6643_(); ++i) {
            ItemStack stack = player.f_36093_.m_8020_(i);
            if (!this.isArrow(stack)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8120_(ItemStack stack) {
        return this.m_41465_();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (this.arrowType.getArrowSpecial() == ArrowType.ArrowSpecial.FLAME && enchantment == Enchantments.f_44990_ || !this.needsArrow(stack) && enchantment == Enchantments.f_44952_) {
            return false;
        }
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.rangedDam((int)this.arrowType.getBaseDamage() + "-" + (int)(this.arrowType.getBaseDamage() * 4.0f + 3.0f)));
        int speed = 72000 / this.m_8105_(stack);
        if (speed > 1) {
            tooltip.add(LocalizeUtils.i18n(ChatFormatting.DARK_GREEN, "bow_speed.faster", String.format("%s", speed)));
        }
        if (speed < 1) {
            tooltip.add(LocalizeUtils.i18n(ChatFormatting.RED, "bow_speed.slower", String.format("%s", 1 / speed)));
        }
        if (this.arrowType.getArrowSpecial() == ArrowType.ArrowSpecial.POISON) {
            tooltip.add(LocalizeUtils.poison(this.arrowType.effectSec));
        }
        if (this.arrowType.getArrowSpecial() == ArrowType.ArrowSpecial.FLAME) {
            tooltip.add(LocalizeUtils.burn(this.arrowType.effectSec));
        }
        if (this.arrowType.getArrowSpecial() == ArrowType.ArrowSpecial.EXPLODE) {
            tooltip.add(LocalizeUtils.explosiveShots());
        }
        tooltip.add(this.needsArrow(stack) ? LocalizeUtils.ammo(this.arrowSupplier) : LocalizeUtils.infiniteAmmo());
        if (!this.m_41465_()) {
            stack.m_41784_().m_128379_("Unbreakable", true);
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

