/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.capability.ArcanaProvider;
import divinerpg.enums.ToolStats;
import divinerpg.registries.EnchantmentRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemModSword
extends SwordItem {
    public int arcanaConsumedUse;
    public int arcanaConsumedAttack;
    public int cooldown;
    public ToolStats sword;

    public ItemModSword(Rarity rarity, Tier tier) {
        super(tier, 1, tier.m_6624_(), new Item.Properties().m_41497_(rarity));
        this.sword = (ToolStats)tier;
    }

    public ItemModSword(Tier tier) {
        super(tier, 1, tier.m_6624_(), new Item.Properties());
        this.sword = (ToolStats)tier;
    }

    public ItemModSword(Tier tier, Item.Properties properties) {
        super(tier, 1, tier.m_6624_(), properties);
        this.sword = (ToolStats)tier;
    }

    public ItemModSword setAttackArcanaConsumption(int amount) {
        this.arcanaConsumedAttack = amount;
        return this;
    }

    public boolean onLeftClickEntity(ItemStack itemstack, Player player, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.sword.getSwordSpecial() == ToolStats.SwordSpecial.SLOW) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, this.sword.effectSec * 20, this.sword.effectPower));
            }
            if (this.sword.getSwordSpecial() == ToolStats.SwordSpecial.POISON) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, this.sword.effectSec * 20, this.sword.effectPower));
            }
            if (this.sword.getSwordSpecial() == ToolStats.SwordSpecial.FLAME) {
                livingEntity.m_20254_(this.sword.effectSec);
            }
        }
        return false;
    }

    public void arcanicAttack(ItemStack stack, Player player, Entity entity) {
    }

    protected InteractionResultHolder<ItemStack> arcanicUse(Level level, Player player, InteractionHand hand) {
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return player.getCapability(ArcanaProvider.ARCANA).map(arcana -> {
            if (this.arcanaConsumedUse != 0 && arcana.getAmount(level.m_5776_()) >= (float)this.arcanaConsumedUse) {
                arcana.modifyAmount((LivingEntity)player, -this.arcanaConsumedUse);
                player.m_36335_().m_41524_((Item)this, this.cooldown);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return this.arcanicUse(level, player, hand);
            }
            return super.m_7203_(level, player, hand);
        }).orElse(super.m_7203_(level, player, hand));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (this.sword.getSwordSpecial() == ToolStats.SwordSpecial.FLAME && enchantment == Enchantments.f_44981_ || this.sword.getSwordSpecial() == ToolStats.SwordSpecial.SLOW && enchantment == EnchantmentRegistry.BRAIN_FREEZE.get()) {
            return false;
        }
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (this.sword.getSwordSpecial() == ToolStats.SwordSpecial.ARCANA_DAMAGE) {
            tooltip.add(LocalizeUtils.weakenedWithoutArcana());
        }
        if (this.sword.getSwordSpecial() == ToolStats.SwordSpecial.FLAME) {
            tooltip.add(LocalizeUtils.burn(this.sword.effectSec));
        }
        if (this.sword.getSwordSpecial() == ToolStats.SwordSpecial.LIGHTNING) {
            tooltip.add(LocalizeUtils.lightningShots());
        }
        if (this.sword.getSwordSpecial() == ToolStats.SwordSpecial.POISON) {
            tooltip.add(LocalizeUtils.poison(this.sword.effectSec));
        }
        if (this.sword.getSwordSpecial() == ToolStats.SwordSpecial.SLOW) {
            tooltip.add(LocalizeUtils.slow(this.sword.effectSec));
        }
        if (this.sword.getSwordSpecial() == ToolStats.SwordSpecial.SPEED) {
            tooltip.add(LocalizeUtils.i18n("shadow_saber", new Object[0]));
        }
        if (this.arcanaConsumedUse > 0) {
            tooltip.add(LocalizeUtils.arcanaConsumed(this.arcanaConsumedUse));
        }
        if (this.arcanaConsumedAttack > 0) {
            tooltip.add(LocalizeUtils.arcanaConsumed(this.arcanaConsumedAttack));
        }
        if (!this.m_41465_()) {
            stack.m_41784_().m_128379_("Unbreakable", true);
        }
    }
}

