/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ItemShickaxe
extends DiggerItem {
    protected final Tier tier;
    private static final Set<ToolAction> TOOL_ACTIONS = Stream.of(ToolActions.AXE_DIG, ToolActions.AXE_SCRAPE, ToolActions.AXE_STRIP, ToolActions.AXE_WAX_OFF, ToolActions.PICKAXE_DIG, ToolActions.SHOVEL_DIG, ToolActions.SHOVEL_FLATTEN, ToolActions.HOE_DIG, ToolActions.HOE_TILL).collect(Collectors.toCollection(Sets::newIdentityHashSet));

    public ItemShickaxe(Rarity rarity, Tier tier) {
        super(1.0f, -2.4f, tier, BlockTags.create((ResourceLocation)new ResourceLocation("divinerpg", "shickaxe_effective")), new Item.Properties().m_41503_(tier.m_6609_()).m_41497_(rarity));
        this.tier = tier;
    }

    public ItemShickaxe(Tier tier) {
        super(1.0f, -2.4f, tier, BlockTags.create((ResourceLocation)new ResourceLocation("divinerpg", "shickaxe_effective")), new Item.Properties().m_41503_(tier.m_6609_()));
        this.tier = tier;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return TOOL_ACTIONS.contains(toolAction);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockState state = level.m_8055_(blockpos);
        InteractionHand hand = context.m_43724_();
        Player player = context.m_43723_();
        BlockState toolModifiedState = state.getToolModifiedState(context, ToolActions.HOE_TILL, false);
        Pair pair = toolModifiedState == null ? null : Pair.of(ctx -> true, (Object)HoeItem.m_150858_((BlockState)toolModifiedState));
        Optional<BlockState> optional = Optional.ofNullable(state.getToolModifiedState(context, ToolActions.AXE_STRIP, false));
        Optional optional1 = optional.isPresent() ? Optional.empty() : Optional.ofNullable(state.getToolModifiedState(context, ToolActions.AXE_SCRAPE, false));
        Optional optional2 = optional.isPresent() || optional1.isPresent() ? Optional.empty() : Optional.ofNullable(state.getToolModifiedState(context, ToolActions.AXE_WAX_OFF, false));
        ItemStack stack = context.m_43722_();
        Optional<Object> optional3 = Optional.empty();
        if (optional.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            optional3 = optional;
        } else if (optional1.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3005, blockpos, 0);
            optional3 = optional1;
        } else if (optional2.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3004, blockpos, 0);
            optional3 = optional2;
        }
        if (optional3.isPresent()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, stack);
            }
            level.m_7731_(blockpos, (BlockState)optional3.get(), 11);
            level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)((BlockState)optional3.get())));
            stack.m_41622_(1, (LivingEntity)player, ctx -> ctx.m_21190_(hand));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (pair != null && !player.m_6144_()) {
            Predicate predicate = (Predicate)pair.getFirst();
            Consumer consumer = (Consumer)pair.getSecond();
            if (predicate.test(context)) {
                level.m_5594_(player, blockpos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!level.f_46443_) {
                    consumer.accept(context);
                    context.m_43722_().m_41622_(1, (LivingEntity)player, ctx -> ctx.m_21190_(hand));
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        BlockState blockstate1 = state.getToolModifiedState(context, ToolActions.SHOVEL_FLATTEN, false);
        BlockState blockstate2 = null;
        if (context.m_43719_() != Direction.DOWN) {
            if (blockstate1 != null && level.m_46859_(blockpos.m_7494_()) && player.m_6144_()) {
                level.m_5594_(player, blockpos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
                blockstate2 = blockstate1;
            } else if (state.m_60734_() instanceof CampfireBlock && ((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                if (!level.f_46443_) {
                    level.m_5898_(null, 1009, blockpos, 0);
                }
                CampfireBlock.m_152749_((Entity)context.m_43723_(), (LevelAccessor)level, (BlockPos)blockpos, (BlockState)state);
                blockstate2 = (BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.FALSE);
            }
            if (blockstate2 != null) {
                if (!level.f_46443_) {
                    level.m_7731_(blockpos, blockstate2, 11);
                    level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockstate2));
                    if (player != null) {
                        context.m_43722_().m_41622_(1, (LivingEntity)player, ctx -> ctx.m_21190_(hand));
                    }
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (state.m_204336_(BlockTags.f_144280_)) {
            return this.f_40980_;
        }
        if (state.m_204336_(BlockTags.f_144282_)) {
            return this.f_40980_;
        }
        if (state.m_204336_(BlockTags.f_144283_)) {
            return this.f_40980_;
        }
        if (state.m_204336_(BlockTags.f_144281_)) {
            return this.f_40980_;
        }
        return super.m_8102_(stack, state);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (state.m_204336_(BlockTags.f_144282_)) {
            return TierSortingRegistry.isCorrectTierForDrops((Tier)this.tier, (BlockState)state);
        }
        if (state.m_204336_(BlockTags.f_144280_)) {
            return TierSortingRegistry.isCorrectTierForDrops((Tier)this.tier, (BlockState)state);
        }
        if (state.m_204336_(BlockTags.f_144283_)) {
            return TierSortingRegistry.isCorrectTierForDrops((Tier)this.tier, (BlockState)state);
        }
        if (state.m_204336_(BlockTags.f_144281_)) {
            return TierSortingRegistry.isCorrectTierForDrops((Tier)this.tier, (BlockState)state);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.efficiency((int)this.f_40980_));
        tooltip.add(LocalizeUtils.harvestLevel(this.m_43314_().m_6604_()));
        if (!this.m_41465_()) {
            stack.m_41784_().m_128379_("Unbreakable", true);
        }
    }
}

