/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.twilight;

import divinerpg.blocks.base.BlockModPortal;
import divinerpg.items.base.ItemMod;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.LevelRegistry;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;

public class ItemTwilightClock
extends ItemMod {
    private final Set<Block> possibleBlocks = new HashSet<Block>(){
        private static final long serialVersionUID = 1L;
        {
            this.add((Block)BlockRegistry.divineRock.get());
            this.add((Block)BlockRegistry.edenBlock.get());
            this.add((Block)BlockRegistry.wildwoodBlock.get());
            this.add((Block)BlockRegistry.apalachiaBlock.get());
            this.add((Block)BlockRegistry.skythernBlock.get());
        }
    };

    public ItemTwilightClock() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        InteractionHand hand = context.m_43724_();
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        ItemStack stack = player.m_21120_(hand);
        RandomSource random = level.f_46441_;
        if (!player.m_36204_(pos, facing, stack)) {
            return InteractionResult.FAIL;
        }
        if (facing != Direction.UP) {
            return InteractionResult.FAIL;
        }
        for (Direction direction : Direction.Plane.VERTICAL) {
            BlockModPortal portalBlock = null;
            BlockPos framePos = pos.m_121945_(direction);
            if (level.m_8055_(framePos.m_7495_()) == ((Block)BlockRegistry.divineRock.get()).m_49966_() && (level.m_46472_().equals(LevelRegistry.EDEN) || level.m_46472_().equals((Object)Level.f_46428_))) {
                portalBlock = (BlockModPortal)((Object)BlockRegistry.edenPortal.get());
            } else if (level.m_8055_(framePos.m_7495_()) == ((Block)BlockRegistry.edenBlock.get()).m_49966_() && (level.m_46472_().equals(LevelRegistry.WILDWOOD) || level.m_46472_().equals((Object)Level.f_46428_))) {
                portalBlock = (BlockModPortal)((Object)BlockRegistry.wildwoodPortal.get());
            } else if (level.m_8055_(framePos.m_7495_()) == ((Block)BlockRegistry.wildwoodBlock.get()).m_49966_() && (level.m_46472_().equals(LevelRegistry.APALACHIA) || level.m_46472_().equals((Object)Level.f_46428_))) {
                portalBlock = (BlockModPortal)((Object)BlockRegistry.apalachiaPortal.get());
            } else if (level.m_8055_(framePos.m_7495_()) == ((Block)BlockRegistry.apalachiaBlock.get()).m_49966_() && (level.m_46472_().equals(LevelRegistry.SKYTHERN) || level.m_46472_().equals((Object)Level.f_46428_))) {
                portalBlock = (BlockModPortal)((Object)BlockRegistry.skythernPortal.get());
            } else if (level.m_8055_(framePos.m_7495_()) == ((Block)BlockRegistry.skythernBlock.get()).m_49966_() && (level.m_46472_().equals(LevelRegistry.MORTUM) || level.m_46472_().equals((Object)Level.f_46428_))) {
                portalBlock = (BlockModPortal)((Object)BlockRegistry.mortumPortal.get());
            } else if (BaseFireBlock.m_49255_((Level)level, (BlockPos)pos.m_121945_(facing), (Direction)context.m_8125_()) && this.possibleBlocks.contains(level.m_8055_(pos).m_60734_())) {
                level.m_7731_(pos.m_7494_(), ((Block)BlockRegistry.blueFire.get()).m_49966_(), 0);
                level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, random.m_188501_() * 0.4f + 0.8f);
                return InteractionResult.SUCCESS;
            }
            if (portalBlock == null || !portalBlock.makePortal((LevelAccessor)level, framePos)) continue;
            level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, random.m_188501_() * 0.4f + 0.8f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

