/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.registries;

import com.mojang.serialization.Codec;
import divinerpg.world.structure.HighestCeilingType;
import divinerpg.world.structure.HighestGroundType;
import divinerpg.world.structure.LowestCeilingType;
import divinerpg.world.structure.LowestGroundType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class StructureRegistry {
    public static final StructurePlaceSettings defaultSettings = new StructurePlaceSettings().m_74392_(false).m_74405_(true).m_163782_(true);
    public static final DeferredRegister<StructureType<?>> STRUCTURE_TYPE = DeferredRegister.create((ResourceKey)Registries.f_256938_, (String)"divinerpg");
    public static final RegistryObject<StructureType<?>> HIGHEST_GROUND = STRUCTURE_TYPE.register("highest_ground", () -> StructureRegistry.codecConv(HighestGroundType.CODEC));
    public static final RegistryObject<StructureType<?>> LOWEST_GROUND = STRUCTURE_TYPE.register("lowest_ground", () -> StructureRegistry.codecConv(LowestGroundType.CODEC));
    public static final RegistryObject<StructureType<?>> HIGHEST_CEILING = STRUCTURE_TYPE.register("highest_ceiling", () -> StructureRegistry.codecConv(HighestCeilingType.CODEC));
    public static final RegistryObject<StructureType<?>> LOWEST_CEILING = STRUCTURE_TYPE.register("lowest_ceiling", () -> StructureRegistry.codecConv(LowestCeilingType.CODEC));

    private static <S extends Structure> StructureType<S> codecConv(Codec<S> codec) {
        return () -> codec;
    }

    public static void placeStructure(StructureTemplate structure, WorldGenLevel level, RandomSource random, BlockPos pos) {
        structure.m_230328_((ServerLevelAccessor)level, pos, pos, defaultSettings, random, 2);
    }

    public static void placeStructure(StructureTemplate structure, WorldGenLevel level, RandomSource random, BlockPos pos, Rotation rotation) {
        structure.m_230328_((ServerLevelAccessor)level, pos, pos, defaultSettings.m_74374_().m_74379_(rotation), random, 2);
    }
}

