/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;

public class PortalShape {
    private static final BlockBehaviour.StatePredicate FRAME = (p_242966_0_, p_242966_1_, p_242966_2_) -> p_242966_0_.isPortalFrame(p_242966_1_, p_242966_2_);
    private static Block portal;
    private static Block frame;
    private final LevelAccessor level;
    private final Direction.Axis axis;
    private final Direction rightDir;
    private int numPortalBlocks;
    @Nullable
    private BlockPos bottomLeft;
    private int height;
    private final int width;

    public PortalShape(LevelAccessor world, BlockPos pos, Direction.Axis axis, Block portal, Block frame) {
        this.level = world;
        this.axis = axis;
        this.rightDir = axis == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
        this.bottomLeft = this.calculateBottomLeft(pos);
        if (this.bottomLeft == null) {
            this.bottomLeft = pos;
            this.width = 1;
            this.height = 1;
        } else {
            this.width = this.calculateWidth();
            if (this.width > 0) {
                this.height = this.calculateHeight();
            }
        }
        PortalShape.portal = portal;
        PortalShape.frame = frame;
    }

    private static boolean isEmpty(BlockState p_196900_0_) {
        return p_196900_0_.m_60795_() || p_196900_0_.m_204336_(BlockTags.f_13076_) || p_196900_0_.m_60713_(portal);
    }

    public static Vec3 getRelativePosition(BlockUtil.FoundRectangle p_242973_0_, Direction.Axis p_242973_1_, Vec3 p_242973_2_, EntityDimensions p_242973_3_) {
        double d4;
        double d2;
        double d0 = (double)p_242973_0_.f_124349_ - (double)p_242973_3_.f_20377_;
        double d1 = (double)p_242973_0_.f_124350_ - (double)p_242973_3_.f_20378_;
        BlockPos blockpos = p_242973_0_.f_124348_;
        if (d0 > 0.0) {
            float f = (float)blockpos.m_123304_(p_242973_1_) + p_242973_3_.f_20377_ / 2.0f;
            d2 = Mth.m_14008_((double)Mth.m_14112_((double)(p_242973_2_.m_82507_(p_242973_1_) - (double)f), (double)0.0, (double)d0), (double)0.0, (double)1.0);
        } else {
            d2 = 0.5;
        }
        if (d1 > 0.0) {
            Direction.Axis direction$axis = Direction.Axis.Y;
            d4 = Mth.m_14008_((double)Mth.m_14112_((double)(p_242973_2_.m_82507_(direction$axis) - (double)blockpos.m_123304_(direction$axis)), (double)0.0, (double)d1), (double)0.0, (double)1.0);
        } else {
            d4 = 0.0;
        }
        Direction.Axis direction$axis1 = p_242973_1_ == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        double d3 = p_242973_2_.m_82507_(direction$axis1) - ((double)blockpos.m_123304_(direction$axis1) + 0.5);
        return new Vec3(d2, d4, d3);
    }

    public static PortalInfo createPortalInfo(ServerLevel p_242963_0_, BlockUtil.FoundRectangle p_242963_1_, Direction.Axis p_242963_2_, Vec3 p_242963_3_, EntityDimensions p_242963_4_, Vec3 p_242963_5_, float p_242963_6_, float p_242963_7_) {
        BlockPos blockpos = p_242963_1_.f_124348_;
        BlockState blockstate = p_242963_0_.m_8055_(blockpos);
        Direction.Axis direction$axis = (Direction.Axis)blockstate.m_61143_((Property)BlockStateProperties.f_61364_);
        double d0 = p_242963_1_.f_124349_;
        double d1 = p_242963_1_.f_124350_;
        int i = p_242963_2_ == direction$axis ? 0 : 90;
        Vec3 vector3d = p_242963_2_ == direction$axis ? p_242963_5_ : new Vec3(p_242963_5_.f_82481_, p_242963_5_.f_82480_, -p_242963_5_.f_82479_);
        double d2 = (double)p_242963_4_.f_20377_ / 2.0 + (d0 - (double)p_242963_4_.f_20377_) * p_242963_3_.m_7096_();
        double d3 = (d1 - (double)p_242963_4_.f_20378_) * p_242963_3_.m_7098_();
        double d4 = 0.5 + p_242963_3_.m_7094_();
        boolean flag = direction$axis == Direction.Axis.X;
        Vec3 vector3d1 = new Vec3((double)blockpos.m_123341_() + (flag ? d2 : d4), (double)blockpos.m_123342_() + d3, (double)blockpos.m_123343_() + (flag ? d4 : d2));
        return new PortalInfo(vector3d1, vector3d, p_242963_6_ + (float)i, p_242963_7_);
    }

    public Optional<PortalShape> findEmptyPortalShape(LevelAccessor p_242964_0_, BlockPos p_242964_1_, Direction.Axis p_242964_2_) {
        return this.findPortalShape(p_242964_0_, p_242964_1_, p_242968_0_ -> p_242968_0_.isValid() && p_242968_0_.numPortalBlocks == 0, p_242964_2_);
    }

    public Optional<PortalShape> findPortalShape(LevelAccessor p_242965_0_, BlockPos p_242965_1_, Predicate<PortalShape> p_242965_2_, Direction.Axis p_242965_3_) {
        Optional<PortalShape> optional = Optional.of(new PortalShape(p_242965_0_, p_242965_1_, p_242965_3_, portal, frame)).filter(p_242965_2_);
        if (optional.isPresent()) {
            return optional;
        }
        Direction.Axis direction$axis = p_242965_3_ == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        return Optional.of(new PortalShape(p_242965_0_, p_242965_1_, direction$axis, portal, frame)).filter(p_242965_2_);
    }

    @Nullable
    private BlockPos calculateBottomLeft(BlockPos p_242971_1_) {
        int i = Math.max(0, p_242971_1_.m_123342_() - 21);
        while (p_242971_1_.m_123342_() > i && PortalShape.isEmpty(this.level.m_8055_(p_242971_1_.m_7495_()))) {
            p_242971_1_ = p_242971_1_.m_7495_();
        }
        Direction direction = this.rightDir.m_122424_();
        int j = this.getDistanceUntilEdgeAboveFrame(p_242971_1_, direction) - 1;
        return j < 0 ? null : p_242971_1_.m_5484_(direction, j);
    }

    private int calculateWidth() {
        int i = this.getDistanceUntilEdgeAboveFrame(this.bottomLeft, this.rightDir);
        return i >= 2 && i <= 21 ? i : 0;
    }

    private int getDistanceUntilEdgeAboveFrame(BlockPos p_242972_1_, Direction p_242972_2_) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= 21; ++i) {
            blockpos$mutable.m_122190_((Vec3i)p_242972_1_).m_122175_(p_242972_2_, i);
            BlockState blockstate = this.level.m_8055_((BlockPos)blockpos$mutable);
            if (!PortalShape.isEmpty(blockstate)) {
                if (!FRAME.m_61035_(blockstate, (BlockGetter)this.level, (BlockPos)blockpos$mutable)) break;
                return i;
            }
            BlockState blockstate1 = this.level.m_8055_((BlockPos)blockpos$mutable.m_122173_(Direction.DOWN));
            if (!FRAME.m_61035_(blockstate1, (BlockGetter)this.level, (BlockPos)blockpos$mutable)) break;
        }
        return 0;
    }

    private int calculateHeight() {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        int i = this.getDistanceUntilTop(blockpos$mutable);
        return i >= 3 && i <= 21 && this.hasTopFrame(blockpos$mutable, i) ? i : 0;
    }

    private boolean hasTopFrame(BlockPos.MutableBlockPos p_242970_1_, int p_242970_2_) {
        for (int i = 0; i < this.width; ++i) {
            BlockPos.MutableBlockPos blockpos$mutable = p_242970_1_.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, p_242970_2_).m_122175_(this.rightDir, i);
            if (FRAME.m_61035_(this.level.m_8055_((BlockPos)blockpos$mutable), (BlockGetter)this.level, (BlockPos)blockpos$mutable)) continue;
            return false;
        }
        return true;
    }

    private int getDistanceUntilTop(BlockPos.MutableBlockPos p_242969_1_) {
        for (int i = 0; i < 21; ++i) {
            p_242969_1_.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, -1);
            if (!FRAME.m_61035_(this.level.m_8055_((BlockPos)p_242969_1_), (BlockGetter)this.level, (BlockPos)p_242969_1_)) {
                return i;
            }
            p_242969_1_.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, this.width);
            if (!FRAME.m_61035_(this.level.m_8055_((BlockPos)p_242969_1_), (BlockGetter)this.level, (BlockPos)p_242969_1_)) {
                return i;
            }
            for (int j = 0; j < this.width; ++j) {
                p_242969_1_.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, j);
                BlockState blockstate = this.level.m_8055_((BlockPos)p_242969_1_);
                if (!PortalShape.isEmpty(blockstate)) {
                    return i;
                }
                if (!blockstate.m_60713_(portal)) continue;
                ++this.numPortalBlocks;
            }
        }
        return 21;
    }

    public boolean isValid() {
        return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void createPortalBlocks() {
        BlockState blockstate = (BlockState)portal.m_49966_().m_61124_((Property)NetherPortalBlock.f_54904_, (Comparable)this.axis);
        BlockPos.m_121940_((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.m_5484_(Direction.UP, this.height - 1).m_5484_(this.rightDir, this.width - 1)).forEach(p_242967_2_ -> this.level.m_7731_(p_242967_2_, blockstate, 18));
    }

    public boolean isComplete() {
        return this.isValid() && this.numPortalBlocks == this.width * this.height;
    }
}

