/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.util.UUIDTypeAdapter;
import divinerpg.world.placement.Surface;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;

public class Utils {
    public static byte ICEIKA_WEATHER = (byte)(Math.random() * 4.0);
    private static final Set<UUID> DEV_LIST = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> TESTER_LIST = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> SPECIAL_LIST = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> ARTIST_LIST = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> FRIEND_LIST = ConcurrentHashMap.newKeySet();

    public static boolean isDeveloperName(UUID name) {
        return DEV_LIST.contains(name);
    }

    public static boolean isTesterName(UUID name) {
        return TESTER_LIST.contains(name);
    }

    public static boolean isSpecial(UUID name) {
        return SPECIAL_LIST.contains(name);
    }

    public static boolean isArtist(UUID name) {
        return ARTIST_LIST.contains(name);
    }

    public static boolean isFriend(UUID name) {
        return FRIEND_LIST.contains(name);
    }

    public static void loadHatInformation() {
        CompletableFuture.supplyAsync(() -> {
            String urlString = "https://raw.githubusercontent.com/DivineRPG/DivineRPG-Assets/main/hats.json";
            try {
                HttpURLConnection con = (HttpURLConnection)new URL(urlString).openConnection();
                con.setConnectTimeout(1000);
                InputStream in2 = con.getInputStream();
                List lines = IOUtils.readLines((InputStream)in2, (Charset)Charset.defaultCharset());
                return String.join((CharSequence)"\n", lines);
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }).thenApply(rawJson -> {
            DEV_LIST.clear();
            TESTER_LIST.clear();
            SPECIAL_LIST.clear();
            ARTIST_LIST.clear();
            FRIEND_LIST.clear();
            if (rawJson != null) {
                try {
                    HatsInfo info = (HatsInfo)new Gson().fromJson(rawJson, HatsInfo.class);
                    if (info != null) {
                        DEV_LIST.addAll(info.dev);
                        TESTER_LIST.addAll(info.tester);
                        SPECIAL_LIST.addAll(info.special);
                        ARTIST_LIST.addAll(info.artists);
                        FRIEND_LIST.addAll(info.friend);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return rawJson;
        });
    }

    public static CompletableFuture<UUID> getLicenceId(String nick) {
        return CompletableFuture.supplyAsync(() -> {
            String url = "https://api.mojang.com/users/profiles/minecraft/" + nick;
            UUID result = new UUID(0L, 0L);
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
                connection.setRequestMethod("GET");
                InputStream stream = connection.getInputStream();
                String json = IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
                JsonObject object = (JsonObject)new Gson().fromJson(json, JsonObject.class);
                if (!object.has("error")) {
                    result = UUIDTypeAdapter.fromString((String)object.get("id").getAsString());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return result;
        });
    }

    public static boolean bordersTar(BlockGetter world, int x, int y, int z) {
        for (int i = x - 4; i <= x + 4; ++i) {
            for (int j = y; j <= y + 1; ++j) {
                for (int k = z - 4; k <= z + 4; ++k) {
                    if (world.m_8055_(new BlockPos(i, j, k)).m_60734_() != ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "smoldering_tar"))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void spawnPersistentEntity(Level world, BlockPos pos, LivingEntity entity) {
        entity.m_6095_().m_20592_((ServerLevel)world, ItemStack.f_41583_, null, pos, MobSpawnType.MOB_SUMMONED, false, false);
    }

    public static void populateLootChestBelow(Level world, BlockPos pos, Random rand, ResourceLocation lootTable) {
        BlockPos chestPosition = pos.m_7495_();
        BlockEntity blockEntity = world.m_7702_(chestPosition);
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            ((RandomizableContainerBlockEntity)blockEntity).m_59626_(lootTable, rand.nextLong());
        }
    }

    public static void drop(Level level, Vec3 pos, @Nullable ItemStack item) {
        if (item != null) {
            level.m_7967_((Entity)new ItemEntity(level, pos.f_82479_, pos.f_82480_, pos.f_82481_, item));
        }
    }

    public static Block getBlock(String registryName) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", registryName));
    }

    public static BlockState getBlockState(String registryName) {
        return ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", registryName))).m_49966_();
    }

    public static CompoundTag getPlayerData(Player player) {
        CompoundTag entityData;
        CompoundTag persistentData = player.getPersistentData();
        if (persistentData.m_128441_("PlayerPersisted")) {
            entityData = persistentData.m_128469_("PlayerPersisted");
        } else {
            entityData = new CompoundTag();
            persistentData.m_128365_("PlayerPersisted", (Tag)entityData);
        }
        return entityData;
    }

    public static Tag setPlayerData(Player player, CompoundTag data) {
        return player.getPersistentData().m_128365_("PlayerPersisted", (Tag)data);
    }

    public static boolean isPotion(ItemStack stack, Potion potion) {
        return (stack.m_150930_(Items.f_42589_) || stack.m_150930_(Items.f_42736_) || stack.m_150930_(Items.f_42739_)) && PotionUtils.m_43579_((ItemStack)stack) == potion;
    }

    public static BlockPos getNearbySpawnPos(ServerLevel level, RandomSource random, BlockPos position) {
        BlockState state;
        int x = position.m_123341_() + random.m_188503_(16) - 8;
        int z = position.m_123343_() + random.m_188503_(16) - 8;
        int y = Surface.getSurface(Surface.Surface_Type.HIGHEST_GROUND, Surface.Mode.FULL, 64, 250, 1, (WorldGenLevel)level, random, x, z);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        while ((state = level.m_8055_((BlockPos)pos)).m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_144279_)) {
            pos.m_122173_(Direction.DOWN);
        }
        pos.m_122173_(Direction.UP);
        while (level.m_8055_((BlockPos)pos).m_204336_(BlockTags.f_144279_)) {
            pos.m_122173_(Direction.UP);
        }
        return pos;
    }

    public static BlockPos adjustHeight(ServerLevel level, BlockPos.MutableBlockPos pos) {
        while (!level.m_8055_((BlockPos)pos).m_60795_()) {
            pos.m_122173_(Direction.UP);
        }
        while (level.m_8055_((BlockPos)pos).m_60795_()) {
            pos.m_122173_(Direction.DOWN);
        }
        return pos.m_122173_(Direction.UP);
    }

    public static float rotlerp(float rot, float g, float bound) {
        float f1;
        float f = Mth.m_14177_((float)(g - rot));
        if (f > bound) {
            f = bound;
        }
        if (f < -bound) {
            f = -bound;
        }
        if ((f1 = rot + f) < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        return f1;
    }

    public class HatsInfo {
        public List<UUID> dev;
        public List<UUID> tester;
        public List<UUID> special;
        public List<UUID> artists;
        public List<UUID> friend;
    }
}

