/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util.teleport;

import divinerpg.registries.LevelRegistry;
import divinerpg.registries.PointOfInterestRegistry;
import divinerpg.util.teleport.DivineTeleporter;
import divinerpg.world.placement.Surface;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.tags.StructureTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ArcanaTeleporter
extends DivineTeleporter {
    private static final int SEARCH_RADIUS = 256;
    public final StructureTemplate repairedPortal;

    public ArcanaTeleporter(ServerLevel level, StructureTemplate repairedPortal) {
        super(level, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "arcana_portal")), (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "arcana_portal_frame")), true, (ResourceKey<PoiType>)PointOfInterestRegistry.ARCANA_PORTAL.getKey());
        this.repairedPortal = repairedPortal;
    }

    public boolean isVanilla() {
        return false;
    }

    @Override
    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        PortalInfo ruinedPortal;
        entity.m_20091_();
        if (destWorld.m_46472_() == LevelRegistry.ARCANA && (ruinedPortal = this.repairRuinedPortal(destWorld, destWorld.m_215011_(StructureTags.f_215892_, entity.m_20183_(), 256, false), entity)) != null) {
            return ruinedPortal;
        }
        PortalInfo playerPortal = this.findPlayerMadePortal(destWorld, entity, 256);
        if (playerPortal != null) {
            return playerPortal;
        }
        return super.getPortalInfo(entity, destWorld, defaultPortalInfo);
    }

    private PortalInfo findPlayerMadePortal(ServerLevel level, Entity entity, int searchRadius) {
        BlockPos pos = entity.m_20183_();
        PoiManager poiManager = level.m_8904_();
        poiManager.m_27056_((LevelReader)level, pos, searchRadius);
        Optional<PoiRecord> optional = poiManager.m_27166_(poiType -> poiType.m_203565_(point), pos, searchRadius, PoiManager.Occupancy.ANY).sorted(Comparator.comparingDouble(poi -> poi.m_27257_().m_123331_((Vec3i)pos)).thenComparingInt(poi -> poi.m_27257_().m_123342_())).findFirst();
        if (optional.isEmpty()) {
            BlockUtil.FoundRectangle r = this.makePortal(pos, null).get();
            BlockPos blockpos = r.f_124348_.m_7918_(2, 0, 2);
            level.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(blockpos), 3, (Object)blockpos);
            return new PortalInfo(new Vec3((double)(r.f_124348_.m_123341_() + 2), (double)r.f_124348_.m_123342_(), (double)(r.f_124348_.m_123343_() + 2)), Vec3.f_82478_, entity.f_19858_, entity.f_19857_);
        }
        BlockPos blockpos = optional.get().m_27257_();
        return new PortalInfo(new Vec3((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_()), Vec3.f_82478_, entity.f_19858_, entity.f_19857_);
    }

    private PortalInfo repairRuinedPortal(ServerLevel level, BlockPos position, Entity entity) {
        if (position == null) {
            return null;
        }
        int surface = Surface.getSurface(Surface.Surface_Type.HIGHEST_GROUND, Surface.Mode.FULL, 33, 255, 0, (WorldGenLevel)level, null, position.m_123341_(), position.m_123343_());
        for (int x = position.m_123341_() - 11; x < position.m_123341_() + 11; ++x) {
            for (int y = surface - 7; y < surface + 7; ++y) {
                for (int z = position.m_123343_() - 11; z < position.m_123343_() + 11; ++z) {
                    if (!level.m_8055_(new BlockPos(x, y, z)).m_60713_(portal)) continue;
                    return new PortalInfo(new Vec3((double)x, (double)y, (double)z), Vec3.f_82478_, entity.f_19858_, entity.f_19857_);
                }
            }
        }
        BlockPos pos = null;
        Block tile = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "ancient_tile"));
        block3: for (int x = position.m_123341_() - 11; x < position.m_123341_() + 11; ++x) {
            for (int y = surface - 7; y < surface + 7; ++y) {
                for (int z = position.m_123343_() - 11; z < position.m_123343_() + 11; ++z) {
                    pos = new BlockPos(x, y, z);
                    if (!level.m_8055_(pos).m_60713_(tile)) continue;
                    Block brick = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "light_degraded_brick"));
                    pos = level.m_8055_(pos.m_7918_(-1, 0, -1)).m_60713_(brick) ? pos.m_7918_(-5, 0, -5) : (level.m_8055_(pos.m_7918_(1, 0, -1)).m_60713_(brick) ? pos.m_7918_(-1, 0, -5) : (level.m_8055_(pos.m_7918_(-1, 0, 1)).m_60713_(brick) ? pos.m_7918_(-5, 0, -1) : (level.m_8055_(pos.m_7918_(1, 0, 1)).m_60713_(brick) ? pos.m_7918_(-1, 0, -1) : null)));
                    break block3;
                }
            }
        }
        if (pos == null) {
            return null;
        }
        this.repairedPortal.m_230328_((ServerLevelAccessor)level, pos, pos, new StructurePlaceSettings(), level.f_46441_, 2);
        return new PortalInfo(new Vec3((double)(pos.m_123341_() + 2), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 2)), Vec3.f_82478_, entity.f_19858_, entity.f_19857_);
    }

    @Override
    public Optional<BlockUtil.FoundRectangle> makePortal(BlockPos pos, Direction.Axis axis) {
        pos = new BlockPos(pos.m_123341_(), this.getHeight(this.world, pos.m_123341_(), pos.m_123343_()), pos.m_123343_());
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                if (Math.abs(x) < 2 && Math.abs(z) < 2) {
                    this.world.m_7731_(pos.m_7918_(x, 0, z), portal.m_49966_(), 3);
                    continue;
                }
                if (Math.abs(z) < 2) {
                    if (x == -2) {
                        this.world.m_7731_(pos.m_7918_(x, 0, z), (BlockState)frame.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.EAST), 3);
                        continue;
                    }
                    if (x != 2) continue;
                    this.world.m_7731_(pos.m_7918_(x, 0, z), (BlockState)frame.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.WEST), 3);
                    continue;
                }
                if (Math.abs(x) >= 2) continue;
                if (z == -2) {
                    this.world.m_7731_(pos.m_7918_(x, 0, z), (BlockState)frame.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.SOUTH), 3);
                    continue;
                }
                this.world.m_7731_(pos.m_7918_(x, 0, z), (BlockState)frame.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH), 3);
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(pos, 3, 3));
    }

    protected int getHeight(ServerLevel level, int posX, int posZ) {
        for (int y = level.m_141928_(); y > 32; --y) {
            BlockState block = level.m_8055_(new BlockPos(posX, y, posZ));
            if (block.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "arcanite_sand")))) {
                return y;
            }
            if (!block.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "arcanite_stone")))) continue;
            return ++y;
        }
        return level.m_6924_(Heightmap.Types.MOTION_BLOCKING, posX, posZ);
    }
}

