/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature;

import divinerpg.world.feature.config.EllipsoidConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class Ellipsoid
extends Feature<EllipsoidConfig> {
    public Ellipsoid() {
        super(EllipsoidConfig.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<EllipsoidConfig> context) {
        return this.place((EllipsoidConfig)context.m_159778_(), context.m_159774_(), null, context.m_225041_(), context.m_159777_());
    }

    public boolean place(EllipsoidConfig config, WorldGenLevel level, ChunkGenerator c, RandomSource random, BlockPos pos) {
        if (this.canBeHere(config.replace, random, level.m_8055_(pos))) {
            int xSize = this.getSize(random, config.minSize, config.maxSize);
            int ySize = this.getSize(random, config.minSize, config.maxSize);
            int zSize = this.getSize(random, config.minSize, config.maxSize);
            for (int x = -xSize; x < xSize; ++x) {
                for (int y = -ySize; y < ySize; ++y) {
                    for (int z = -zSize; z < zSize; ++z) {
                        if (!(Math.pow(x, 2.0) / Math.pow(xSize, 2.0) + Math.pow(y, 2.0) / Math.pow(ySize, 2.0) + Math.pow(z, 2.0) / Math.pow(zSize, 2.0) < 0.5) || !this.canBeHere(config.replace, random, level.m_8055_(pos.m_7918_(x, y, z)))) continue;
                        BlockPos p = pos.m_7918_(x, y, z);
                        level.m_7731_(p, config.block.m_213972_(random, p), 3);
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected final int getSize(RandomSource random, int minSize, int maxSize) {
        return random.m_216339_(minSize, maxSize + 1);
    }

    public final boolean canBeHere(List<RuleTest> replace, RandomSource random, BlockState state) {
        if (replace.isEmpty() && this.defaultReplace(state)) {
            return true;
        }
        for (RuleTest test : replace) {
            if (!test.m_213865_(state, random)) continue;
            return true;
        }
        return false;
    }

    public boolean defaultReplace(BlockState state) {
        return state.m_60795_();
    }
}

