/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.decoration;

import divinerpg.blocks.iceika.BlockIcicle;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.PointedDripstoneConfiguration;
import net.minecraftforge.registries.ForgeRegistries;

public class Icicle
extends Feature<PointedDripstoneConfiguration> {
    public Icicle() {
        super(PointedDripstoneConfiguration.f_191274_);
    }

    public boolean m_142674_(FeaturePlaceContext<PointedDripstoneConfiguration> p_191078_) {
        WorldGenLevel levelaccessor = p_191078_.m_159774_();
        BlockPos blockpos = p_191078_.m_159777_();
        RandomSource randomsource = p_191078_.m_225041_();
        PointedDripstoneConfiguration pointeddripstoneconfiguration = (PointedDripstoneConfiguration)p_191078_.m_159778_();
        Optional<Direction> optional = Icicle.getTipDirection((LevelAccessor)levelaccessor, blockpos, randomsource);
        if (optional.isEmpty()) {
            return false;
        }
        BlockPos blockpos1 = blockpos.m_121945_(optional.get().m_122424_());
        Icicle.createPatchOfPackedIce((LevelAccessor)levelaccessor, randomsource, blockpos1, pointeddripstoneconfiguration);
        int i = randomsource.m_188501_() < pointeddripstoneconfiguration.f_191275_ && DripstoneUtils.m_159664_((BlockState)levelaccessor.m_8055_(blockpos.m_121945_(optional.get()))) ? 2 : 1;
        Icicle.growIcicle((LevelAccessor)levelaccessor, blockpos, optional.get(), i, false);
        return true;
    }

    private static Optional<Direction> getTipDirection(LevelAccessor p_225199_, BlockPos p_225200_, RandomSource p_225201_) {
        boolean flag = Icicle.isIcicleBase(p_225199_.m_8055_(p_225200_.m_7494_()));
        boolean flag1 = Icicle.isIcicleBase(p_225199_.m_8055_(p_225200_.m_7495_()));
        if (flag && flag1) {
            return Optional.of(p_225201_.m_188499_() ? Direction.DOWN : Direction.UP);
        }
        if (flag) {
            return Optional.of(Direction.DOWN);
        }
        return flag1 ? Optional.of(Direction.UP) : Optional.empty();
    }

    private static void createPatchOfPackedIce(LevelAccessor p_225194_, RandomSource p_225195_, BlockPos p_225196_, PointedDripstoneConfiguration p_225197_) {
        Icicle.placePackedIceIfPossible(p_225194_, p_225196_);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (p_225195_.m_188501_() > p_225197_.f_191276_) continue;
            BlockPos blockpos = p_225196_.m_121945_(direction);
            Icicle.placePackedIceIfPossible(p_225194_, blockpos);
            if (p_225195_.m_188501_() > p_225197_.f_191277_) continue;
            BlockPos blockpos1 = blockpos.m_121945_(Direction.m_235672_((RandomSource)p_225195_));
            Icicle.placePackedIceIfPossible(p_225194_, blockpos1);
            if (p_225195_.m_188501_() > p_225197_.f_191278_) continue;
            BlockPos blockpos2 = blockpos1.m_121945_(Direction.m_235672_((RandomSource)p_225195_));
            Icicle.placePackedIceIfPossible(p_225194_, blockpos2);
        }
    }

    protected static boolean placePackedIceIfPossible(LevelAccessor p_190854_, BlockPos p_190855_) {
        BlockState blockstate = p_190854_.m_8055_(p_190855_);
        if (Icicle.isIcicleBase(blockstate)) {
            if (!(blockstate.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "brittle_leaves"))) || blockstate.m_60713_(Blocks.f_50126_) || blockstate.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "shiverspine_log"))))) {
                p_190854_.m_7731_(p_190855_, Blocks.f_50354_.m_49966_(), 2);
            }
            return true;
        }
        return false;
    }

    protected static void growIcicle(LevelAccessor p_190848_, BlockPos p_190849_, Direction p_190850_, int p_190851_, boolean p_190852_) {
        if (Icicle.isIcicleBase(p_190848_.m_8055_(p_190849_.m_121945_(p_190850_.m_122424_())))) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = p_190849_.m_122032_();
            Icicle.buildBaseToTipColumn(p_190850_, p_190851_, p_190852_, p_190846_ -> {
                if (p_190846_.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "icicle")))) {
                    p_190846_ = (BlockState)p_190846_.m_61124_((Property)BlockIcicle.WATERLOGGED, (Comparable)Boolean.valueOf(p_190848_.m_46801_((BlockPos)blockpos$mutableblockpos)));
                }
                p_190848_.m_7731_((BlockPos)blockpos$mutableblockpos, p_190846_, 2);
                blockpos$mutableblockpos.m_122173_(p_190850_);
            });
        }
    }

    public static boolean isIcicleBase(BlockState blockstate) {
        return blockstate.m_204336_(BlockTags.f_144273_) || blockstate.m_204336_(BlockTags.f_13047_) || blockstate.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "brittle_leaves"))) || blockstate.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "shiverspine_log"))) || blockstate.m_60713_(Blocks.f_49994_);
    }

    protected static void buildBaseToTipColumn(Direction p_159652_, int p_159653_, boolean p_159654_, Consumer<BlockState> p_159655_) {
        if (p_159653_ >= 3) {
            p_159655_.accept(Icicle.createIcicle(p_159652_, DripstoneThickness.BASE));
            for (int i = 0; i < p_159653_ - 3; ++i) {
                p_159655_.accept(Icicle.createIcicle(p_159652_, DripstoneThickness.MIDDLE));
            }
        }
        if (p_159653_ >= 2) {
            p_159655_.accept(Icicle.createIcicle(p_159652_, DripstoneThickness.FRUSTUM));
        }
        if (p_159653_ >= 1) {
            p_159655_.accept(Icicle.createIcicle(p_159652_, p_159654_ ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    private static BlockState createIcicle(Direction p_159657_, DripstoneThickness p_159658_) {
        return (BlockState)((BlockState)((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "icicle"))).m_49966_().m_61124_((Property)BlockIcicle.TIP_DIRECTION, (Comparable)p_159657_)).m_61124_(BlockIcicle.THICKNESS, (Comparable)p_159658_);
    }
}

