/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.ore;

import divinerpg.world.feature.config.ore.OreVeinConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class OreVein
extends Feature<OreVeinConfig> {
    public OreVein() {
        super(OreVeinConfig.CODEC);
    }

    public boolean place(OreVeinConfig config, WorldGenLevel level, ChunkGenerator generator, RandomSource random, BlockPos origin) {
        List<OreVeinConfig.TargetBlockState> states = config.targetStates;
        if (VeinArm.canBeHere(level, origin, states, random)) {
            new VeinArm(origin, Direction.m_235672_((RandomSource)random)).run(level, random, origin, config.cutoffChance, config.straightness, config.branchingChance, states);
            return true;
        }
        return false;
    }

    public boolean m_142674_(FeaturePlaceContext<OreVeinConfig> context) {
        return this.place((OreVeinConfig)context.m_159778_(), context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_());
    }

    public static class VeinArm {
        Direction direction;
        BlockPos pos;

        public VeinArm(BlockPos p, Direction dir) {
            this.pos = p;
            this.direction = dir;
        }

        public static boolean canBeHere(WorldGenLevel level, BlockPos pos, List<OreVeinConfig.TargetBlockState> states, RandomSource random) {
            BlockState state = level.m_8055_(pos);
            for (OreVeinConfig.TargetBlockState targetState : states) {
                if (targetState.state.m_60713_(state.m_60734_())) {
                    return true;
                }
                if (!targetState.target.m_213865_(state, random)) continue;
                return true;
            }
            return false;
        }

        public void run(WorldGenLevel level, RandomSource random, BlockPos origin, float cutoffChance, float straightness, float branchingChance, List<OreVeinConfig.TargetBlockState> states) {
            while (level.m_46865_(origin) == level.m_46865_(this.pos) && VeinArm.canBeHere(level, this.pos, states, random) && random.m_188501_() > cutoffChance) {
                this.setVeinPart(level, random, this.pos, states);
                this.setVeinPart(level, random, this.pos.m_7494_(), states);
                this.setVeinPart(level, random, this.pos.m_7495_(), states);
                this.setVeinPart(level, random, this.pos.m_122012_(), states);
                this.setVeinPart(level, random, this.pos.m_122029_(), states);
                this.setVeinPart(level, random, this.pos.m_122024_(), states);
                this.setVeinPart(level, random, this.pos.m_122019_(), states);
                this.pos = this.pos.m_121945_(this.direction);
                if (random.m_188501_() > straightness) {
                    this.direction = Direction.m_235672_((RandomSource)random);
                }
                if (!(random.m_188501_() <= branchingChance)) continue;
                new VeinArm(this.pos, Direction.m_235672_((RandomSource)random)).run(level, random, origin, cutoffChance, straightness, branchingChance, states);
            }
        }

        public void setVeinPart(WorldGenLevel level, RandomSource random, BlockPos pos, List<OreVeinConfig.TargetBlockState> states) {
            if (random.m_188499_()) {
                pos = pos.m_121945_(Direction.m_235672_((RandomSource)random));
            }
            OreVeinConfig.TargetBlockState targetState = states.get(random.m_188503_(states.size()));
            if (random.m_188501_() <= targetState.chance && targetState.target.m_213865_(level.m_8055_(pos), random) && (random.m_188501_() > targetState.discardChanceOnAirExposure || !this.checkForAir(level, pos))) {
                level.m_7731_(pos, targetState.state, 3);
            }
        }

        public boolean checkForAir(WorldGenLevel level, BlockPos pos) {
            return level.m_46859_(pos.m_7494_()) || level.m_46859_(pos.m_7495_()) || level.m_46859_(pos.m_122012_()) || level.m_46859_(pos.m_122019_()) || level.m_46859_(pos.m_122029_()) || level.m_46859_(pos.m_122024_());
        }
    }
}

