/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.tree;

import divinerpg.world.feature.config.tree.TreeConfig;
import divinerpg.world.feature.decoration.SnowCoverage;
import divinerpg.world.feature.tree.ShiverspineTree;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class CozybarkTree
extends ShiverspineTree {
    @Override
    protected void setBlock(WorldGenLevel level, BlockPos pos, BlockState state, boolean replace) {
        BlockPos.MutableBlockPos position = pos.m_122032_();
        BlockState s = level.m_8055_(pos);
        boolean hasSnow = s.m_204336_(BlockTags.f_144279_);
        if (hasSnow) {
            this.m_5974_((LevelWriter)level, pos, state.m_61138_((Property)BlockStateProperties.f_61451_) ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(true)) : state);
            while (level.m_8055_((BlockPos)position.m_122184_(0, 1, 0)).m_204336_(BlockTags.f_144279_)) {
                this.m_5974_((LevelWriter)level, (BlockPos)position, Blocks.f_50016_.m_49966_());
            }
        } else {
            BlockState st = s;
            while ((s = level.m_8055_((BlockPos)position.m_122184_(0, -1, 0))).m_60795_()) {
            }
            hasSnow = s.m_204336_(BlockTags.f_144279_);
            if (hasSnow) {
                do {
                    this.m_5974_((LevelWriter)level, (BlockPos)position, Blocks.f_50016_.m_49966_());
                } while (level.m_8055_((BlockPos)position.m_122184_(0, -1, 0)).m_204336_(BlockTags.f_144279_));
            }
            if (this.hasSpace(st) || replace && !st.m_60713_(Blocks.f_50752_)) {
                this.m_5974_((LevelWriter)level, pos, hasSnow && state.m_61138_((Property)BlockStateProperties.f_61451_) ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(true)) : state);
            } else {
                return;
            }
        }
        if (hasSnow) {
            position = pos.m_122032_();
            while (!level.m_8055_((BlockPos)position.m_122184_(0, 1, 0)).m_60795_()) {
            }
            SnowCoverage.snow(level, level.m_213780_(), position);
        }
    }

    @Override
    protected void setBlockSensitive(WorldGenLevel level, RandomSource random, BlockPos pos, BlockState state, float chance) {
        if (random.m_188501_() <= chance) {
            BlockPos.MutableBlockPos position = pos.m_122032_();
            BlockState s = level.m_8055_(pos);
            boolean hasSnow = s.m_204336_(BlockTags.f_144279_);
            if (hasSnow) {
                this.m_5974_((LevelWriter)level, pos, state.m_61138_((Property)BlockStateProperties.f_61451_) ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(true)) : state);
                while (level.m_8055_((BlockPos)position.m_122184_(0, 1, 0)).m_204336_(BlockTags.f_144279_)) {
                    this.m_5974_((LevelWriter)level, (BlockPos)position, Blocks.f_50016_.m_49966_());
                }
            } else {
                BlockState st = s;
                while ((s = level.m_8055_((BlockPos)position.m_122184_(0, -1, 0))).m_60795_()) {
                }
                hasSnow = s.m_204336_(BlockTags.f_144279_);
                if (hasSnow) {
                    do {
                        this.m_5974_((LevelWriter)level, (BlockPos)position, Blocks.f_50016_.m_49966_());
                    } while (level.m_8055_((BlockPos)position.m_122184_(0, -1, 0)).m_204336_(BlockTags.f_144279_));
                }
                if (st.m_60795_()) {
                    this.m_5974_((LevelWriter)level, pos, hasSnow && state.m_61138_((Property)BlockStateProperties.f_61451_) ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(true)) : state);
                } else {
                    return;
                }
            }
            if (hasSnow) {
                position = pos.m_122032_();
                while (!level.m_8055_((BlockPos)position.m_122184_(0, 1, 0)).m_60795_()) {
                }
                SnowCoverage.snow(level, level.m_213780_(), position);
            }
        }
    }

    protected void flatCanopy(WorldGenLevel level, RandomSource random, BlockPos pos, BlockState leaves, int size) {
        int posX = pos.m_123341_();
        int posZ = pos.m_123343_();
        int y = pos.m_123342_();
        for (int x = posX - size; x <= posX + size; ++x) {
            for (int z = posZ - size; z <= posZ + size; ++z) {
                pos = new BlockPos(x, y, z);
                this.setBlockSensitive(level, random, pos, leaves, (float)size - (float)Math.sqrt(Math.pow(posX - x, 2.0) + Math.pow(posZ - z, 2.0)));
                if (!level.m_8055_(pos).m_60713_(leaves.m_60734_()) || !(random.m_188501_() <= 0.2f)) continue;
                this.setBlockSensitive(level, random, new BlockPos(x, y - 1, z), leaves, 1.0f);
                this.setBlockSensitive(level, random, new BlockPos(x, y - 2, z), leaves, 0.5f);
            }
        }
    }

    protected void branch(WorldGenLevel level, RandomSource random, BlockPos.MutableBlockPos pos, BlockState log, BlockState leaves, int directionX, int directionZ, int maxY) {
        int distance = 0;
        boolean hasLeaves = false;
        do {
            this.setBlock(level, (BlockPos)pos, log, true);
            if (distance > 2 && hasLeaves) {
                this.flatCanopy(level, random, (BlockPos)pos, leaves, 3);
            } else {
                hasLeaves = random.m_188499_();
            }
            pos.m_122184_(random.m_188503_(2) - directionX, random.m_188503_(2), random.m_188503_(2) - directionZ);
        } while (random.m_188501_() <= 0.7f && ++distance < 7 && pos.m_123342_() < maxY);
        this.setBlock(level, (BlockPos)pos, log, true);
        this.flatCanopy(level, random, (BlockPos)pos, leaves, 3);
        this.flatCanopy(level, random, pos.m_7494_(), leaves, 2);
    }

    protected void root(WorldGenLevel level, RandomSource random, BlockPos.MutableBlockPos pos, BlockState log, int directionX, int directionZ) {
        BlockState state = level.m_8055_(pos.m_7495_());
        if (random.m_188501_() <= 0.3f && !state.m_60795_() && !state.m_60713_(Blocks.f_49990_)) {
            this.setBlock(level, pos.m_7494_(), log, false);
        }
        int distance = 0;
        do {
            if ((state = level.m_8055_((BlockPos)pos)).m_60795_() || state.m_60713_(Blocks.f_49990_)) {
                pos.m_122184_(0, -1, 0);
            }
            this.setBlock(level, (BlockPos)pos, log, true);
            pos.m_122184_(random.m_188503_(2) - directionX, random.m_188503_(2) - 1, random.m_188503_(2) - directionZ);
        } while (++distance < 6 && random.m_188501_() <= 0.8f);
    }

    @Override
    public boolean place(TreeConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        if (this.canBeHere(level, random, pos, config)) {
            int treeType = random.m_188503_(5) == 0 ? random.m_188503_(3) : random.m_188503_(2) + 1;
            int treeHeight = switch (treeType) {
                case 2 -> 13 + random.m_188503_(4);
                case 1 -> 9 + random.m_188503_(6);
                default -> 5 + random.m_188503_(5);
            };
            int extraHeight = treeHeight + 1;
            if (this.heightCheck(level, pos, treeHeight, treeType + 1)) {
                BlockState log = config.log;
                BlockState leaves = config.leaves;
                switch (treeType) {
                    case 2: {
                        this.grow(level, pos.m_7495_(), log, extraHeight, true);
                        this.grow(level, pos.m_7918_(-1, -1, -1), log, extraHeight, true);
                        this.grow(level, pos.m_7918_(0, -1, -1), log, extraHeight, true);
                        this.grow(level, pos.m_7918_(1, -1, -1), log, extraHeight, true);
                        this.grow(level, pos.m_7918_(-1, -1, 0), log, extraHeight, true);
                        this.grow(level, pos.m_7918_(1, -1, 0), log, extraHeight, true);
                        this.grow(level, pos.m_7918_(-1, -1, 1), log, extraHeight, true);
                        this.grow(level, pos.m_7918_(0, -1, 1), log, extraHeight, true);
                        this.grow(level, pos.m_7918_(1, -1, 1), log, extraHeight, true);
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() - 2, pos.m_123342_(), pos.m_123343_() - 1), log, 1, random.m_188503_(2));
                        }
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() - 2, pos.m_123342_(), pos.m_123343_()), log, 1, random.m_188503_(2));
                        }
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() - 2, pos.m_123342_(), pos.m_123343_() + 1), log, 1, random.m_188503_(2));
                        }
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + 2, pos.m_123342_(), pos.m_123343_() - 1), log, 0, random.m_188503_(2));
                        }
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + 2, pos.m_123342_(), pos.m_123343_()), log, 0, random.m_188503_(2));
                        }
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + 2, pos.m_123342_(), pos.m_123343_() + 1), log, 0, random.m_188503_(2));
                        }
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_() - 2), log, random.m_188503_(2), 1);
                        }
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() - 2), log, random.m_188503_(2), 1);
                        }
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_() - 2), log, random.m_188503_(2), 1);
                        }
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_() + 2), log, random.m_188503_(2), 0);
                        }
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() + 2), log, random.m_188503_(2), 0);
                        }
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_() + 2), log, random.m_188503_(2), 0);
                        }
                        treeType = treeHeight;
                        for (treeHeight = extraHeight - 6 - random.m_188503_(5); treeHeight < extraHeight; ++treeHeight) {
                            if (random.m_188501_() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() - 2, pos.m_123342_() + treeHeight, pos.m_123343_() - 1), log, leaves, 1, random.m_188503_(2), treeType);
                            }
                            if (random.m_188501_() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() - 2, pos.m_123342_() + treeHeight, pos.m_123343_()), log, leaves, 1, random.m_188503_(2), treeType);
                            }
                            if (random.m_188501_() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() - 2, pos.m_123342_() + treeHeight, pos.m_123343_() + 1), log, leaves, 1, random.m_188503_(2), treeType);
                            }
                            if (random.m_188501_() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + 2, pos.m_123342_() + treeHeight, pos.m_123343_() - 1), log, leaves, 0, random.m_188503_(2), treeType);
                            }
                            if (random.m_188501_() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + 2, pos.m_123342_() + treeHeight, pos.m_123343_()), log, leaves, 0, random.m_188503_(2), treeType);
                            }
                            if (random.m_188501_() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + 2, pos.m_123342_() + treeHeight, pos.m_123343_() + 1), log, leaves, 0, random.m_188503_(2), treeType);
                            }
                            if (random.m_188501_() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() - 1, pos.m_123342_() + treeHeight, pos.m_123343_() - 2), log, leaves, random.m_188503_(2), 1, treeType);
                            }
                            if (random.m_188501_() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_() + treeHeight, pos.m_123343_() - 2), log, leaves, random.m_188503_(2), 1, treeType);
                            }
                            if (random.m_188501_() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + 1, pos.m_123342_() + treeHeight, pos.m_123343_() - 2), log, leaves, random.m_188503_(2), 1, treeType);
                            }
                            if (random.m_188501_() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() - 1, pos.m_123342_() + treeHeight, pos.m_123343_() + 2), log, leaves, random.m_188503_(2), 0, treeType);
                            }
                            if (random.m_188501_() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_() + treeHeight, pos.m_123343_() + 2), log, leaves, random.m_188503_(2), 0, treeType);
                            }
                            if (!(random.m_188501_() <= 0.17f)) continue;
                            this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + 1, pos.m_123342_() + treeHeight, pos.m_123343_() + 2), log, leaves, random.m_188503_(2), 0, treeType);
                        }
                        BlockPos.MutableBlockPos origin = pos.m_122032_();
                        for (treeHeight = -1; treeHeight < 2; ++treeHeight) {
                            for (treeType = -1; treeType < 2; ++treeType) {
                                pos = origin.m_7918_(treeHeight, extraHeight, treeType);
                                this.flatCanopy(level, random, pos, leaves, 3);
                                pos = pos.m_7495_();
                                this.flatCanopy(level, random, pos, leaves, 4);
                                pos = pos.m_7495_();
                                this.flatCanopy(level, random, pos, leaves, 5);
                                pos = pos.m_7495_();
                                this.flatCanopy(level, random, pos, leaves, 6);
                                pos = pos.m_7495_();
                                this.flatCanopy(level, random, pos, leaves, 7);
                                this.flatCanopy(level, random, pos.m_7495_(), leaves, 7);
                            }
                        }
                        break;
                    }
                    case 1: {
                        this.wideGrow(level, pos, log, treeHeight, 0, 0, true);
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_()), log, 1, random.m_188503_(2));
                        }
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_() + 1), log, 1, random.m_188503_(2));
                        }
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() - 1), log, random.m_188503_(2), 1);
                        }
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_() - 1), log, random.m_188503_(2), 1);
                        }
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() + 2), log, random.m_188503_(2), 0);
                        }
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_() + 2), log, random.m_188503_(2), 0);
                        }
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + 2, pos.m_123342_(), pos.m_123343_()), log, 0, random.m_188503_(2));
                        }
                        if (random.m_188501_() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + 2, pos.m_123342_(), pos.m_123343_() + 1), log, 0, random.m_188503_(2));
                        }
                        for (treeType = extraHeight - 5 - random.m_188503_(5); treeType < extraHeight; ++treeType) {
                            if (random.m_188501_() <= 0.25f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() - 1, pos.m_123342_() + treeType, pos.m_123343_()), log, leaves, 1, random.m_188503_(2), treeHeight);
                            }
                            if (random.m_188501_() <= 0.25f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() - 1, pos.m_123342_() + treeType, pos.m_123343_() + 1), log, leaves, 1, random.m_188503_(2), treeHeight);
                            }
                            if (random.m_188501_() <= 0.25f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_() + treeType, pos.m_123343_() - 1), log, leaves, random.m_188503_(2), 1, treeHeight);
                            }
                            if (random.m_188501_() <= 0.25f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + 1, pos.m_123342_() + treeType, pos.m_123343_() - 1), log, leaves, random.m_188503_(2), 1, treeHeight);
                            }
                            if (random.m_188501_() <= 0.25f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_() + treeType, pos.m_123343_() + 2), log, leaves, random.m_188503_(2), 0, treeHeight);
                            }
                            if (random.m_188501_() <= 0.25f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + 1, pos.m_123342_() + treeType, pos.m_123343_() + 2), log, leaves, random.m_188503_(2), 0, treeHeight);
                            }
                            if (random.m_188501_() <= 0.25f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + 2, pos.m_123342_() + treeType, pos.m_123343_()), log, leaves, 0, random.m_188503_(2), treeHeight);
                            }
                            if (!(random.m_188501_() <= 0.25f)) continue;
                            this.branch(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + 2, pos.m_123342_() + treeType, pos.m_123343_() + 1), log, leaves, 0, random.m_188503_(2), treeHeight);
                        }
                        pos = pos.m_7918_(0, extraHeight, 0);
                        this.flatCanopy(level, random, pos, leaves, 3);
                        pos = pos.m_7495_();
                        this.flatCanopy(level, random, pos, leaves, 4);
                        pos = pos.m_7495_();
                        this.flatCanopy(level, random, pos, leaves, 5);
                        pos = pos.m_7495_();
                        this.flatCanopy(level, random, pos, leaves, 6);
                        this.flatCanopy(level, random, pos.m_7495_(), leaves, 6);
                        break;
                    }
                    default: {
                        this.grow(level, pos, log, treeHeight, true);
                        pos = pos.m_7918_(0, extraHeight, 0);
                        this.flatCanopy(level, random, pos, leaves, 2);
                        pos = pos.m_7495_();
                        this.flatCanopy(level, random, pos, leaves, 3);
                        pos = pos.m_7495_();
                        this.flatCanopy(level, random, pos, leaves, 4);
                        pos = pos.m_7495_();
                        this.flatCanopy(level, random, pos, leaves, 5);
                        for (treeHeight = -1; treeHeight < 2; ++treeHeight) {
                            for (extraHeight = -1; extraHeight < 2; ++extraHeight) {
                                if (!(random.m_188501_() <= 0.4f)) continue;
                                BlockPos.MutableBlockPos m = new BlockPos.MutableBlockPos(pos.m_123341_() + treeHeight, pos.m_123342_(), pos.m_123343_() + extraHeight);
                                this.setBlock(level, (BlockPos)m, log, true);
                                this.flatCanopy(level, random, (BlockPos)m, leaves, 3);
                            }
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }
}

