/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.tree;

import divinerpg.world.feature.config.tree.TreeConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class DivineTree
extends Feature<TreeConfig> {
    public DivineTree() {
        super(TreeConfig.CODEC);
    }

    public boolean hasSpace(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return this.hasSpace(state);
    }

    public boolean hasSpace(BlockState state) {
        return state.m_60795_() || state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13041_) || state.m_204336_(BlockTags.f_278411_) && !state.m_60713_(Blocks.f_49990_);
    }

    public final boolean heightCheck(WorldGenLevel level, BlockPos pos, int maxHeight, int width) {
        for (int y = 0; y < maxHeight; ++y) {
            if (level.m_151570_(pos.m_7918_(0, y, 0))) {
                return false;
            }
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < width; ++z) {
                    if (this.hasSpace(level, pos.m_7918_(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean canBeHere(WorldGenLevel level, RandomSource random, BlockPos pos, TreeConfig config) {
        if (this.hasSpace(level, pos)) {
            BlockState state = level.m_8055_(pos.m_7495_());
            if (config.growableOn.isEmpty() && this.defaultGrowOn(state)) {
                return true;
            }
            for (RuleTest test : config.growableOn) {
                if (!test.m_213865_(state, random)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean defaultGrowOn(BlockState state) {
        return state.m_204336_(BlockTags.f_144274_);
    }

    protected void setBlock(WorldGenLevel level, BlockPos pos, BlockState state, boolean replace) {
        BlockState block = level.m_8055_(pos);
        if (this.hasSpace(block) || replace && !block.m_60713_(Blocks.f_50752_)) {
            this.m_5974_((LevelWriter)level, pos, state);
        }
    }

    protected void setBlockSensitive(WorldGenLevel level, RandomSource random, BlockPos pos, BlockState state, float chance) {
        if (random.m_188501_() <= chance && level.m_8055_(pos).m_60795_()) {
            this.m_5974_((LevelWriter)level, pos, state);
        }
    }

    protected void chanceSetBlock(WorldGenLevel level, RandomSource random, BlockPos pos, BlockState state, float chance) {
        if (random.m_188501_() <= chance) {
            this.setBlock(level, pos, state, false);
        }
    }

    protected void chanceSetBlock(WorldGenLevel level, RandomSource random, BlockPos pos, BlockState state, float chance, boolean replace) {
        if (random.m_188501_() <= chance) {
            this.setBlock(level, pos, state, replace);
        }
    }

    protected void grow(WorldGenLevel world, BlockPos pos, BlockState state, int width, int offset) {
        this.grow(world, pos, state, width, offset, false);
    }

    protected void grow(WorldGenLevel world, BlockPos pos, BlockState state, int width, int offset, boolean replace) {
        this.setBlock(world, pos.m_7918_(width, 0, offset), state, replace);
        this.setBlock(world, pos.m_7918_(-width, 0, -offset), state, replace);
        this.setBlock(world, pos.m_7918_(offset, 0, -width), state, replace);
        this.setBlock(world, pos.m_7918_(-offset, 0, width), state, replace);
    }

    protected void grow(WorldGenLevel world, RandomSource random, BlockPos pos, BlockState state, int width, int offset, float chance) {
        this.grow(world, random, pos, state, width, offset, false, chance);
    }

    protected void grow(WorldGenLevel world, RandomSource random, BlockPos pos, BlockState state, int width, int offset, boolean replace, float chance) {
        this.chanceSetBlock(world, random, pos.m_7918_(width, 0, offset), state, chance, replace);
        this.chanceSetBlock(world, random, pos.m_7918_(-width, 0, -offset), state, chance, replace);
        this.chanceSetBlock(world, random, pos.m_7918_(offset, 0, -width), state, chance, replace);
        this.chanceSetBlock(world, random, pos.m_7918_(-offset, 0, width), state, chance, replace);
    }

    protected void grow(WorldGenLevel world, BlockPos pos, BlockState state, int maxY) {
        this.grow(world, pos, state, maxY, false);
    }

    protected void grow(WorldGenLevel world, BlockPos pos, BlockState state, int maxY, boolean replace) {
        for (int minY = 0; minY <= maxY; ++minY) {
            this.setBlock(world, pos.m_7918_(0, minY, 0), state, replace);
        }
    }

    protected void grow(WorldGenLevel world, RandomSource random, BlockPos pos, BlockState state, int maxY, float chance) {
        this.grow(world, random, pos, state, maxY, false, chance);
    }

    protected void grow(WorldGenLevel world, RandomSource random, BlockPos pos, BlockState state, int maxY, boolean replace, float chance) {
        for (int minY = 0; minY <= maxY; ++minY) {
            this.chanceSetBlock(world, random, pos.m_7918_(0, minY, 0), state, chance, replace);
        }
    }

    protected void grow(WorldGenLevel world, BlockPos pos, BlockState state, int maxY, int width, int offset) {
        this.grow(world, pos, state, maxY, width, offset, false);
    }

    protected void grow(WorldGenLevel world, BlockPos pos, BlockState state, int maxY, int width, int offset, boolean replace) {
        for (int minY = 0; minY <= maxY; ++minY) {
            this.setBlock(world, pos.m_7918_(width, minY, offset), state, replace);
            this.setBlock(world, pos.m_7918_(-width, minY, -offset), state, replace);
            this.setBlock(world, pos.m_7918_(offset, minY, -width), state, replace);
            this.setBlock(world, pos.m_7918_(-offset, minY, width), state, replace);
        }
    }

    protected void grow(WorldGenLevel world, RandomSource random, BlockPos pos, BlockState state, int maxY, int width, int offset, float chance) {
        this.grow(world, random, pos, state, maxY, width, offset, false, chance);
    }

    protected void grow(WorldGenLevel world, RandomSource random, BlockPos pos, BlockState state, int maxY, int width, int offset, boolean replace, float chance) {
        for (int minY = 0; minY <= maxY; ++minY) {
            this.chanceSetBlock(world, random, pos.m_7918_(width, minY, offset), state, chance, replace);
            this.chanceSetBlock(world, random, pos.m_7918_(-width, minY, -offset), state, chance, replace);
            this.chanceSetBlock(world, random, pos.m_7918_(offset, minY, -width), state, chance, replace);
            this.chanceSetBlock(world, random, pos.m_7918_(-offset, minY, width), state, chance, replace);
        }
    }

    public boolean m_142674_(FeaturePlaceContext<TreeConfig> context) {
        return this.place((TreeConfig)context.m_159778_(), context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_());
    }

    public boolean place(TreeConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        int treeHeight;
        int extraHeight;
        if (this.canBeHere(level, random, pos, config) && this.heightCheck(level, pos, extraHeight = (treeHeight = 3 + random.m_188503_(3)) + 1, 1)) {
            BlockState log = config.log;
            BlockState leaves = config.leaves;
            this.grow(level, pos, log, treeHeight);
            this.m_5974_((LevelWriter)level, pos.m_7918_(0, extraHeight, 0), leaves);
            BlockPos temp = pos.m_7918_(0, treeHeight - 2, 0);
            this.grow(level, temp, leaves, 1, 1, 1);
            this.grow(level, temp, leaves, 3, 1, 0);
            for (int offset = -1; offset < 2; ++offset) {
                this.grow(level, temp, leaves, 1, 2, offset);
            }
            this.grow(level, random, temp, leaves, 1, 2, 2, 0.5f);
            this.grow(level, random, pos.m_7918_(0, treeHeight, 0), leaves, 1, 1, 0.5f);
            return true;
        }
        return false;
    }
}

