/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.tree;

import divinerpg.world.feature.config.tree.TreeConfig;
import divinerpg.world.feature.tree.DivineTree;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraftforge.registries.ForgeRegistries;

public class SkythernTree
extends DivineTree {
    @Override
    protected boolean defaultGrowOn(BlockState state) {
        return state.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "skythern_dirt"))) || state.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "skythern_grass")));
    }

    protected void wideGrow(WorldGenLevel world, BlockPos pos, BlockState state, int width, int offset) {
        this.wideGrow(world, pos, state, width, offset, false);
    }

    protected void wideGrow(WorldGenLevel world, BlockPos pos, BlockState state, int width, int offset, boolean replace) {
        this.setBlock(world, pos.m_7918_(width + 1, 0, offset), state, replace);
        this.setBlock(world, pos.m_7918_(-width, 0, 1 - offset), state, replace);
        this.setBlock(world, pos.m_7918_(offset, 0, -width), state, replace);
        this.setBlock(world, pos.m_7918_(1 - offset, 0, width + 1), state, replace);
    }

    protected void wideGrow(WorldGenLevel world, BlockPos pos, BlockState state, int maxY, int width, int offset) {
        this.wideGrow(world, pos, state, maxY, width, offset, false);
    }

    protected void wideGrow(WorldGenLevel world, BlockPos pos, BlockState state, int maxY, int width, int offset, boolean replace) {
        for (int minY = 0; minY <= maxY; ++minY) {
            this.setBlock(world, pos.m_7918_(width + 1, minY, offset), state, replace);
            this.setBlock(world, pos.m_7918_(-width, minY, 1 - offset), state, replace);
            this.setBlock(world, pos.m_7918_(offset, minY, -width), state, replace);
            this.setBlock(world, pos.m_7918_(1 - offset, minY, width + 1), state, replace);
        }
    }

    @Override
    public boolean place(TreeConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        if (this.canBeHere(level, random, pos, config)) {
            int extraHeight;
            int treeHeight;
            int treeType = random.m_188503_(10);
            int width = 1;
            switch (treeType) {
                case 0: {
                    treeHeight = 2 + random.m_188503_(12);
                    extraHeight = treeHeight + 2;
                    break;
                }
                case 1: 
                case 2: {
                    treeHeight = 3 + random.m_188503_(6);
                    extraHeight = treeHeight + 3;
                    break;
                }
                case 3: 
                case 4: {
                    treeHeight = 4 + random.m_188503_(9);
                    extraHeight = treeHeight + 2;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    width = 2;
                    treeHeight = 15 + random.m_188503_(20);
                    extraHeight = treeHeight + 2;
                    break;
                }
                case 8: {
                    treeHeight = 13 + random.m_188503_(8);
                    extraHeight = treeHeight + 1;
                    break;
                }
                default: {
                    return super.place(config, level, chunkGen, random, pos);
                }
            }
            if (this.heightCheck(level, pos, treeHeight, width)) {
                BlockState log = config.log;
                BlockState leaves = config.leaves;
                int tempInt = extraHeight - 1 - treeHeight;
                this.grow(level, pos, log, treeHeight);
                this.grow(level, pos.m_7918_(0, treeHeight + 1, 0), leaves, tempInt);
                if (width == 2) {
                    int n;
                    BlockPos.MutableBlockPos mut = pos.m_7918_(1, 0, 0).m_122032_();
                    for (n = 0; n < 4 && this.hasSpace(level.m_8055_((BlockPos)mut.m_122184_(0, -1, 0))); ++n) {
                        this.setBlock(level, (BlockPos)mut, log, true);
                    }
                    this.grow(level, pos.m_7918_(1, 0, 0), log, treeHeight);
                    this.grow(level, pos.m_7918_(1, treeHeight + 1, 0), leaves, tempInt);
                    mut = pos.m_7918_(0, 0, 1).m_122032_();
                    for (n = 0; n < 4 && this.hasSpace(level.m_8055_((BlockPos)mut.m_122184_(0, -1, 0))); ++n) {
                        this.setBlock(level, (BlockPos)mut, log, true);
                    }
                    this.grow(level, pos.m_7918_(0, 0, 1), log, treeHeight);
                    this.grow(level, pos.m_7918_(0, treeHeight + 1, 1), leaves, tempInt);
                    mut = pos.m_7918_(1, 0, 1).m_122032_();
                    for (n = 0; n < 4 && this.hasSpace(level.m_8055_((BlockPos)mut.m_122184_(0, -1, 0))); ++n) {
                        this.setBlock(level, (BlockPos)mut, log, true);
                    }
                    this.grow(level, pos.m_7918_(1, 0, 1), log, treeHeight);
                    this.grow(level, pos.m_7918_(1, treeHeight + 1, 1), leaves, tempInt);
                }
                switch (treeType) {
                    case 0: {
                        this.grow(level, pos.m_7918_(0, treeHeight - 1, 0), leaves, 2, 1, 0);
                        break;
                    }
                    case 1: 
                    case 2: {
                        int bottomHeight = random.m_188503_(2);
                        int wideHeight = 2 - bottomHeight + random.m_188503_(2);
                        boolean shift = random.m_188499_();
                        boolean even = treeHeight % 2 == bottomHeight ^ shift;
                        for (int y = 2 - bottomHeight; y <= treeHeight; ++y) {
                            BlockPos temp;
                            if (y == wideHeight && treeType == 2 && wideHeight != extraHeight - 3) {
                                temp = pos.m_7918_(0, y, 0);
                                this.grow(level, temp, leaves, 1, 1);
                                this.grow(level, temp, leaves, 2, -1);
                                this.grow(level, temp, leaves, 2, 0);
                                this.grow(level, temp, leaves, 2, 1);
                                this.grow(level, temp, leaves, 2, 2);
                                for (int offset = -2; offset < 3; ++offset) {
                                    this.grow(level, temp, leaves, 3, offset);
                                }
                                if (!(y % 2 == bottomHeight ^ shift)) continue;
                                shift = !shift;
                                continue;
                            }
                            if (!(y % 2 == bottomHeight ^ shift)) continue;
                            temp = pos.m_7918_(0, y, 0);
                            this.grow(level, temp, leaves, 1, 1);
                            this.grow(level, temp, leaves, 2, -1);
                            this.grow(level, temp, leaves, 2, 0);
                            this.grow(level, temp, leaves, 2, 1);
                        }
                        this.grow(level, pos.m_7918_(0, treeHeight, 0), log, random.m_188503_(even ? 2 : 3));
                        this.grow(level, pos.m_7918_(0, 2 - bottomHeight, 0), leaves, treeHeight - (even ? 1 : 2) + bottomHeight, 1, 0);
                        this.grow(level, pos.m_7918_(0, extraHeight - (even ? 0 : 1), 0), leaves, 1, 0);
                        break;
                    }
                    case 3: {
                        this.grow(level, pos.m_7918_(0, treeHeight - (width += random.m_188503_(2)), 0), leaves, width + 1, 1, 0);
                        this.grow(level, pos.m_7918_(0, treeHeight - width + 1, 0), leaves, width - 1, 1, 1);
                        for (int offset = -1; offset < 2; ++offset) {
                            this.grow(level, pos.m_7918_(0, treeHeight - width + 1, 0), leaves, width - 1, 2, offset);
                        }
                        break;
                    }
                    case 4: {
                        this.grow(level, pos.m_7918_(0, treeHeight - 2, 0), leaves, 3, 1, 0);
                        this.grow(level, pos.m_7918_(0, treeHeight - 2, 0), leaves, 2, 1, 1);
                        for (width = -2; width < 3; ++width) {
                            if (Math.abs(width) < 2) {
                                this.grow(level, pos.m_7918_(0, treeHeight - 2, 0), leaves, 2, 2, width);
                            }
                            this.grow(level, pos.m_7918_(0, treeHeight - 1, 0), leaves, 3, width);
                        }
                        this.grow(level, pos.m_7918_(0, treeHeight - 1, 0), leaves, 2, 2);
                        break;
                    }
                    case 5: {
                        width = treeHeight - 3 - random.m_188503_(3);
                        BlockPos temp = pos.m_7918_(0, width, 0);
                        tempInt = treeHeight - width;
                        this.wideGrow(level, temp, leaves, tempInt, 1, 0);
                        this.wideGrow(level, temp, leaves, tempInt, 1, 1);
                        extraHeight = treeHeight - 2 - width;
                        this.wideGrow(level, temp, leaves, extraHeight, 1, -1);
                        this.wideGrow(level, temp, leaves, extraHeight, 2, 0);
                        this.wideGrow(level, temp, leaves, extraHeight, 2, 1);
                        this.wideGrow(level, temp, leaves, extraHeight -= 2, 2, -1);
                        this.wideGrow(level, temp, leaves, extraHeight, 2, 2);
                        this.wideGrow(level, temp, leaves, extraHeight, 3, 0);
                        this.wideGrow(level, temp, leaves, extraHeight, 3, 1);
                        break;
                    }
                    case 6: {
                        width = treeHeight - 15;
                        BlockPos temp = pos.m_7918_(0, treeHeight, 0);
                        this.wideGrow(level, temp, leaves, 1, 0);
                        this.wideGrow(level, temp, leaves, 1, 1);
                        extraHeight = treeHeight - 3;
                        tempInt = extraHeight - width;
                        temp = pos.m_7918_(0, width, 0);
                        this.wideGrow(level, temp, leaves, tempInt, 1, 0);
                        this.wideGrow(level, temp, leaves, tempInt, 1, 1);
                        --extraHeight;
                        while (extraHeight > treeHeight - 8) {
                            temp = pos.m_7918_(0, extraHeight, 0);
                            this.wideGrow(level, temp, leaves, 1, -1);
                            this.wideGrow(level, temp, leaves, 2, 0);
                            this.wideGrow(level, temp, leaves, 2, 1);
                            extraHeight -= 2;
                        }
                        temp = pos.m_7918_(0, width, 0);
                        this.wideGrow(level, temp, leaves, extraHeight - width, 1, -1);
                        this.wideGrow(level, temp, leaves, extraHeight - width, 2, 0);
                        this.wideGrow(level, temp, leaves, extraHeight - width, 2, 1);
                        while (extraHeight > treeHeight - 11) {
                            temp = pos.m_7918_(0, extraHeight, 0);
                            this.wideGrow(level, temp, leaves, 2, -2);
                            this.wideGrow(level, temp, leaves, 2, -1);
                            this.wideGrow(level, temp, leaves, 2, 2);
                            this.wideGrow(level, temp, leaves, 2, 3);
                            this.wideGrow(level, temp, leaves, 3, 0);
                            this.wideGrow(level, temp, leaves, 3, 1);
                            extraHeight -= 2;
                        }
                        extraHeight = width + 2;
                        temp = pos.m_7918_(0, width, 0);
                        this.wideGrow(level, temp, leaves, 2, 2, -2);
                        this.wideGrow(level, temp, leaves, 2, 2, -1);
                        this.wideGrow(level, temp, leaves, 2, 2, 2);
                        this.wideGrow(level, temp, leaves, 2, 2, 3);
                        this.wideGrow(level, temp, leaves, 2, 3, 0);
                        this.wideGrow(level, temp, leaves, 2, 3, 1);
                        temp = temp.m_7494_();
                        this.wideGrow(level, temp, leaves, 3, -2);
                        this.wideGrow(level, temp, leaves, 3, -1);
                        this.wideGrow(level, temp, leaves, 3, 2);
                        this.wideGrow(level, temp, leaves, 3, 3);
                        this.wideGrow(level, temp, leaves, 4, 0);
                        this.wideGrow(level, temp, leaves, 4, 1);
                        break;
                    }
                    case 7: {
                        BlockPos temp = pos.m_7918_(0, treeHeight - 2, 0);
                        this.wideGrow(level, temp, leaves, 2, 1, 0);
                        this.wideGrow(level, temp, leaves, 2, 1, 1);
                        this.wideGrow(level, temp, leaves, 2, 1, -1);
                        this.wideGrow(level, temp, leaves, 2, 2, 0);
                        this.wideGrow(level, temp, leaves, 2, 2, 1);
                        this.wideGrow(level, temp, leaves, 2, 2);
                        this.wideGrow(level, temp, leaves, 2, -1);
                        this.wideGrow(level, temp, leaves, 2, -2);
                        this.wideGrow(level, temp, leaves, 3, 0);
                        this.wideGrow(level, temp, leaves, 3, 1);
                        break;
                    }
                    case 8: {
                        this.grow(level, pos.m_7918_(0, treeHeight - 10, 0), log, 1, 1, 0);
                        this.grow(level, pos.m_7918_(0, treeHeight - 8, 0), leaves, 1, 1, 0);
                        this.grow(level, pos.m_7918_(0, treeHeight - 6, 0), log, 1, 1, 0);
                        this.grow(level, pos.m_7918_(0, treeHeight, 0), leaves, 1, 0);
                        BlockPos temp = pos.m_7918_(0, treeHeight - 4, 0);
                        this.grow(level, temp, leaves, 2, 1, 0);
                        this.grow(level, temp, log, 2, 0);
                        this.grow(level, temp, leaves, 2, 1);
                        this.grow(level, temp, leaves, 2, -1);
                        this.grow(level, temp, leaves, 3, 0);
                        temp = pos.m_7918_(0, treeHeight - 8, 0);
                        this.grow(level, temp, log, 2, 0);
                        this.grow(level, temp, log, 1, 1);
                        temp = temp.m_7494_();
                        this.grow(level, temp, leaves, 4, 1, 1);
                        this.grow(level, temp, leaves, 4, 2, 0);
                        this.grow(level, temp, leaves, 1, 2, 1);
                        this.grow(level, temp, leaves, 1, 2, -1);
                        this.grow(level, temp, log, 2, 2);
                        this.grow(level, temp, log, 3, 0);
                        this.grow(level, temp, log, 3, 3);
                        this.grow(level, temp, leaves, 3, -2);
                        this.grow(level, temp, leaves, 3, -1);
                        this.grow(level, temp, leaves, 3, 1);
                        this.grow(level, temp, leaves, 3, 2);
                        this.grow(level, temp, log, 4, 0);
                        this.grow(level, temp, leaves, 4, -3);
                        this.grow(level, temp, leaves, 4, -1);
                        this.grow(level, temp, leaves, 4, 1);
                        this.grow(level, temp, leaves, 4, 3);
                        this.grow(level, temp, leaves, 5, 0);
                        temp = temp.m_7494_();
                        this.grow(level, temp, leaves, 4, 0);
                        this.grow(level, temp, leaves, 3, 3);
                        this.grow(level, temp, leaves, 3, 0);
                        this.grow(level, temp, leaves, 2, 2);
                    }
                }
                return true;
            }
        }
        return false;
    }
}

