/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import divinerpg.registries.StructureRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public final class LowestCeilingType
extends Structure {
    public static final Codec<LowestCeilingType> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LowestCeilingType.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.fieldOf("min_height").forGetter(structure -> structure.minHeight), (App)Codec.INT.fieldOf("max_height").forGetter(structure -> structure.maxHeight), (App)Codec.INT.fieldOf("bury").forGetter(structure -> structure.bury), (App)Codec.STRING.optionalFieldOf("mode", (Object)"full").forGetter(structure -> structure.mode), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, LowestCeilingType::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final String mode;
    private final int size;
    private final int minHeight;
    private final int maxHeight;
    private final int bury;
    private final int maxDistanceFromCenter;

    public LowestCeilingType(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, int minHeight, int maxHeight, int bury, String mode, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.bury = bury;
        this.mode = mode;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        int y;
        WorldgenRandom worldgenrandom = context.f_226626_();
        int x = context.f_226628_().m_45604_() + worldgenrandom.m_188503_(16);
        int z = context.f_226628_().m_45605_() + worldgenrandom.m_188503_(16);
        NoiseColumn column = context.f_226622_().m_214184_(x, z, context.f_226629_(), context.f_226624_());
        int maxY = this.mode.equals("random_section") ? context.f_226626_().m_216339_(this.minHeight, this.maxHeight + 1) : this.maxHeight;
        int n = y = this.mode.equals("full") ? this.minHeight : context.f_226626_().m_216339_(this.minHeight, maxY + 1);
        if (!column.m_183556_(y).m_60795_()) {
            while (++y < maxY + 2 && !column.m_183556_(y).m_60795_()) {
            }
        }
        while (y < maxY + 2 && column.m_183556_(y).m_60795_()) {
            ++y;
        }
        if (y > maxY) {
            return Optional.empty();
        }
        Optional structurePiecesGenerator = JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)new BlockPos(x, y += this.bury - 1, z), (boolean)false, Optional.empty(), (int)this.maxDistanceFromCenter);
        return structurePiecesGenerator;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)StructureRegistry.LOWEST_CEILING.get();
    }
}

