/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.skillissue.forge.api.attributes;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PlayerModifierMap {
    private Map<UUID, Map<AttributeInstance, Map<AttributeModifier.Operation, AttributeModifier>>> playerModifiers = new HashMap<UUID, Map<AttributeInstance, Map<AttributeModifier.Operation, AttributeModifier>>>();

    public ModifierAccess get(Player player, Attribute attribute) {
        return new ModifierAccess(player, attribute);
    }

    public void dispose(Player player) {
        this.playerModifiers.remove(player.m_20148_());
    }

    public class ModifierAccess {
        private Player player;
        private AttributeInstance attribute;

        protected ModifierAccess(@NonNull Player player, Attribute attribute) {
            this.player = player;
            this.attribute = player.m_21051_(attribute);
        }

        public void setFactor(double value) {
            this.apply(value - 1.0, AttributeModifier.Operation.MULTIPLY_BASE);
        }

        public void setBonus(double value) {
            this.apply(value, AttributeModifier.Operation.ADDITION);
        }

        public void apply(double value, AttributeModifier.Operation op) {
            AttributeModifier modifier;
            Map<AttributeModifier.Operation, AttributeModifier> operations;
            Map<AttributeInstance, Map<AttributeModifier.Operation, AttributeModifier>> modifiers = PlayerModifierMap.this.playerModifiers.get(this.player.m_20148_());
            if (modifiers == null) {
                modifiers = new HashMap<AttributeInstance, Map<AttributeModifier.Operation, AttributeModifier>>();
                PlayerModifierMap.this.playerModifiers.put(this.player.m_20148_(), modifiers);
            }
            if ((operations = modifiers.get(this.attribute)) == null) {
                operations = new HashMap<AttributeModifier.Operation, AttributeModifier>();
                modifiers.put(this.attribute, operations);
            }
            if ((modifier = operations.get(op)) != null) {
                this.attribute.m_22130_(modifier);
            }
            modifier = new AttributeModifier("skillissue", value, op);
            operations.put(op, modifier);
            this.attribute.m_22118_(modifier);
        }
    }
}

