/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.skillissue.forge.api.milestones;

import com.mojang.brigadier.ParseResults;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;

public class Milestone
implements Comparable<Milestone> {
    public final List<ParseResults<CommandSourceStack>> commands;
    public final char commandsType;
    public final boolean isVolatile;
    public final int level;

    public Milestone(int level, List<ParseResults<CommandSourceStack>> commands, char commandsType, boolean isVolatile) {
        this.commandsType = commandsType;
        this.commands = commands;
        this.isVolatile = isVolatile;
        this.level = level;
    }

    @Override
    public int compareTo(Milestone other) {
        return Integer.compare(this.level, other.level);
    }

    public static Milestone dummy(int level) {
        return new Milestone(level, null, '\u0000', false);
    }

    public static class CommandType {
        public static final char ANY = '\uffff';
        public static final char LEVEL_UP = '\u0001';
        public static final char RESPAWN = '\u0002';
        public static final char LOGIN = '\u0004';
    }
}

