/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.skillissue.forge.api.milestones;

import com.gitlab.srcmc.skillissue.ModCommon;
import com.gitlab.srcmc.skillissue.forge.ModForge;
import com.gitlab.srcmc.skillissue.forge.api.attributes.AttributeModification;
import com.gitlab.srcmc.skillissue.forge.api.milestones.Milestone;
import com.gitlab.srcmc.skillissue.forge.capabilities.IPlayerLevelCapability;
import com.gitlab.srcmc.skillissue.forge.collections.RangeList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public final class Milestones {
    private Milestones() {
    }

    public static void updateAttributes(Player player) {
        if (!player.m_9236_().f_46443_) {
            int playerLevel = IPlayerLevelCapability.getMaxPlayerLevel(player);
            for (AttributeModification attMod : ModForge.COMMON_CONFIG.getAttributeModifications()) {
                attMod.apply(player, playerLevel);
            }
            player.m_21153_(player.m_21223_());
        }
    }

    public static void updateRewards(Player player) {
        Milestones.updateRewards(player, 0);
    }

    public static void updateRewards(Player player, int startLevel) {
        Milestones.updateRewards(player, startLevel, '\uffff');
    }

    public static void updateRewards(Player player, int startLevel, char commandTypeFlag) {
        Milestones.updateMilestones(ModForge.COMMON_CONFIG.getMilestoneRewards(player.m_20148_()), player, startLevel, commandTypeFlag);
    }

    public static void updatePenalties(Player player) {
        Milestones.updatePenalties(player, 0);
    }

    public static void updatePenalties(Player player, int startLevel) {
        Milestones.updatePenalties(player, startLevel, '\uffff');
    }

    public static void updatePenalties(Player player, int startLevel, char commandTypeFlag) {
        Milestones.updateMilestones(ModForge.COMMON_CONFIG.getMilestonePenalties(player.m_20148_()), player, startLevel, commandTypeFlag);
    }

    private static void updateMilestones(RangeList<Milestone> milestones, Player player, int startLevel, char commandTypeFlag) {
        if (!player.m_9236_().f_46443_) {
            int playerLevel = IPlayerLevelCapability.getMaxPlayerLevel(player);
            milestones.subList(Milestone.dummy(startLevel), Milestone.dummy(playerLevel + 1)).stream().filter(milestone -> (milestone.commandsType & commandTypeFlag) != 0 && (milestone.level == playerLevel || milestone.isVolatile)).forEach(milestone -> milestone.commands.forEach(command -> {
                try {
                    player.m_20194_().m_129892_().m_82094_().execute(command);
                }
                catch (CommandSyntaxException e) {
                    player.m_20203_().m_81352_((Component)Component.m_237113_((String)e.getMessage()));
                    ModCommon.LOG.error(e.getMessage(), (Throwable)e);
                }
            }));
        }
    }
}

