/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.skillissue.forge.api.world;

import com.gitlab.srcmc.skillissue.forge.ModForge;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.world.level.ChunkPos;

public class ChunkXpPoolMap {
    private final Map<ChunkPos, XpPool> chunkXpPools = new HashMap<ChunkPos, XpPool>();

    public void regenXpPools() {
        Iterator<ChunkPos> it = this.chunkXpPools.keySet().iterator();
        while (it.hasNext()) {
            ChunkPos chunkPos = it.next();
            XpPool xpPool = this.chunkXpPools.get(chunkPos);
            xpPool.value -= ModForge.COMMON_CONFIG.getChunkXpRegenPerTick();
            if (xpPool.value > 0) continue;
            it.remove();
        }
    }

    public void addXpToPools(ChunkPos chunkPos, int xpValue) {
        xpValue = (int)((double)xpValue * ModForge.COMMON_CONFIG.getChunkXpScale());
        for (int z = -1; z < 2; ++z) {
            for (int x = -1; x < 2; ++x) {
                ChunkPos offsetChunkPos = new ChunkPos(chunkPos.f_45578_ + x, chunkPos.f_45579_ + z);
                XpPool xpPool = this.chunkXpPools.get(offsetChunkPos);
                if (xpPool == null) {
                    this.chunkXpPools.put(offsetChunkPos, new XpPool(xpValue));
                    continue;
                }
                xpPool.value += xpValue;
            }
        }
    }

    public int getXpPool(ChunkPos chunkPos) {
        XpPool xpPool = this.chunkXpPools.get(chunkPos);
        return xpPool != null ? xpPool.value : 0;
    }

    public void setXpPool(ChunkPos chunkPos, int value) {
        XpPool xpPool = this.chunkXpPools.get(chunkPos);
        if (xpPool == null) {
            this.chunkXpPools.put(chunkPos, new XpPool(value));
        } else {
            xpPool.value = value;
        }
    }

    private class XpPool {
        public int value;

        public XpPool(int value) {
            this.value = value;
        }
    }
}

