/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.skillissue.forge.capabilities;

import com.gitlab.srcmc.skillissue.forge.ModCapabilities;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;

@AutoRegisterCapability
public interface IPlayerLevelCapability {
    public int getMaxLevel();

    public void setMaxLevel(int var1);

    public boolean updateMaxLevel(int var1);

    public static int getMaxPlayerLevel(Player player) {
        IPlayerLevelCapability cap = (IPlayerLevelCapability)player.getCapability(ModCapabilities.LEVEL).orElseGet(null);
        return cap != null ? cap.getMaxLevel() : 0;
    }

    public static void setMaxPlayerLevel(Player player, int level) {
        player.getCapability(ModCapabilities.LEVEL).ifPresent(cap -> cap.setMaxLevel(level));
    }

    public static boolean updateMaxPlayerLevel(Player player, int level) {
        IPlayerLevelCapability cap = (IPlayerLevelCapability)player.getCapability(ModCapabilities.LEVEL).orElseGet(null);
        if (cap != null && level > cap.getMaxLevel()) {
            cap.setMaxLevel(level);
            return true;
        }
        return false;
    }
}

