/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.skillissue.forge.collections;

import java.util.ArrayList;
import java.util.List;

public class RangeList<E extends Comparable<? super E>>
extends ArrayList<E> {
    public List<E> subList(E fromElement, E toElement) {
        return this.subList(0, this.size() - 1, this.size() / 2, fromElement, toElement);
    }

    private List<E> subList(int left, int right, int step, E fromElement, E toElement) {
        int size = this.size();
        if (step == 0) {
            if (left < 0) {
                left = 0;
            } else {
                while (left > 0 && fromElement.compareTo(this.get(left)) <= 0) {
                    --left;
                }
                while (left < size && fromElement.compareTo(this.get(left)) > 0) {
                    ++left;
                }
            }
            if (right >= size) {
                right = size - 1;
            } else {
                while (right < size - 1 && toElement.compareTo(this.get(right)) >= 0) {
                    ++right;
                }
            }
            while (right >= 0 && toElement.compareTo(this.get(right)) <= 0) {
                --right;
            }
            return super.subList(left, right + 1);
        }
        if (left >= 0) {
            left = fromElement.compareTo(this.get(left)) > 0 ? (left += step) : (left -= step);
        }
        if (right < size) {
            right = toElement.compareTo(this.get(right)) < 0 ? (right -= step) : (right += step);
        }
        return left < 0 && right >= size ? super.subList(0, size) : this.subList(left, right, step / 2, fromElement, toElement);
    }
}

