/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.skillissue.forge.config;

import com.gitlab.srcmc.skillissue.ModCommon;
import com.gitlab.srcmc.skillissue.forge.api.attributes.AttributeModification;
import com.gitlab.srcmc.skillissue.forge.api.milestones.Milestone;
import com.gitlab.srcmc.skillissue.forge.collections.RangeList;
import com.gitlab.srcmc.skillissue.forge.config.ConfigBase;
import com.gitlab.srcmc.skillissue.forge.config.models.AttributeModificationsModel;
import com.gitlab.srcmc.skillissue.forge.config.models.IModelWithArgs;
import com.gitlab.srcmc.skillissue.forge.config.models.MilestonePenaltiesModel;
import com.gitlab.srcmc.skillissue.forge.config.models.MilestoneRewardsModel;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLPaths;

public class CommonConfig
extends ConfigBase {
    private final ForgeConfigSpec.ConfigValue<Integer> maxPlayerLevelValue;
    private final ForgeConfigSpec.ConfigValue<Double> deathPenaltyLevelFactorValue;
    private final ForgeConfigSpec.ConfigValue<Integer> chunkXpThresholdValue;
    private final ForgeConfigSpec.ConfigValue<Integer> chunkXpRegerPerTickValue;
    private final ForgeConfigSpec.ConfigValue<Double> chunkXpScale;
    private final ForgeConfigSpec.ConfigValue<Double> chunkXpPenaltyFactorValue;
    private final ForgeConfigSpec spec;
    private final Map<UUID, RangeList<Milestone>> milestoneRewards = new HashMap<UUID, RangeList<Milestone>>();
    private final Map<UUID, RangeList<Milestone>> milestonePenalties = new HashMap<UUID, RangeList<Milestone>>();
    private final List<AttributeModification> attributeModifications = new ArrayList<AttributeModification>();
    private MilestoneRewardsModel milestoneRewardsModel;
    private MilestonePenaltiesModel milestonePenaltiesModel;
    private AttributeModificationsModel attributeModificationsModel;

    public CommonConfig() {
        this(new ForgeConfigSpec.Builder());
    }

    public CommonConfig(ForgeConfigSpec.Builder builder) {
        super(ModConfig.Type.COMMON);
        builder.push("Player Levels");
        this.maxPlayerLevelValue = builder.comment("The maximum level for a player to gain benefits from 'attribute_modifications'.").defineInRange("max_player_level", 140, 1, Integer.MAX_VALUE);
        this.deathPenaltyLevelFactorValue = builder.comment("This factor is applied to a players level upon death. All 'attribute_modifications' up to the new level remain. Additionally 'milestone_penalties' are applied for the lost levels.").defineInRange("death_penalty_factor", 0.8, 0.0, 1.0);
        builder.pop();
        builder.push("Chunk Xp");
        this.chunkXpThresholdValue = builder.comment("This value determines the max 'scaled exp' that can be picked up in an area (3x3 chunks) before the effect of the 'chunk_xp_penalty_factor' is fully applied. This value also affects the time it takes before a chunk has fully recorvered from the penalty.").defineInRange("chunk_xp_threshold", 48000, 1, Integer.MAX_VALUE);
        this.chunkXpRegerPerTickValue = builder.comment("This value determines the speed per tick at which a chunk regenerates from its accumulated xp.").defineInRange("chunk_xp_regen_per_tick", 1, 1, Integer.MAX_VALUE);
        this.chunkXpScale = builder.comment("This factor is applied to any xp picked up by players before beeing added to a chunks xp pool. This value affects the time it takes before a chunk has reached its xp threshold. Setting this to 0 will completely disable all chunk xp features.").defineInRange("chunk_xp_scale", 20.0, 0.0, Double.MAX_VALUE);
        this.chunkXpPenaltyFactorValue = builder.comment("This value determines the minimum factor that can be applied to any xp picked up by a player. The factor linearly shrinks from 1 towards this value based of the xp pool in the players chunk in relation to the 'chunk_xp_threshold'.").defineInRange("chunk_xp_penalty_factor", 0.2, 0.0, 1.0);
        this.spec = builder.build();
    }

    public int getMaxPlayerLevel() {
        return (Integer)this.maxPlayerLevelValue.get();
    }

    public double getDeathPenaltyLevelFactor() {
        return (Double)this.deathPenaltyLevelFactorValue.get();
    }

    public RangeList<Milestone> getMilestoneRewards(UUID uuid) {
        RangeList list = this.milestoneRewards.get(uuid);
        return list != null ? list : new RangeList();
    }

    public RangeList<Milestone> getMilestonePenalties(UUID uuid) {
        RangeList list = this.milestonePenalties.get(uuid);
        return list != null ? list : new RangeList();
    }

    public Iterable<AttributeModification> getAttributeModifications() {
        return this.attributeModifications;
    }

    public int getChunkXpThreshold() {
        return (Integer)this.chunkXpThresholdValue.get();
    }

    public int getChunkXpRegenPerTick() {
        return (Integer)this.chunkXpRegerPerTickValue.get();
    }

    public double getChunkXpScale() {
        return (Double)this.chunkXpScale.get();
    }

    public double getChunkXpPenaltyFactor() {
        return (Double)this.chunkXpPenaltyFactorValue.get();
    }

    @Override
    protected ForgeConfigSpec getSpec() {
        return this.spec;
    }

    @Override
    protected void onConfigReload(ModConfigEvent event) {
        this.loadJsonConfigs();
    }

    @Override
    protected void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.milestoneRewardsModel != null) {
            this.milestoneRewardsModel.mapToEntity(this.milestoneRewards, event.getEntity());
        }
        if (this.milestonePenaltiesModel != null) {
            this.milestonePenaltiesModel.mapToEntity(this.milestonePenalties, event.getEntity());
        }
        if (this.attributeModificationsModel != null) {
            this.attributeModificationsModel.mapToEntity(this.attributeModifications);
        }
    }

    @Override
    protected void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        this.milestoneRewards.remove(event.getEntity().m_20148_());
        this.milestonePenalties.remove(event.getEntity().m_20148_());
    }

    private static <Model extends IModelWithArgs<T, Args>, T, Args> Model loadModel(String modelFilePath, Class<Model> clazz) {
        IModelWithArgs model;
        block16: {
            String configDirPath = FMLPaths.CONFIGDIR.get().toString() + File.separatorChar + "skillissue";
            model = null;
            File modelFile = new File(configDirPath + File.separatorChar + modelFilePath);
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            try (FileReader fr = new FileReader(modelFile);){
                model = (IModelWithArgs)gson.fromJson((Reader)fr, clazz);
            }
            catch (JsonParseException | IOException e1) {
                ModCommon.LOG.warn("Failed to load config from '" + modelFile + "': Running with default config");
                try {
                    model = (IModelWithArgs)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!(e1 instanceof FileNotFoundException)) break block16;
                    try (FileWriter fw = new FileWriter(modelFile);){
                        gson.toJson((Object)model, clazz, gson.newJsonWriter((Writer)fw));
                    }
                    catch (JsonIOException | IOException e2) {
                        ModCommon.LOG.warn("Failed to create default config at '" + modelFile + "'");
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e3) {
                    ModCommon.LOG.error("Could not instantiate '" + clazz.getName() + "': Please contact mod author", (Throwable)e3);
                }
            }
        }
        return (Model)model;
    }

    private void loadJsonConfigs() {
        new File(FMLPaths.CONFIGDIR.get().toString() + File.separatorChar + "skillissue").mkdirs();
        this.milestoneRewardsModel = CommonConfig.loadModel("rewards.json", MilestoneRewardsModel.class);
        this.milestonePenaltiesModel = CommonConfig.loadModel("penalties.json", MilestonePenaltiesModel.class);
        this.attributeModificationsModel = CommonConfig.loadModel("attributes.json", AttributeModificationsModel.class);
        ModCommon.LOG.info("Loaded json configs");
    }
}

