/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.skillissue.forge.config;

import com.gitlab.srcmc.skillissue.forge.ModForge;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public abstract class ConfigBase {
    private ModConfig.Type configType;

    protected abstract void onConfigReload(ModConfigEvent var1);

    protected abstract void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent var1);

    protected abstract void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent var1);

    protected abstract ForgeConfigSpec getSpec();

    public ConfigBase(ModConfig.Type configType) {
        this.configType = configType;
    }

    public void register(ModForge mod) {
        ModLoadingContext.get().registerConfig(this.configType, (IConfigSpec)this.getSpec());
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        modBus.addListener(this::onConfigReload);
        forgeBus.addListener(this::onPlayerLogin);
        forgeBus.addListener(this::onPlayerLogout);
    }
}

