/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.skillissue.forge.config.models;

import com.gitlab.srcmc.skillissue.ModCommon;
import com.gitlab.srcmc.skillissue.forge.api.attributes.AttributeModification;
import com.gitlab.srcmc.skillissue.forge.config.models.IModel;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class AttributeModificationsModel
implements IModel<List<AttributeModification>> {
    protected List<Attribute> attributes = List.of(new Attribute("generic.max_health", 0.0, 0.8, 2.0), new Attribute("generic.armor_toughness", 3.0, 0.0, 1.0), new Attribute("generic.knockback_resistance", 0.25, 0.0, 1.0), new Attribute("generic.movement_speed", 0.0, 0.9, 1.15), new Attribute("generic.attack_damage", 0.0, 0.9, 1.25), new Attribute("generic.attack_speed", 0.0, 0.9, 1.25), new Attribute("generic.attack_knockback", 0.25, 0.0, 1.0));

    @Override
    public void mapToEntity(List<AttributeModification> entity) {
        entity.clear();
        for (Attribute model : this.attributes) {
            net.minecraft.world.entity.ai.attributes.Attribute attribute = (net.minecraft.world.entity.ai.attributes.Attribute)ForgeRegistries.ATTRIBUTES.getValue(AttributeModificationsModel.getLocation(model.key));
            if (attribute != null) {
                entity.add(new AttributeModification(attribute, model.bonus, model.min_factor, model.max_factor));
                continue;
            }
            ModCommon.LOG.error("Invalid attribute key: " + model.key);
        }
    }

    private static ResourceLocation getLocation(String attributeKey) {
        String path;
        String modid;
        String[] location = attributeKey.split(":", 2);
        if (location.length == 2) {
            modid = location[0];
            path = location[1];
        } else {
            modid = "minecraft";
            path = location[0];
        }
        return new ResourceLocation(modid, path);
    }

    protected static class Attribute {
        public final String key;
        public final double bonus;
        public final double min_factor;
        public final double max_factor;

        public Attribute(String key, double bonus, double min_factor, double max_factor) {
            this.key = key;
            this.bonus = bonus;
            this.min_factor = min_factor;
            this.max_factor = max_factor;
        }
    }
}

