/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.skillissue.forge.config.models;

import com.gitlab.srcmc.skillissue.ModCommon;
import com.gitlab.srcmc.skillissue.forge.api.milestones.Milestone;
import com.gitlab.srcmc.skillissue.forge.collections.RangeList;
import com.gitlab.srcmc.skillissue.forge.config.models.IModelWithArgs;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.player.Player;

public class MilestoneModel
implements IModelWithArgs<RangeList<Milestone>, Args> {
    public final int level;
    public final int level_step;
    public final int level_range;
    public final boolean on_level_up;
    public final boolean on_respawn;
    public final boolean on_login;
    public final boolean is_volatile;
    public final String level_inject;
    public final String[] commands;

    public MilestoneModel() {
        this(0, 1, 1, true, false, false, false, "", new String[0]);
    }

    public MilestoneModel(int level, int level_step, int level_range, boolean on_level_up, boolean on_respawn, boolean on_login, boolean is_volatile, String level_inject, String ... commands) {
        this.level = level;
        this.level_step = level_step;
        this.level_range = level_range;
        this.on_level_up = on_level_up;
        this.on_respawn = on_respawn;
        this.on_login = on_login;
        this.is_volatile = is_volatile;
        this.level_inject = level_inject;
        this.commands = commands;
    }

    @Override
    public void mapToEntity(RangeList<Milestone> entity, Args args) {
        int level_step = this.level_step > 0 ? this.level_step : this.level_range;
        int level_cap = this.level + this.level_range;
        char command_type = (char)((this.on_level_up ? 1 : 0) | (this.on_respawn ? 2 : 0) | (this.on_login ? 4 : 0));
        for (int level = this.level; level < level_cap; level += level_step) {
            ArrayList<ParseResults<CommandSourceStack>> list = new ArrayList<ParseResults<CommandSourceStack>>();
            entity.add(new Milestone(level, list, command_type, this.is_volatile));
            for (String command : this.commands) {
                String literal = this.level_inject != null && !this.level_inject.isBlank() ? command.replace(this.level_inject, String.valueOf(level)) : command;
                ParseResults parseResults = args.dispatcher.parse(literal, (Object)args.player.m_20203_().m_81324_().m_81325_(4));
                if (parseResults.getReader().canRead()) {
                    ModCommon.LOG.error("Invalid command: '" + literal + "'");
                    continue;
                }
                list.add((ParseResults<CommandSourceStack>)parseResults);
            }
        }
    }

    public static class Args {
        public final Player player;
        public final CommandDispatcher<CommandSourceStack> dispatcher;

        public Args(Player player, CommandDispatcher<CommandSourceStack> dispatcher) {
            this.player = player;
            this.dispatcher = dispatcher;
        }
    }
}

