/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.skillissue.forge.events;

import com.gitlab.srcmc.skillissue.forge.ModForge;
import com.gitlab.srcmc.skillissue.forge.api.attributes.AttributeModification;
import com.gitlab.srcmc.skillissue.forge.api.milestones.Milestones;
import com.gitlab.srcmc.skillissue.forge.capabilities.IPlayerLevelCapability;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="skillissue", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerHandler {
    @SubscribeEvent
    public static void onPlayerXpLevelChange(PlayerXpEvent.LevelChange event) {
        int playerLevel;
        Player player = event.getEntity();
        if (player.m_6084_() && IPlayerLevelCapability.updateMaxPlayerLevel(player, playerLevel = player.f_36078_ + 1)) {
            PlayerHandler.updateRewards(player, playerLevel - event.getLevels() + 1, '\u0001');
            PlayerHandler.updateAttributes(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerXpPickup(PlayerXpEvent.PickupXp event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            ChunkPos chunkPos = event.getEntity().m_146902_();
            int xpPool = ModForge.CHUNK_XP_POOLS.getXpPool(chunkPos);
            int xpValue = (int)((double)event.getOrb().f_20770_ * (1.0 - (1.0 - ModForge.COMMON_CONFIG.getChunkXpPenaltyFactor()) * (double)xpPool / (double)ModForge.COMMON_CONFIG.getChunkXpThreshold()));
            ModForge.CHUNK_XP_POOLS.addXpToPools(chunkPos, xpValue);
            event.getOrb().f_20770_ = xpValue;
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().reviveCaps();
            int newLevel = (int)((double)IPlayerLevelCapability.getMaxPlayerLevel(event.getOriginal()) * ModForge.COMMON_CONFIG.getDeathPenaltyLevelFactor());
            event.getOriginal().invalidateCaps();
            IPlayerLevelCapability.setMaxPlayerLevel(event.getEntity(), newLevel);
            PlayerHandler.updateRewards(event.getEntity(), 0, '\u0002');
            PlayerHandler.updatePenalties(event.getEntity());
            PlayerHandler.updateAttributes(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerHandler.updateRewards(event.getEntity(), 0, '\u0004');
        PlayerHandler.updateAttributes(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ModForge.PLAYER_MODIFIERS.dispose(event.getEntity());
    }

    private static void updateAttributes(Player player) {
        int playerLevel = IPlayerLevelCapability.getMaxPlayerLevel(player);
        for (AttributeModification attMod : ModForge.COMMON_CONFIG.getAttributeModifications()) {
            attMod.apply(player, playerLevel);
        }
    }

    private static void updateRewards(Player player) {
        PlayerHandler.updateRewards(player, 0);
    }

    private static void updateRewards(Player player, int startLevel) {
        PlayerHandler.updateRewards(player, startLevel, '\uffff');
    }

    private static void updateRewards(Player player, int startLevel, char commandTypeFlag) {
        Milestones.updateRewards(player, startLevel, commandTypeFlag);
    }

    private static void updatePenalties(Player player) {
        PlayerHandler.updatePenalties(player, 0);
    }

    private static void updatePenalties(Player player, int startLevel) {
        PlayerHandler.updatePenalties(player, startLevel, '\uffff');
    }

    private static void updatePenalties(Player player, int startLevel, char commandTypeFlag) {
        Milestones.updatePenalties(player, startLevel, commandTypeFlag);
    }
}

