/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.editor;

import java.util.List;
import javax.annotation.Nullable;
import mrtjp.fengine.TileCoord;
import mrtjp.projectred.fabrication.engine.InterfaceSpec;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class EditorDataUtils {
    public static final String KEY_FORMAT = "format";
    public static final String KEY_ACTIVE = "active";
    public static final String KEY_IC_NAME = "ic_name";
    public static final String KEY_TILE_MAP = "tile_map";
    public static final String KEY_TILE_COUNT = "tile_count";
    public static final String KEY_IS_BUILT = "is_built";
    public static final String KEY_IO_SPEC = "io_spec";
    public static final String KEY_COMP_STATE = "state";
    public static final String KEY_SIM_START_TIME = "sim_start_time";
    public static final String KEY_COMPILE_FORMAT = "compile_format";
    public static final String KEY_FLAT_MAP = "flat_map";
    public static final String KEY_SIMULATION = "sim_cont";
    public static final String KEY_COMPILER_LOG = "compiler_log";
    public static final String KEY_AUTO_COMPILE_ENABLE = "auto_compile_enable";
    public static final String KEY_AUTO_COMPILE_ALLOWED = "auto_compile_allowed";
    public static final String KEY_COMPLETED_STEPS = "completed_steps";
    public static final String KEY_CURRENT_PATH = "current_path";
    public static final String KEY_PROBLEMS_LIST = "problems";
    public static final String KEY_ERROR_COUNT = "error_count";
    public static final String KEY_WARNING_COUNT = "warning_count";

    public static int getFormat(CompoundTag tag) {
        return tag.m_128451_(KEY_FORMAT);
    }

    public static boolean hasEditorData(@Nullable CompoundTag tag) {
        return tag != null && tag.m_128441_(KEY_FORMAT) && tag.m_128441_(KEY_ACTIVE) && tag.m_128441_(KEY_TILE_MAP);
    }

    public static boolean hasFabricationTarget(@Nullable CompoundTag tag) {
        return tag != null && tag.m_128441_(KEY_IS_BUILT) && tag.m_128441_(KEY_FLAT_MAP);
    }

    public static boolean canFabricate(@Nullable CompoundTag tag) {
        return EditorDataUtils.hasFabricationTarget(tag) && EditorDataUtils.isBuilt(tag) && EditorDataUtils.isCompileFormatValid(tag) && EditorDataUtils.getErrorCount(tag) == 0;
    }

    public static boolean isBuilt(CompoundTag tag) {
        return tag.m_128471_(KEY_IS_BUILT);
    }

    public static boolean isCompileFormatValid(CompoundTag tag) {
        return tag.m_128451_(KEY_COMPILE_FORMAT) == 1;
    }

    public static int getErrorCount(CompoundTag tag) {
        return tag.m_128469_(KEY_COMPILER_LOG).m_128451_(KEY_ERROR_COUNT);
    }

    public static int getWarningCount(CompoundTag tag) {
        return tag.m_128469_(KEY_COMPILER_LOG).m_128451_(KEY_WARNING_COUNT);
    }

    public static CompoundTag createFabricationCopy(CompoundTag editorTag) {
        CompoundTag copy = new CompoundTag();
        copy.m_128405_(KEY_COMPILE_FORMAT, editorTag.m_128451_(KEY_COMPILE_FORMAT));
        copy.m_128379_(KEY_IS_BUILT, editorTag.m_128471_(KEY_IS_BUILT));
        copy.m_128359_(KEY_IC_NAME, editorTag.m_128461_(KEY_IC_NAME));
        copy.m_128405_(KEY_TILE_COUNT, editorTag.m_128451_(KEY_TILE_COUNT));
        copy.m_128365_(KEY_IO_SPEC, (Tag)editorTag.m_128469_(KEY_IO_SPEC));
        copy.m_128359_(KEY_FLAT_MAP, editorTag.m_128461_(KEY_FLAT_MAP));
        return copy;
    }

    public static InterfaceSpec getInterfaceSpec(CompoundTag tag) {
        return InterfaceSpec.createFrom(tag, KEY_IO_SPEC);
    }

    public static void saveTileCoord(CompoundTag tag, String key, TileCoord coord) {
        tag.m_128344_(key + "_x", (byte)coord.x);
        tag.m_128344_(key + "_y", (byte)coord.y);
        tag.m_128344_(key + "_z", (byte)coord.z);
    }

    public static TileCoord loadTileCoord(CompoundTag tag, String key) {
        return new TileCoord(tag.m_128445_(key + "_x"), tag.m_128445_(key + "_y"), tag.m_128445_(key + "_z"));
    }

    public static void saveTileCoordList(CompoundTag tag, String key, Iterable<TileCoord> coordList) {
        ListTag list = new ListTag();
        for (TileCoord coord : coordList) {
            list.add((Object)EditorDataUtils.tileCoordToNBT(coord));
        }
        tag.m_128365_(key, (Tag)list);
    }

    public static void loadTileCoordList(CompoundTag tag, String key, List<TileCoord> coordList) {
        ListTag list = tag.m_128437_(key, 10);
        for (int i = 0; i < list.size(); ++i) {
            coordList.add(EditorDataUtils.tileCoordFromNBT(list.m_128728_(i)));
        }
    }

    public static CompoundTag tileCoordToNBT(TileCoord coord) {
        CompoundTag tag = new CompoundTag();
        EditorDataUtils.saveTileCoord(tag, "", coord);
        return tag;
    }

    public static TileCoord tileCoordFromNBT(CompoundTag tag) {
        return EditorDataUtils.loadTileCoord(tag, "");
    }
}

