/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.editor.tools;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mrtjp.fengine.TileCoord;
import mrtjp.projectred.fabrication.editor.ICEditorToolType;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IICEditorTool {
    public ICEditorToolType getToolType();

    public void bindEditor(ICWorkbenchEditor var1);

    public void readPacket(MCDataInput var1);

    public boolean toolStart(Vector3 var1, int var2);

    public boolean toolReleased(Vector3 var1, int var2);

    public boolean toolDragged(Vector3 var1, Vector3 var2, int var3);

    public boolean toolScrolled(Vector3 var1, double var2);

    public boolean toolCanceled();

    public void toolLayerChanged(int var1, int var2);

    public void toolActivated();

    public void toolDeactivated();

    default public boolean toolKeyPressed(Vector3 mousePosition, int glfwKeyCode, int glfwFlags) {
        return false;
    }

    default public boolean toolKeyReleased(Vector3 mousePosition, int glfwKeyCode, int glfwFlags) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderOverlay(Vector3 var1, boolean var2, CCRenderState var3, MultiBufferSource var4, PoseStack var5);

    @OnlyIn(value=Dist.CLIENT)
    public void buildTooltip(Vector3 var1, boolean var2, List<Component> var3);

    public static TileCoord toNearestPosition(Vector3 v) {
        return new TileCoord((int)Math.floor(v.x), (int)Math.floor(v.y), (int)Math.floor(v.z));
    }

    public static boolean isSamePosition(Vector3 a, Vector3 b) {
        return Math.floor(a.x) == Math.floor(b.x) && Math.floor(a.y) == Math.floor(b.y) && Math.floor(a.z) == Math.floor(b.z);
    }

    public static Cuboid6 toNearestCuboid(Vector3 v) {
        return new Cuboid6(v.copy().floor(), v.copy().ceil());
    }

    public static Cuboid6 toSelectionCuboid(Vector3 a, Vector3 b) {
        return IICEditorTool.toNearestCuboid(a).enclose(IICEditorTool.toNearestCuboid(b));
    }

    public static Cuboid6 internalToGlobalCuboid(TileCoord pos, Cuboid6 c) {
        Cuboid6 box = c.copy();
        box.add((double)pos.x, (double)pos.y, (double)pos.z);
        return box;
    }
}

