/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mrtjp.projectred.fabrication.editor.EditorDataUtils;
import mrtjp.projectred.fabrication.engine.InterfaceSpec;
import mrtjp.projectred.fabrication.init.FabricationBlocks;
import mrtjp.projectred.fabrication.init.FabricationItems;
import mrtjp.projectred.integration.GateType;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ICBlueprintItem
extends Item {
    public ICBlueprintItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_77624_2_, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        ICBlueprintItem.buildTooltip(stack.m_41783_(), tooltipList);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null || !player.m_7500_()) {
            return InteractionResult.PASS;
        }
        if (!EditorDataUtils.canFabricate(stack.m_41783_())) {
            return InteractionResult.PASS;
        }
        BlockState blockState = context.m_43725_().m_8055_(context.m_8083_());
        if (blockState.m_60734_() == FabricationBlocks.IC_WORKBENCH_BLOCK.get()) {
            return InteractionResult.PASS;
        }
        ItemStack gate = GateType.FABRICATED_GATE.makeStack();
        gate.m_41751_(EditorDataUtils.createFabricationCopy(Objects.requireNonNull(stack.m_41783_())));
        player.m_36356_(gate);
        return InteractionResult.SUCCESS;
    }

    public static void buildTooltip(@Nullable CompoundTag blueprintTag, List<Component> tooltipList) {
        if (blueprintTag == null) {
            return;
        }
        if (!EditorDataUtils.hasFabricationTarget(blueprintTag)) {
            tooltipList.add((Component)Component.m_237113_((String)"<!> ").m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237115_((String)"projectred_fabrication.tooltip.corrupted_discard").m_130940_(ChatFormatting.GRAY)));
            return;
        }
        tooltipList.add((Component)Component.m_237115_((String)"projectred_fabrication.tooltip.name").m_130946_(": " + blueprintTag.m_128461_("ic_name")).m_130940_(ChatFormatting.GRAY));
        tooltipList.add((Component)Component.m_237115_((String)"projectred_fabrication.tooltip.tile_count").m_130946_(": " + blueprintTag.m_128451_("tile_count")).m_130940_(ChatFormatting.GRAY));
        tooltipList.add((Component)Component.m_237115_((String)"projectred_fabrication.tooltip.io_types").m_130946_(": ").m_130940_(ChatFormatting.GRAY));
        InterfaceSpec spec = EditorDataUtils.getInterfaceSpec(blueprintTag);
        MutableComponent indent = Component.m_237113_((String)"  ");
        tooltipList.add((Component)indent.m_6881_().m_7220_((Component)Component.m_237115_((String)"projectred_fabrication.tooltip.top")).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)spec.getInterfaceType(0).getUnlocalName())).m_130940_(ChatFormatting.GRAY));
        tooltipList.add((Component)indent.m_6881_().m_7220_((Component)Component.m_237115_((String)"projectred_fabrication.tooltip.right")).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)spec.getInterfaceType(1).getUnlocalName())).m_130940_(ChatFormatting.GRAY));
        tooltipList.add((Component)indent.m_6881_().m_7220_((Component)Component.m_237115_((String)"projectred_fabrication.tooltip.bottom")).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)spec.getInterfaceType(2).getUnlocalName())).m_130940_(ChatFormatting.GRAY));
        tooltipList.add((Component)indent.m_6881_().m_7220_((Component)Component.m_237115_((String)"projectred_fabrication.tooltip.left")).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)spec.getInterfaceType(3).getUnlocalName())).m_130940_(ChatFormatting.GRAY));
        tooltipList.add((Component)Component.m_237115_((String)"projectred_fabrication.tooltip.input_mask").m_130946_(String.format(": 0x%X", spec.getInputMask())).m_130940_(ChatFormatting.GRAY));
        tooltipList.add((Component)Component.m_237115_((String)"projectred_fabrication.tooltip.output_mask").m_130946_(String.format(": 0x%X", spec.getOutputMask())).m_130940_(ChatFormatting.GRAY));
        int warningCount = EditorDataUtils.getWarningCount(blueprintTag);
        int errorCount = EditorDataUtils.getErrorCount(blueprintTag);
        if (warningCount > 0) {
            tooltipList.add((Component)Component.m_237113_((String)"<!> ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237110_((String)"projectred_fabrication.f.unit.warnings", (Object[])new Object[]{warningCount}).m_130940_(ChatFormatting.GRAY)));
        }
        if (errorCount > 0) {
            tooltipList.add((Component)Component.m_237113_((String)"<!> ").m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237110_((String)"projectred_fabrication.f.unit.errors", (Object[])new Object[]{errorCount}).m_130940_(ChatFormatting.GRAY)));
        }
        if (!EditorDataUtils.isBuilt(blueprintTag)) {
            tooltipList.add((Component)Component.m_237113_((String)" - ").m_7220_((Component)Component.m_237115_((String)"projectred_fabrication.tooltip.fab_err.not_compiled")).m_130940_(ChatFormatting.RED));
        }
        if (!EditorDataUtils.isCompileFormatValid(blueprintTag)) {
            tooltipList.add((Component)Component.m_237113_((String)" - ").m_7220_((Component)Component.m_237115_((String)"projectred_fabrication.tooltip.fab_err.compile_format")).m_130940_(ChatFormatting.RED));
        }
        if (!EditorDataUtils.canFabricate(blueprintTag)) {
            tooltipList.add((Component)Component.m_237113_((String)" - ").m_7220_((Component)Component.m_237115_((String)"projectred_fabrication.tooltip.fab_err.generic")).m_130940_(ChatFormatting.RED));
        }
    }

    private static Component getBundledIOTextComponent(byte bmask, int r) {
        int i = 1 << r;
        int o = 16 << r;
        return Component.m_237115_((String)((bmask & i) != 0 ? "projectred_fabrication.tooltip.bundled_input" : ((bmask & o) != 0 ? "projectred_fabrication.tooltip.bundled_output" : "projectred_fabrication.tooltip.io_none")));
    }

    public static ItemStack createPhotomaskStack(ItemStack blueprintStack) {
        ItemStack photomaskStack = new ItemStack((ItemLike)FabricationItems.PHOTOMASK_SET_ITEM.get());
        CompoundTag blueprintTag = blueprintStack.m_41783_();
        if (!EditorDataUtils.hasFabricationTarget(blueprintTag)) {
            return photomaskStack;
        }
        CompoundTag photomaskTag = EditorDataUtils.createFabricationCopy(blueprintTag);
        photomaskStack.m_41751_(photomaskTag);
        return photomaskStack;
    }
}

