/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.potion.EyesPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class DeathCollectionEyesPotion
extends EyesPotion {
    protected DeathCollectionEyesPotion() {
        super(ModEffects.getColorNumber(50, 168, 82));
    }

    public static boolean deathCollectionEyesLivingDeath(LivingEntity entity, DamageSource source) {
        boolean ret = false;
        if (!entity.m_9236_().f_46443_) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                IMahou mahou = Utils.getPlayerMahou(player);
                if (mahou != null && mahou.getDeathCollectionUsesLeft() >= 1.0f && source != entity.m_269291_().m_269341_()) {
                    ret = true;
                    mahou.setDeathCollectionUsesLeft(mahou.getDeathCollectionUsesLeft() - 1.0f);
                    player.m_21153_(12.0f);
                } else {
                    DeathCollectionEyesPotion.notifyNearby((LivingEntity)player);
                }
            } else {
                DeathCollectionEyesPotion.notifyNearby(entity);
            }
        }
        return ret;
    }

    public static void notifyNearby(LivingEntity me) {
        int range = MTConfig.DEATH_COLLECTION_RANGE_FROM_USER;
        AABB aabb = new AABB(me.m_20185_() - (double)range, me.m_20186_() - (double)range, me.m_20189_() - (double)range, me.m_20185_() + (double)range, me.m_20186_() + (double)range, me.m_20189_() + (double)range);
        if (me != null && !me.m_213877_()) {
            List players = me.m_9236_().m_6443_(Player.class, aabb, Entity::m_6084_);
            for (Player p : players) {
                IMahou mahou;
                if (p == null || !p.m_6084_() || p.m_20148_().equals(me.m_20148_()) || !EffectUtil.isLookingAtMe(me, (LivingEntity)p) || (mahou = Utils.getPlayerMahou(p)) == null || !EffectUtil.hasBuff((LivingEntity)p, ModEffects.DEATH_COLLECTION_EYES)) continue;
                if (me instanceof Player) {
                    mahou.setDeathCollectionUsesLeft((float)((double)mahou.getDeathCollectionUsesLeft() + MTConfig.DEATH_COLLECTION_SOUL_VALUE_PLAYER));
                } else {
                    mahou.setDeathCollectionUsesLeft((float)((double)mahou.getDeathCollectionUsesLeft() + MTConfig.DEATH_COLLECTION_SOUL_VALUE_MOB));
                }
                mahou.setDeathCollectionUsesLeft((float)Math.min((double)mahou.getDeathCollectionUsesLeft(), MTConfig.DEATH_COLLECTION_MAX));
                p.m_5661_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Death collected. Total number of souls collected: " + mahou.getDeathCollectionUsesLeft())), true);
            }
        }
    }
}

