/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.worldgen.treedecorators;

import com.blackgear.vanillabackport.common.level.blocks.HangingMossBlock;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.blackgear.vanillabackport.common.registries.ModTreeDecorators;
import com.blackgear.vanillabackport.common.worldgen.features.TheGardenAwakensFeatures;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class PaleMossDecorator
extends TreeDecorator {
    public static final Codec<PaleMossDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("leaves_probability").forGetter(decorator -> Float.valueOf(decorator.leavesProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("trunk_probability").forGetter(decorator -> Float.valueOf(decorator.trunkProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("ground_probability").forGetter(decorator -> Float.valueOf(decorator.groundProbability))).apply((Applicative)instance, PaleMossDecorator::new));
    private final float leavesProbability;
    private final float trunkProbability;
    private final float groundProbability;

    public PaleMossDecorator(float leavesProbability, float trunkProbability, float groundProbability) {
        this.leavesProbability = leavesProbability;
        this.trunkProbability = trunkProbability;
        this.groundProbability = groundProbability;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return ModTreeDecorators.PALE_MOSS.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        RandomSource random = context.m_226067_();
        WorldGenLevel level = (WorldGenLevel)context.m_226058_();
        List positions = Util.m_214611_((ObjectArrayList)context.m_226068_(), (RandomSource)random);
        if (!positions.isEmpty()) {
            MutableObject mutable = new MutableObject((Object)((BlockPos)positions.get(0)));
            positions.forEach(arg_0 -> PaleMossDecorator.lambda$place$4((Mutable)mutable, arg_0));
            BlockPos position = (BlockPos)mutable.getValue();
            if (random.m_188501_() < this.groundProbability) {
                level.m_9598_().m_254861_(Registries.f_256911_).flatMap(registry -> registry.m_254902_(TheGardenAwakensFeatures.PALE_MOSS_PATCH)).ifPresent(reference -> ((ConfiguredFeature)reference.m_203334_()).m_224953_(level, level.m_6018_().m_7726_().m_8481_(), random, position.m_7494_()));
            }
            context.m_226068_().forEach(pos -> {
                BlockPos below;
                if (random.m_188501_() < this.trunkProbability && context.m_226059_(below = pos.m_7495_())) {
                    PaleMossDecorator.addMossHanger(below, context);
                }
            });
            context.m_226069_().forEach(pos -> {
                BlockPos below;
                if (random.m_188501_() < this.leavesProbability && context.m_226059_(below = pos.m_7495_())) {
                    PaleMossDecorator.addMossHanger(below, context);
                }
            });
        }
    }

    private static void addMossHanger(BlockPos pos, TreeDecorator.Context context) {
        while (context.m_226059_(pos.m_7495_()) && context.m_226067_().m_188501_() >= 0.5f) {
            context.m_226061_(pos, (BlockState)ModBlocks.PALE_HANGING_MOSS.get().m_49966_().m_61124_((Property)HangingMossBlock.TIP, (Comparable)Boolean.valueOf(false)));
            pos = pos.m_7495_();
        }
        context.m_226061_(pos, (BlockState)ModBlocks.PALE_HANGING_MOSS.get().m_49966_().m_61124_((Property)HangingMossBlock.TIP, (Comparable)Boolean.valueOf(true)));
    }

    private static /* synthetic */ void lambda$place$4(Mutable mutable, BlockPos pos) {
        if (pos.m_123342_() < ((BlockPos)mutable.getValue()).m_123342_()) {
            mutable.setValue((Object)pos);
        }
    }
}

