/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.config;

import dev.cheos.armorpointspp.config.ApppConfigValue;
import dev.cheos.armorpointspp.core.adapter.IConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ApppConfig
implements IConfig {
    private static ApppConfig INSTANCE;
    private static final IConfig.Version VERSION;
    private static final Map<String, ApppConfigValue.BoolValue> boolConfigs;
    private static final Map<String, ApppConfigValue.IntValue> intConfigs;
    private static final Map<String, ApppConfigValue.HexValue> hexConfigs;
    private static final Map<String, ApppConfigValue.FloatValue> floatConfigs;
    private static final Map<String, ApppConfigValue.StringValue> stringConfigs;
    private static final Map<String, ApppConfigValue.EnumValue<?>> enumConfigs;

    public static void init() {
        if (INSTANCE != null) {
            return;
        }
        ApppConfig.define();
        Pair specPair = new ForgeConfigSpec.Builder().configure(ConfigBuilder::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)specPair.getRight());
        INSTANCE = new ApppConfig();
    }

    public static IConfig instance() {
        if (INSTANCE == null) {
            ApppConfig.init();
        }
        return INSTANCE;
    }

    @Override
    public boolean bool(IConfig.Option<Boolean> key) {
        return boolConfigs.containsKey(key.key()) ? (Boolean)boolConfigs.get(key.key()).get() : key.def();
    }

    @Override
    public int num(IConfig.Option<Integer> key) {
        return intConfigs.containsKey(key.key()) ? (Integer)intConfigs.get(key.key()).get() : key.def();
    }

    @Override
    public int hex(IConfig.Option<Integer> key) {
        return hexConfigs.containsKey(key.key()) ? hexConfigs.get(key.key()).get() : key.def();
    }

    @Override
    public float dec(IConfig.Option<Float> key) {
        return (floatConfigs.containsKey(key.key()) ? floatConfigs.get(key.key()).get() : key.def()).floatValue();
    }

    @Override
    public String str(IConfig.Option<String> key) {
        return stringConfigs.containsKey(key.key()) ? (String)stringConfigs.get(key.key()).get() : key.def();
    }

    @Override
    public <T extends Enum<T>> T enm(IConfig.Option<T> key) {
        return (T)(enumConfigs.containsKey(key.key()) ? enumConfigs.get(key.key()).get() : (Enum)key.def());
    }

    @Override
    @Deprecated
    public void invalidateAll() {
    }

    private static void define() {
        for (IConfig.BooleanOption booleanOption : IConfig.BooleanOption.values()) {
            if (!booleanOption.isAvailableIn(VERSION)) continue;
            boolConfigs.put(booleanOption.key(), new ApppConfigValue.BoolValue(booleanOption.key(), booleanOption.def(), booleanOption.comments()));
        }
        for (Enum enum_ : IConfig.IntegerOption.values()) {
            if (!((IConfig.IntegerOption)enum_).isAvailableIn(VERSION)) continue;
            intConfigs.put(((IConfig.IntegerOption)enum_).key(), new ApppConfigValue.IntValue(((IConfig.IntegerOption)enum_).key(), (int)((IConfig.IntegerOption)enum_).def(), ((IConfig.IntegerOption)enum_).comments()));
        }
        for (Enum enum_ : IConfig.HexOption.values()) {
            if (!((IConfig.HexOption)enum_).isAvailableIn(VERSION)) continue;
            hexConfigs.put(((IConfig.HexOption)enum_).key(), new ApppConfigValue.HexValue(((IConfig.HexOption)enum_).key(), ((IConfig.HexOption)enum_).def(), ((IConfig.HexOption)enum_).comments()));
        }
        for (Enum enum_ : IConfig.FloatOption.values()) {
            if (!((IConfig.FloatOption)enum_).isAvailableIn(VERSION)) continue;
            floatConfigs.put(((IConfig.FloatOption)enum_).key(), new ApppConfigValue.FloatValue(((IConfig.FloatOption)enum_).key(), ((IConfig.FloatOption)enum_).def().floatValue(), ((IConfig.FloatOption)enum_).min().floatValue(), ((IConfig.FloatOption)enum_).max().floatValue(), ((IConfig.FloatOption)enum_).comments()));
        }
        for (Enum enum_ : IConfig.StringOption.values()) {
            if (!((IConfig.StringOption)enum_).isAvailableIn(VERSION)) continue;
            stringConfigs.put(((IConfig.StringOption)enum_).key(), new ApppConfigValue.StringValue(((IConfig.StringOption)enum_).key(), ((IConfig.StringOption)enum_).def(), ((IConfig.StringOption)enum_).comments()));
        }
        for (IConfig.EnumOption enumOption : IConfig.EnumOption.values()) {
            if (!enumOption.isAvailableIn(VERSION)) continue;
            enumConfigs.put(enumOption.key(), ApppConfigValue.EnumValue.of(enumOption));
        }
    }

    private static ApppConfigValue<?, ?> findValue(IConfig.Option<?> option) {
        if (option instanceof IConfig.BooleanOption) {
            return boolConfigs.get(option.key());
        }
        if (option instanceof IConfig.IntegerOption) {
            return intConfigs.get(option.key());
        }
        if (option instanceof IConfig.HexOption) {
            return hexConfigs.get(option.key());
        }
        if (option instanceof IConfig.FloatOption) {
            return floatConfigs.get(option.key());
        }
        if (option instanceof IConfig.StringOption) {
            return stringConfigs.get(option.key());
        }
        if (option instanceof IConfig.EnumOption) {
            return enumConfigs.get(option.key());
        }
        return null;
    }

    static {
        VERSION = IConfig.Version.v1_19;
        boolConfigs = new HashMap<String, ApppConfigValue.BoolValue>();
        intConfigs = new HashMap<String, ApppConfigValue.IntValue>();
        hexConfigs = new HashMap<String, ApppConfigValue.HexValue>();
        floatConfigs = new HashMap<String, ApppConfigValue.FloatValue>();
        stringConfigs = new HashMap<String, ApppConfigValue.StringValue>();
        enumConfigs = new HashMap();
    }

    public static class ConfigBuilder {
        public ConfigBuilder(ForgeConfigSpec.Builder builder) {
            for (IConfig.Category category : IConfig.Category.values()) {
                builder.push(category.getPath());
                for (IConfig.Option<?> option : category.getOptions()) {
                    if (!option.isAvailableIn(VERSION)) continue;
                    ApppConfig.findValue(option).define(builder);
                }
                builder.pop(category.getPath().size());
            }
        }
    }
}

