/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.core;

import dev.cheos.armorpointspp.core.adapter.IConfig;
import dev.cheos.armorpointspp.core.adapter.IDataProvider;
import dev.cheos.armorpointspp.core.adapter.IEnchantmentHelper;
import dev.cheos.armorpointspp.core.adapter.IMath;
import dev.cheos.armorpointspp.core.adapter.IPoseStack;
import dev.cheos.armorpointspp.core.adapter.IProfiler;
import dev.cheos.armorpointspp.core.adapter.IRenderer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class RenderContext {
    public final IConfig config;
    public final IDataProvider data;
    public final IEnchantmentHelper ench;
    public final IMath math;
    public final IRenderer renderer;
    public final IPoseStack poseStack;
    public final IProfiler profiler;
    public final int x;
    public final int y;
    private Map<String, Object> properties;

    public RenderContext(IConfig config, IDataProvider data, IEnchantmentHelper ench, IMath math, IRenderer renderer, IPoseStack poseStack, IProfiler profiler, int x, int y) {
        this.config = config;
        this.data = data;
        this.ench = ench;
        this.math = math;
        this.renderer = renderer;
        this.poseStack = poseStack;
        this.profiler = profiler;
        this.x = x;
        this.y = y;
    }

    private void putProperty0(String id, Object obj) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(id, obj);
    }

    public <T> void putProperty(String id, T t) {
        this.putProperty0(id, t);
    }

    public <T> void putProperty(String id, Consumer<T> consumer) {
        this.putProperty0(id, consumer);
    }

    public <T> T property(String id) {
        return (T)(this.properties == null ? null : this.properties.get(id));
    }

    public boolean shouldRender() {
        return !this.data.hidden() && this.data.shouldDrawSurvivalElements();
    }

    public boolean shouldRenderArmor() {
        return this.shouldRender() && (this.data.armor() > 0 || this.config.bool(IConfig.BooleanOption.ARMOR_SHOW_ON_0));
    }

    public boolean shouldRenderToughness() {
        return this.shouldRender() && (this.data.toughness() > 0.0 || this.config.bool(IConfig.BooleanOption.TOUGHNESS_SHOW_ON_0));
    }
}

