/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.core.adapter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dev.cheos.armorpointspp.core.EnableState;
import dev.cheos.armorpointspp.core.FrostbiteStyle;
import dev.cheos.armorpointspp.core.RenderableText;
import dev.cheos.armorpointspp.core.Side;
import dev.cheos.armorpointspp.core.Suffix;
import dev.cheos.armorpointspp.core.texture.ITextureSheet;
import java.lang.constant.Constable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public interface IConfig {
    public static final DecimalFormat FLOAT_FORMAT = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ROOT));

    public boolean bool(Option<Boolean> var1);

    public int hex(Option<Integer> var1);

    public int num(Option<Integer> var1);

    public float dec(Option<Float> var1);

    public String str(Option<String> var1);

    public <T extends Enum<T>> T enm(Option<T> var1);

    public void invalidateAll();

    public static class EnumOption<T extends Enum<T>>
    implements Option<T> {
        public static final EnumOption<FrostbiteStyle> FROSTBITE_STYLE = new EnumOption<FrostbiteStyle>("frostbiteStyle", FrostbiteStyle.ICON, Category.GENERAL, " Frostbite heart display style (full = vanilla)", " Available: %s [default: %s]");
        public static final EnumOption<Suffix.Type> SUFFIX = new EnumOption<Suffix.Type>("suffix", Suffix.Type.SI, Category.GENERAL, " Suffix type used for displaying high numeric values", " Available: %s [default: %s]");
        public static final EnumOption<RenderableText.Alignment> ARMOR_TEXT_ALIGNMENT = new EnumOption<RenderableText.Alignment>("armorValueAlignment", RenderableText.Alignment.RIGHT, Category.TEXT_CONFIG, " if enabled, custom alignment of the armor value text", " Available: %s [default: %s]");
        public static final EnumOption<RenderableText.Alignment> HEALTH_TEXT_ALIGNMENT = new EnumOption<RenderableText.Alignment>("healthValueAlignment", RenderableText.Alignment.RIGHT, Category.TEXT_CONFIG, " if enabled, custom alignment of the health value text", " Available: %s [default: %s]");
        public static final EnumOption<RenderableText.Alignment> TOUGHNESS_TEXT_ALIGNMENT = new EnumOption<RenderableText.Alignment>("toughnessValueAlignment", RenderableText.Alignment.RIGHT, Category.TEXT_CONFIG, " if enabled, custom alignment of the toughness value text", " Available: %s [default: %s]");
        public static final EnumOption<Side> TOUGHNESS_SIDE = new EnumOption<Side>("toughnessSide", Side.LEFT, Category.GENERAL, " Determines the side of the toughness bar", " Available: %s [default: %s]", " Only effective if useToughnessBar is set to true!");
        public static final EnumOption<EnableState> TOUGHNESS_MIRRORING = new EnumOption<EnableState>("toughnessMirroring", EnableState.AUTO, Category.GENERAL, " Determines whether the thoughenss bar should be mirrored", " Available: %s [default: %s]", " Only effective if useToughnessBar is set to true!");
        public static final EnumOption<EnableState> DETAILAB_COMPAT = new EnumOption<EnableState>("detailarmorbar", EnableState.AUTO, Category.COMPAT, (List<Version>)Version.FABRIC, " Renders DetailArmorBar when below 21 armor points (AUTO), ALWAYS or NEVER", " Available: %s [default: %s]");
        private static final List<EnumOption<?>> ALL = ImmutableList.copyOf((Object[])new EnumOption[]{FROSTBITE_STYLE, SUFFIX, ARMOR_TEXT_ALIGNMENT, HEALTH_TEXT_ALIGNMENT, TOUGHNESS_TEXT_ALIGNMENT, TOUGHNESS_SIDE, TOUGHNESS_MIRRORING, DETAILAB_COMPAT});
        final String key;
        final T def;
        final Category category;
        final List<Version> versions;
        final List<String> comments;
        final Class<T> type;

        EnumOption(String key, T def, Category category, String ... comments) {
            this(key, def, category, (List<Version>)Version.ALL, comments);
        }

        EnumOption(String key, T def, Category category, List<Version> versions, String ... comments) {
            this.key = key;
            this.def = def;
            this.category = category;
            this.versions = versions;
            this.comments = (List)Arrays.stream(comments).map(s -> String.format(s, EnumOption.formatOptions(def.getClass()), def.name())).collect(ImmutableList.toImmutableList());
            this.type = def.getClass();
            this.category.options.add(this);
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public String[] comments() {
            return this.comments.toArray(new String[0]);
        }

        @Override
        public T def() {
            return this.def;
        }

        @Override
        public Category category() {
            return this.category;
        }

        @Override
        public boolean isAvailableIn(Version version) {
            return this.versions.contains((Object)version);
        }

        @Override
        public Class<T> type() {
            return this.type;
        }

        public static Iterable<EnumOption<?>> values() {
            return ALL;
        }

        private static <T extends Enum<T>> String formatOptions(Class<T> clazz) {
            StringBuilder out = new StringBuilder();
            try {
                Enum[] values = (Enum[])clazz.getEnumConstants();
                if (values != null && values.length != 0) {
                    for (int i = 0; i < values.length; ++i) {
                        out.append(i != 0 ? ", " : "").append(values[i].name());
                    }
                } else {
                    out.append("<none>");
                }
            }
            catch (Throwable t) {
                out.append("[!] <ERROR> [!]");
            }
            return out.toString();
        }
    }

    public static enum StringOption implements Option<String>
    {
        TEXTURE_SHEET("textureSheet", "default", Category.GENERAL, " Sets the texture sheet used for rendering", " See https://github.com/Cheos137/ArmorpointsPlusplus/wiki/Custom-Texture-Sheets for more information", " Builtin: %s [default: %s]");

        final String key;
        final String def;
        final Category category;
        final List<Version> versions;
        final List<String> comments;

        private StringOption(String key, String def, Category category, String ... comments) {
            this(key, def, category, (List<Version>)Version.ALL, comments);
        }

        private StringOption(String key, String def, Category category, List<Version> versions, String ... comments) {
            this.key = key;
            this.def = def;
            this.category = category;
            this.versions = versions;
            this.comments = (List)Arrays.stream(comments).map(s -> String.format(s, StringOption.formatBuiltinTexSheets(), def)).collect(ImmutableList.toImmutableList());
            this.category.options.add(this);
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public String[] comments() {
            return this.comments.toArray(new String[0]);
        }

        @Override
        public String def() {
            return this.def;
        }

        @Override
        public Category category() {
            return this.category;
        }

        @Override
        public boolean isAvailableIn(Version version) {
            return this.versions.contains((Object)version);
        }

        @Override
        public Class<String> type() {
            return String.class;
        }

        private static String formatBuiltinTexSheets() {
            StringBuilder out = new StringBuilder();
            for (int i = 0; i < ITextureSheet.builtins.size(); ++i) {
                out.append(i != 0 ? ", " : "").append((String)ITextureSheet.sheets.inverse().get((Object)ITextureSheet.builtins.get(i)));
            }
            return out.toString();
        }
    }

    public static enum FloatOption implements BoundedOption<Float>
    {
        ABSORPTION_VALUE("absorption", 0.25f, 200.0f, Category.REPRESENTATIVE, " Number of pixels to show an absorption of 1", " Available: %s ~ %s [default: %s]"),
        ARMOR_TEXT_X("armorValueX", 0.0f, 32768.0f, Category.TEXT_CONFIG, " if enabled, custom X position of the armor value text", " Available: %s ~ %s [default: %s]"),
        ARMOR_TEXT_Y("armorValueY", 0.0f, 32768.0f, Category.TEXT_CONFIG, " if enabled, custom Y position of the armor value text", " Available: %s ~ %s [default: %s]"),
        HEALTH_TEXT_X("healthValueX", 0.0f, 32768.0f, Category.TEXT_CONFIG, " if enabled, custom X position of the health value text", " Available: %s ~ %s [default: %s]"),
        HEALTH_TEXT_Y("healthValueY", 0.0f, 32768.0f, Category.TEXT_CONFIG, " if enabled, custom Y position of the health value text", " Available: %s ~ %s [default: %s]"),
        TOUGHNESS_TEXT_X("toughnessValueX", 0.0f, 32768.0f, Category.TEXT_CONFIG, " if enabled, custom X position of the toughness value text", " Available: %s ~ %s [default: %s]"),
        TOUGHNESS_TEXT_Y("toughnessValueY", 0.0f, 32768.0f, Category.TEXT_CONFIG, " if enabled, custom Y position of the toughness value text", " Available: %s ~ %s [default: %s]"),
        MAGIC_RES_VALUE("magicResist", 2.0f, 20.0f, Category.COMPAT_REP, (List<Version>)Version.V1_12, " Number of icons to show a magic resistance of 1", " Available: %s ~ %s [default: %s]"),
        PROTECTION_VALUE("protection", 0.5f, 10.0f, Category.REPRESENTATIVE, " Number of icons to show a protection of 1", " Available: %s ~ %s [default: %s]"),
        RESISTANCE_VALUE("resistance", 2.0f, 10.0f, Category.REPRESENTATIVE, " Number of icons to show a resistance of 1", " Available: %s ~ %s [default: %s]"),
        TOUGHNESS_VALUE("toughness", 1.0f, 10.0f, Category.REPRESENTATIVE, " Number of icons to show a armor toughness of 1", " Available: %s ~ %s [default: %s]", " Note: This ONLY affects toughness overlays and NOT the standalone toughness bar");

        final String key;
        final float def;
        final float min;
        final float max;
        final Category category;
        final List<Version> versions;
        final List<String> comments;

        private FloatOption(String key, float def, float max, Category category, String ... comments) {
            this(key, def, max, category, (List<Version>)Version.ALL, comments);
        }

        private FloatOption(String key, float def, float max, Category category, List<Version> versions, String ... comments) {
            this(key, def, 0.0f, max, category, versions, comments);
        }

        private FloatOption(String key, float def, float min, float max, Category category, List<Version> versions, String ... comments) {
            this.key = key;
            this.def = def;
            this.min = min;
            this.max = max;
            this.category = category;
            this.versions = versions;
            this.comments = (List)Arrays.stream(comments).map(s -> String.format(s, FLOAT_FORMAT.format(this.min), FLOAT_FORMAT.format(this.max), FLOAT_FORMAT.format(this.def))).collect(ImmutableList.toImmutableList());
            this.category.options.add(this);
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public String[] comments() {
            return this.comments.toArray(new String[0]);
        }

        @Override
        public Float def() {
            return Float.valueOf(this.def);
        }

        @Override
        public Float min() {
            return Float.valueOf(this.min);
        }

        @Override
        public Float max() {
            return Float.valueOf(this.max);
        }

        @Override
        public Category category() {
            return this.category;
        }

        @Override
        public boolean isAvailableIn(Version version) {
            return this.versions.contains((Object)version);
        }

        @Override
        public Class<Float> type() {
            return Float.class;
        }
    }

    public static enum HexOption implements BoundedOption<Integer>
    {
        TEXT_COLOR_FULL_RESISTANCE("resistanceFull", 9047823, Category.TEXT_COLOR, " Color when resistance > 5", " Available: 0x000000 ~ 0xffffff [default: %s]"),
        TEXT_COLOR_ARMOR_0("armor0", 0x3D3D3D, Category.TEXT_COLOR, " Color when armor = 0", " Available: 0x000000 ~ 0xffffff [default: %s]"),
        TEXT_COLOR_ARMOR_LT25("armorLT25", 0x44FF11, Category.TEXT_COLOR, " Color when armor < 25", " Available: 0x000000 ~ 0xffffff [default: %s]"),
        TEXT_COLOR_ARMOR_EQ25("armorEQ25", 0xFF8811, Category.TEXT_COLOR, " Color when armor = 25", " Available: 0x000000 ~ 0xffffff [default: %s]"),
        TEXT_COLOR_ARMOR_GT25("armorGT25", 0xFF3311, Category.TEXT_COLOR, " Color when armor > 25", " Available: 0x000000 ~ 0xffffff [default: %s]"),
        TEXT_COLOR_FROSTBITE("heartFrostbite", 114418, Category.TEXT_COLOR, " Color when fully frozen", " Available: 0x000000 ~ 0xffffff [default: %s]"),
        TEXT_COLOR_POISON("heartPoison", 9730072, Category.TEXT_COLOR, " Color when poisoned", " Available: 0x000000 ~ 0xffffff [default: %s]"),
        TEXT_COLOR_WITHER("heartWither", 0x2B2B2B, Category.TEXT_COLOR, " Color when withered", " Available: 0x000000 ~ 0xffffff [default: %s]"),
        TEXT_COLOR_HEART("heart", 0xFF1313, Category.TEXT_COLOR, " Color normal status", " Available: 0x000000 ~ 0xffffff [default: %s]"),
        TEXT_COLOR_ABSORPTION("absorption", 16761600, Category.TEXT_COLOR, " Color of absorption", " Available: 0x000000 ~ 0xffffff [default: %s]"),
        TEXT_COLOR_SEPARATOR("separator", 0x3D3D3D, Category.TEXT_COLOR, " Color of separator", " Available: 0x000000 ~ 0xffffff [default: %s]"),
        TEXT_COLOR_TOUGHNESS("toughness", 0xFF8811, Category.TEXT_COLOR, " Color of toughness", " Available: 0x000000 ~ 0xffffff [default: %s]");

        final String key;
        final int def;
        final Category category;
        final List<Version> versions;
        final List<String> comments;

        private HexOption(String key, int def, Category category, String ... comments) {
            this(key, def, category, Version.ALL, comments);
        }

        private HexOption(String key, int def, Category category, ImmutableList<Version> versions, String ... comments) {
            this.key = key;
            this.def = def;
            this.category = category;
            this.versions = versions;
            this.comments = (List)Arrays.stream(comments).map(s -> String.format(s, String.format("%06x", def))).collect(ImmutableList.toImmutableList());
            this.category.options.add(this);
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public String[] comments() {
            return this.comments.toArray(new String[0]);
        }

        @Override
        public Integer def() {
            return this.def;
        }

        @Override
        public Integer min() {
            return 0;
        }

        @Override
        public Integer max() {
            return 0xFFFFFF;
        }

        @Override
        public Category category() {
            return this.category;
        }

        @Override
        public boolean isAvailableIn(Version version) {
            return this.versions.contains((Object)version);
        }

        @Override
        public Class<Integer> type() {
            return Integer.class;
        }
    }

    public static enum IntegerOption implements BoundedOption<Integer>
    {
        TABLIST_MAX_HEART_COUNT("maxTablistHeartCount", 10, 1, 10, Category.GENERAL, (List<Version>)Version.V1_16UP, "Sets the max number of hearts rendered in the tablist", " Available: %s ~ %s [default: %s]");

        final String key;
        final int def;
        final int min;
        final int max;
        final Category category;
        final List<Version> versions;
        final List<String> comments;

        private IntegerOption(String key, int def, Category category, String ... comments) {
            this(key, def, category, (List<Version>)Version.ALL, comments);
        }

        private IntegerOption(String key, int def, Category category, List<Version> versions, String ... comments) {
            this(key, def, Integer.MAX_VALUE, category, versions, comments);
        }

        private IntegerOption(String key, int def, int max, Category category, List<Version> versions, String ... comments) {
            this(key, def, 0, max, category, versions, comments);
        }

        private IntegerOption(String key, int def, int min, int max, Category category, List<Version> versions, String ... comments) {
            this.key = key;
            this.def = def;
            this.min = min;
            this.max = max;
            this.category = category;
            this.versions = versions;
            this.comments = (List)Arrays.stream(comments).map(s -> String.format(s, Integer.toString(min), Integer.toString(max), Integer.toString(def))).collect(ImmutableList.toImmutableList());
            this.category.options.add(this);
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public String[] comments() {
            return this.comments.toArray(new String[0]);
        }

        @Override
        public Integer def() {
            return this.def;
        }

        @Override
        public Integer min() {
            return this.min;
        }

        @Override
        public Integer max() {
            return this.max;
        }

        @Override
        public Category category() {
            return this.category;
        }

        @Override
        public boolean isAvailableIn(Version version) {
            return this.versions.contains((Object)version);
        }

        @Override
        public Class<Integer> type() {
            return Integer.class;
        }
    }

    public static enum BooleanOption implements Option<Boolean>
    {
        ABSORPTION_ENABLE("enableAbsorption", true, Category.GENERAL, " Show absorption as border around health", " Available: true, false [default: %s]"),
        ABSORPTION_OVERLAY("useAbsorptionOverlay", false, Category.GENERAL, " Show absorption as hearts within the health bar", " Available: true, false [default: %s]"),
        ARMOR_ENABLE("enableArmorBar", true, Category.GENERAL, " Enable custom armor bar", " Available: true, false [default: %s]"),
        ARMOR_HIDDEN("hideArmorBar", false, Category.GENERAL, " Hides the armor bar + armor value text regardless of other config optoins", " Available: true, false [default: %s]"),
        ARMOR_TEXT_ENABLE("showArmorValue", true, Category.GENERAL, " Show armor value text next to armor bar", " Available: true, false [default: %s]"),
        ARMOR_TEXT_CONFIG_ENABLE("enableArmorValueConfig", false, Category.TEXT_CONFIG, " Enables custom armor value configuration", " Available: true, false [default: %s]"),
        ARMOR_SHOW_ON_0("showArmorWhenZero", false, Category.GENERAL, " Show armor bar when armor is zero", " Available: true, false [default: %s]"),
        DEBUG("debug", false, Category.GENERAL_DEBUG, " You don't want this to be on. Believe me", " Available: true, false [default: %s]"),
        DISABLE_EASTEREGGS("disableEastereggs", false, Category.GENERAL, " Disables all easter eggs, which is sad but some want it", " Available: true, false [default: %s]"),
        FROSTBITE_TEXT_ENABLE("showFrostbitePercentage", true, Category.GENERAL, " Show frostbite percentage next to health bar", " Available: true, false [default: %s]"),
        HEALTH_ENABLE("enableHealthBar", true, Category.GENERAL, " Enable custom health bar", " Available: true, false [default: %s]"),
        HEALTH_HIDDEN("hideHealthBar", false, Category.GENERAL, " Hides the health bar + health value text regardless of other config optoins", " Available: true, false [default: %s]"),
        HEALTH_TEXT_ENABLE("showHealthValue", true, Category.GENERAL, " Show health value text next to health bar", " Available: true, false [default: %s]"),
        HEALTH_TEXT_CONFIG_ENABLE("enableHealthValueConfig", false, Category.TEXT_CONFIG, " Enables custom health value configuration", " Available: true, false [default: %s]"),
        HEALTH_BG_ALWAYS_SHOW_10("alwaysShow10HeartBGs", false, Category.GENERAL, " Always render 10 heart backgrounds, even if max health is lower", " Available: true, false [default: %s]"),
        HIDE_COMPAT_WARNINGS("hideCompatWarnings", false, Category.COMPAT, " Hides all compatibility warnings...", "I don't recommend switching this on except for pack authors", " Available: true, false [default: %s]"),
        MANTLE_COMPAT("mantle", true, Category.COMPAT, Version.V1_12, " Fixes mantle compatibility", " Available: true, false [default: %s]"),
        POTIONCORE_COMPAT("potioncore", true, Category.COMPAT, Version.V1_12, " Adds support for potioncore's effects and attributes", " Available: true, false [default: %s]"),
        PROTECTION_ENABLE("showProtection", true, Category.GENERAL, " Show protection as overlay over armor", " Available: true, false [default: %s]"),
        RESISTANCE_ENABLE("showResistance", true, Category.GENERAL, " Show resistance as border around armor", " Available: true, false [default: %s]"),
        TABLIST_HEALTH_ENABLE("enableTablistHealth", true, Category.GENERAL, Version.V1_16UP, " Enable custom tablist health rendering (displaytype health)", " Available: true, false [default: %s]"),
        TABLIST_HEALTH_ALWAYS_MAX("alwaysShowMaxTablistHearts", true, Category.GENERAL, Version.V1_16UP, " Always render max (configured) heart backgrounds in tablist, even if health is lower", " Available: true, false [default: %s]"),
        TEXT_SHADOW("textShadow", true, Category.GENERAL, " Draw shadows for all rendered texts", " Available: true, false [default: %s]"),
        TOUGHNESS_BAR("useToughnessBar", false, Category.GENERAL, " Show toughness as it's own bar", " Available: true, false [default: %s]"),
        TOUGHNESS_ENABLE("enableToughness", true, Category.GENERAL, " Show toughness as overlay over armor or its own bar", " Available: true, false [default: %s]"),
        TOUGHNESS_SHOW_ON_0("showToughnessWhenZero", false, Category.GENERAL, " Show toughness bar when toughness is zero", " Available: true, false [default: %s]"),
        TOUGHNESS_TEXT_ENABLE("showToughnessValue", true, Category.GENERAL, " Show toughness value text next to toughness bar", " Available: true, false [default: %s]"),
        TOUGHNESS_TEXT_CONFIG_ENABLE("enableToughnessValueConfig", false, Category.TEXT_CONFIG, " Enables custom toughness value configuration", " Available: true, false [default: %s]");

        final String key;
        final boolean def;
        final Category category;
        final ImmutableList<Version> versions;
        final ImmutableList<String> comments;

        private BooleanOption(String key, boolean def, Category category, String ... comments) {
            this(key, def, category, Version.ALL, comments);
        }

        private BooleanOption(String key, boolean def, Category category, ImmutableList<Version> versions, String ... comments) {
            this.key = key;
            this.def = def;
            this.category = category;
            this.versions = versions;
            this.comments = (ImmutableList)Arrays.stream(comments).map(s -> String.format(s, def)).collect(ImmutableList.toImmutableList());
            this.category.options.add(this);
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public String[] comments() {
            return (String[])this.comments.toArray((Object[])new String[0]);
        }

        @Override
        public Boolean def() {
            return this.def;
        }

        @Override
        public Category category() {
            return this.category;
        }

        @Override
        public boolean isAvailableIn(Version version) {
            return this.versions.contains((Object)version);
        }

        @Override
        public Class<Boolean> type() {
            return Boolean.class;
        }
    }

    public static interface BoundedOption<T>
    extends Option<T> {
        public T min();

        public T max();
    }

    public static interface Option<T> {
        public String key();

        public String[] comments();

        public T def();

        public Category category();

        public boolean isAvailableIn(Version var1);

        public Class<T> type();

        default public BoundedOption<T> asBounded() {
            return this instanceof BoundedOption ? (BoundedOption)this : new NullBoundedOptionWrapper(this);
        }

        public static class NullBoundedOptionWrapper<T>
        implements BoundedOption<T> {
            private final Option<T> opt;
            private final boolean num;
            private final boolean bool;

            private NullBoundedOptionWrapper(Option<T> opt) {
                this.opt = opt;
                this.num = opt.def() instanceof Number;
                this.bool = opt.def() instanceof Boolean;
            }

            @Override
            public String key() {
                return this.opt.key();
            }

            @Override
            public String[] comments() {
                return this.opt.comments();
            }

            @Override
            public T def() {
                return this.opt.def();
            }

            @Override
            public Category category() {
                return this.opt.category();
            }

            @Override
            public boolean isAvailableIn(Version version) {
                return this.opt.isAvailableIn(version);
            }

            @Override
            public Class<T> type() {
                return this.opt.type();
            }

            @Override
            public T min() {
                return (T)(this.num ? (Constable)Integer.valueOf(0) : (Constable)(this.bool ? Boolean.valueOf(false) : null));
            }

            @Override
            public T max() {
                return (T)(this.num ? (Constable)Integer.valueOf(0) : (Constable)(this.bool ? Boolean.valueOf(false) : null));
            }
        }
    }

    public static enum Version {
        v1_12,
        v1_16,
        v1_17,
        v1_18,
        v1_19,
        v1_18fabric,
        v1_19fabric;

        public static final ImmutableList<Version> ALL;
        public static final ImmutableList<Version> NONE;
        public static final ImmutableList<Version> FABRIC;
        public static final ImmutableList<Version> V1_12;
        public static final ImmutableList<Version> V1_16;
        public static final ImmutableList<Version> V1_17;
        public static final ImmutableList<Version> V1_18;
        public static final ImmutableList<Version> V1_19;
        public static final ImmutableList<Version> V1_18UP;
        public static final ImmutableList<Version> V1_17UP;
        public static final ImmutableList<Version> V1_16UP;
        public static final ImmutableList<Version> V1_12UP;

        static {
            ALL = ImmutableList.copyOf((Object[])Version.values());
            NONE = ImmutableList.of();
            FABRIC = ImmutableList.of((Object)((Object)v1_18fabric), (Object)((Object)v1_19fabric));
            V1_12 = ImmutableList.of((Object)((Object)v1_12));
            V1_16 = ImmutableList.of((Object)((Object)v1_16));
            V1_17 = ImmutableList.of((Object)((Object)v1_17));
            V1_18 = ImmutableList.of((Object)((Object)v1_18), (Object)((Object)v1_18fabric));
            V1_19 = ImmutableList.of((Object)((Object)v1_19), (Object)((Object)v1_19fabric));
            V1_18UP = ImmutableList.builder().addAll(V1_19).addAll(V1_18).build();
            V1_17UP = ImmutableList.builder().addAll(V1_18UP).addAll(V1_17).build();
            V1_16UP = ImmutableList.builder().addAll(V1_17UP).addAll(V1_16).build();
            V1_12UP = ImmutableList.builder().addAll(V1_16UP).addAll(V1_12).build();
        }
    }

    public static enum Category {
        COMPAT("compatibility"),
        COMPAT_REP("compatibility.representative"),
        GENERAL("general"),
        GENERAL_DEBUG("general.debug"),
        REPRESENTATIVE("representative"),
        TEXT_COLOR("textcolors"),
        TEXT_CONFIG("textconfig");

        private final List<String> path;
        private final String pathJoined;
        private final Set<Category> subCategories = new HashSet<Category>();
        private final Set<Option<?>> options = new HashSet();

        private Category(String path) {
            this.path = ImmutableList.copyOf(Arrays.asList(path.split("\\.")));
            this.pathJoined = path;
        }

        public List<String> getPath() {
            return this.path;
        }

        public String getPathJoined() {
            return this.pathJoined;
        }

        public Set<Option<?>> getOptions() {
            return ImmutableSet.copyOf(this.options);
        }

        public boolean hasOptions(Version version) {
            return !this.options.stream().noneMatch(o -> o.isAvailableIn(version));
        }

        public Set<Category> getSubCategories() {
            return ImmutableSet.copyOf(this.subCategories);
        }

        static {
            Category.COMPAT.subCategories.add(COMPAT_REP);
            Category.GENERAL.subCategories.add(GENERAL_DEBUG);
        }
    }
}

