/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.core.render;

import dev.cheos.armorpointspp.core.IRenderComponent;
import dev.cheos.armorpointspp.core.RenderContext;
import dev.cheos.armorpointspp.core.RenderableText;
import dev.cheos.armorpointspp.core.Suffix;
import dev.cheos.armorpointspp.core.adapter.IConfig;
import java.awt.Color;

public class ArmorTextComponent
implements IRenderComponent {
    @Override
    public boolean render(RenderContext ctx) {
        int power;
        if (!ctx.shouldRenderArmor() || !ctx.config.bool(IConfig.BooleanOption.ARMOR_TEXT_ENABLE) || ctx.config.bool(IConfig.BooleanOption.ARMOR_HIDDEN)) {
            return false;
        }
        ctx.profiler.push("armorText");
        int armor = ctx.data.armor();
        Suffix.Type type = ctx.config.enm(IConfig.EnumOption.SUFFIX);
        int resistance = ctx.data.isEffectActive(ctx.data.effects().resistance()) ? ctx.data.getActiveEffect(ctx.data.effects().resistance()).amplifier() : 0;
        int n = power = armor == 0 ? 0 : (int)Math.log10(armor);
        if (type != Suffix.Type.SCI && power < 27) {
            power = power / 3 * 3;
        } else {
            type = Suffix.Type.SCI;
        }
        Object significand = String.valueOf((float)ctx.math.floor((double)armor / Math.pow(10.0, power) * 10.0) / 10.0f);
        if (((String)significand).endsWith(".0")) {
            significand = ((String)significand).substring(0, ((String)significand).length() - 2);
        }
        significand = (String)significand + (String)(type == Suffix.Type.SCI ? "E" + power : Suffix.byPow(power).getSuffix(type));
        int color = !ctx.config.bool(IConfig.BooleanOption.DISABLE_EASTEREGGS) && armor == Math.min(137, ctx.data.maxArmor()) ? Color.HSBtoRGB((float)((ctx.data.millis() + 80L) / 40L % 360L) / 360.0f, 1.0f, 1.0f) : (resistance >= 4 ? ctx.config.hex(IConfig.HexOption.TEXT_COLOR_FULL_RESISTANCE) : (armor == 0 ? ctx.config.hex(IConfig.HexOption.TEXT_COLOR_ARMOR_0) : (armor < 25 ? ctx.config.hex(IConfig.HexOption.TEXT_COLOR_ARMOR_LT25) : (armor > 25 ? ctx.config.hex(IConfig.HexOption.TEXT_COLOR_ARMOR_GT25) : ctx.config.hex(IConfig.HexOption.TEXT_COLOR_ARMOR_EQ25)))));
        if (ctx.config.bool(IConfig.BooleanOption.ARMOR_TEXT_CONFIG_ENABLE)) {
            new RenderableText((String)significand).withAlignment(ctx.config.enm(IConfig.EnumOption.ARMOR_TEXT_ALIGNMENT)).withColor(color).withShadow(ctx.config.bool(IConfig.BooleanOption.TEXT_SHADOW)).append(ArmorTextComponent.toughness(ctx)).render(ctx.poseStack, ctx.renderer, ctx.config.dec(IConfig.FloatOption.ARMOR_TEXT_X), ctx.config.dec(IConfig.FloatOption.ARMOR_TEXT_Y));
        } else {
            new RenderableText((String)significand).withAlignment(RenderableText.Alignment.RIGHT).withColor(color).withShadow(ctx.config.bool(IConfig.BooleanOption.TEXT_SHADOW)).append(ArmorTextComponent.toughness(ctx)).render(ctx.poseStack, ctx.renderer, ctx.x - 1, (float)ctx.y + 0.5f);
        }
        return this.popReturn(ctx, true);
    }

    private static RenderableText toughness(RenderContext ctx) {
        int power;
        if (!ctx.config.bool(IConfig.BooleanOption.TOUGHNESS_ENABLE) || ctx.config.bool(IConfig.BooleanOption.TOUGHNESS_BAR)) {
            return RenderableText.EMPTY;
        }
        double toughness = ctx.data.toughness();
        if (toughness == 0.0) {
            return RenderableText.EMPTY;
        }
        Suffix.Type type = ctx.config.enm(IConfig.EnumOption.SUFFIX);
        int n = power = toughness == 0.0 ? 0 : (int)Math.log10(toughness);
        if (type != Suffix.Type.SCI && power < 27) {
            power -= power % 3;
        } else {
            type = Suffix.Type.SCI;
        }
        Object significand = String.valueOf((float)ctx.math.floor(toughness / Math.pow(10.0, power) * 10.0) / 10.0f);
        if (((String)significand).endsWith(".0")) {
            significand = ((String)significand).substring(0, ((String)significand).length() - 2);
        }
        significand = (String)significand + (String)(type == Suffix.Type.SCI ? "E" + power : Suffix.byPow(power).getSuffix(type));
        int color = ctx.config.hex(IConfig.HexOption.TEXT_COLOR_TOUGHNESS);
        return new RenderableText("+").pad(1.0f).withColor(ctx.config.hex(IConfig.HexOption.TEXT_COLOR_SEPARATOR)).append(new RenderableText((String)significand).withColor(color));
    }
}

